/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.behaviors;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import com.google.common.base.Preconditions;
import net.minecraft.class_1657;
import org.jetbrains.annotations.Nullable;

public class ContainerItemContext {
    private final ContainerItemStrategy<AEKey, Object> strategy;
    private final Object context;
    private final AEKeyType type;

    protected ContainerItemContext(ContainerItemStrategy<AEKey, Object> strategy, Object context, AEKeyType type) {
        this.strategy = strategy;
        this.context = context;
        this.type = type;
    }

    @Nullable
    public GenericStack getExtractableContent() {
        return this.strategy.getExtractableContent(this.context);
    }

    public long insert(AEKey key, long amount, Actionable mode) {
        Preconditions.checkArgument((boolean)this.type.contains(key), (Object)"Internal logic error: mismatched key and type");
        return this.strategy.insert(this.context, key, amount, mode);
    }

    public long extract(AEKey key, long amount, Actionable mode) {
        Preconditions.checkArgument((boolean)this.type.contains(key), (Object)"Internal logic error: mismatched key and type");
        return this.strategy.extract(this.context, key, amount, mode);
    }

    public void playFillSound(class_1657 player, AEKey what) {
        this.strategy.playFillSound(player, what);
    }

    public void playEmptySound(class_1657 player, AEKey what) {
        this.strategy.playEmptySound(player, what);
    }
}

