/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.blockentity.misc.InscriberRecipes;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class InscriberBlockEntity
extends AENetworkPowerBlockEntity
implements IGridTickable,
IUpgradeableObject,
IConfigurableObject {
    private static final int MAX_PROCESSING_STEPS = 200;
    private final IUpgradeInventory upgrades;
    private final ConfigManager configManager;
    private int processingTime = 0;
    private boolean smash;
    private boolean repeatSmash;
    private int finalStep;
    private long clientStart;
    private final IAEItemFilter baseFilter = new BaseFilter();
    private final AppEngInternalInventory topItemHandler = new AppEngInternalInventory(this, 1, 64, this.baseFilter);
    private final AppEngInternalInventory bottomItemHandler = new AppEngInternalInventory(this, 1, 64, this.baseFilter);
    private final AppEngInternalInventory sideItemHandler = new AppEngInternalInventory(this, 2, 64, this.baseFilter);
    private final InternalInventory inv = new CombinedInternalInventory(this.topItemHandler, this.bottomItemHandler, this.sideItemHandler);
    private final Map<InternalInventory, class_1799> lastStacks = new IdentityHashMap<AppEngInternalInventory, class_1799>(Map.of(this.topItemHandler, class_1799.field_8037, this.bottomItemHandler, class_1799.field_8037, this.sideItemHandler, class_1799.field_8037));
    private final InternalInventory topItemHandlerExtern;
    private final InternalInventory bottomItemHandlerExtern;
    private final InternalInventory sideItemHandlerExtern;
    private final InternalInventory combinedItemHandlerExtern;
    private InscriberRecipe cachedTask = null;

    public InscriberBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IGridTickable.class, this);
        this.setInternalMaxPower(1600.0);
        this.upgrades = UpgradeInventories.forMachine(AEBlocks.INSCRIBER, 4, this::saveChanges);
        this.configManager = new ConfigManager(this::onConfigChanged);
        this.configManager.registerSetting(Settings.INSCRIBER_SEPARATE_SIDES, YesNo.NO);
        this.configManager.registerSetting(Settings.AUTO_EXPORT, YesNo.NO);
        AutomationFilter automationFilter = new AutomationFilter();
        this.topItemHandlerExtern = new FilteredInternalInventory(this.topItemHandler, automationFilter);
        this.bottomItemHandlerExtern = new FilteredInternalInventory(this.bottomItemHandler, automationFilter);
        this.sideItemHandlerExtern = new FilteredInternalInventory(this.sideItemHandler, automationFilter);
        this.combinedItemHandlerExtern = new CombinedInternalInventory(this.topItemHandlerExtern, this.bottomItemHandlerExtern, this.sideItemHandlerExtern);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.upgrades.writeToNBT(data, "upgrades");
        this.configManager.writeToNBT(data);
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.configManager.readFromNBT(data);
        this.lastStacks.put(this.topItemHandler, this.topItemHandler.getStackInSlot(0));
        this.lastStacks.put(this.bottomItemHandler, this.bottomItemHandler.getStackInSlot(0));
        this.lastStacks.put(this.sideItemHandler, this.sideItemHandler.getStackInSlot(0));
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean newSmash;
        boolean c = super.readFromStream(data);
        boolean oldSmash = this.isSmash();
        if (oldSmash != (newSmash = data.readBoolean()) && newSmash) {
            this.setSmash(true);
        }
        for (int i = 0; i < this.inv.size(); ++i) {
            this.inv.setItemDirect(i, data.method_10819());
        }
        this.cachedTask = null;
        return c;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.isSmash());
        for (int i = 0; i < this.inv.size(); ++i) {
            data.method_10793(this.inv.getStackInSlot(i));
        }
    }

    @Override
    protected void saveVisualState(class_2487 data) {
        super.saveVisualState(data);
        data.method_10556("smash", this.isSmash());
    }

    @Override
    protected void loadVisualState(class_2487 data) {
        super.loadVisualState(data);
        this.setSmash(data.method_10577("smash"));
    }

    @Override
    public Set<class_2350> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.complementOf(EnumSet.of(orientation.getSide(RelativeSide.FRONT)));
    }

    @Override
    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.setPowerSides(this.getGridConnectableSides(orientation));
    }

    @Override
    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (class_1799 upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    @Override
    public void method_5448() {
        super.method_5448();
        this.upgrades.clear();
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (slot == 0) {
            boolean sameItemSameTags = class_1799.method_31577((class_1799)inv.getStackInSlot(0), (class_1799)this.lastStacks.get(inv));
            this.lastStacks.put(inv, inv.getStackInSlot(0).method_7972());
            if (sameItemSameTags) {
                return;
            }
            this.setProcessingTime(0);
            this.cachedTask = null;
        }
        if (!this.isSmash()) {
            this.markForUpdate();
        }
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber, !this.hasAutoExportWork() && !this.hasCraftWork(), false);
    }

    private boolean hasAutoExportWork() {
        return !this.sideItemHandler.getStackInSlot(1).method_7960() && this.configManager.getSetting(Settings.AUTO_EXPORT) == YesNo.YES;
    }

    private boolean hasCraftWork() {
        InscriberRecipe task = this.getTask();
        if (task != null) {
            return this.sideItemHandler.insertItem(1, task.getResultItem().method_7972(), true).method_7960();
        }
        this.setProcessingTime(0);
        return this.isSmash();
    }

    @Nullable
    public InscriberRecipe getTask() {
        if (this.cachedTask == null && this.field_11863 != null) {
            class_1799 input = this.sideItemHandler.getStackInSlot(0);
            class_1799 plateA = this.topItemHandler.getStackInSlot(0);
            class_1799 plateB = this.bottomItemHandler.getStackInSlot(0);
            if (input.method_7960()) {
                return null;
            }
            this.cachedTask = InscriberRecipes.findRecipe(this.field_11863, input, plateA, plateB, true);
        }
        return this.cachedTask;
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isSmash()) {
            ++this.finalStep;
            if (this.finalStep == 8) {
                class_1799 outputCopy;
                InscriberRecipe out = this.getTask();
                if (out != null && this.sideItemHandler.insertItem(1, outputCopy = out.getResultItem().method_7972(), false).method_7960()) {
                    this.setProcessingTime(0);
                    if (out.getProcessType() == InscriberProcessType.PRESS) {
                        this.topItemHandler.extractItem(0, 1, false);
                        this.bottomItemHandler.extractItem(0, 1, false);
                    }
                    this.sideItemHandler.extractItem(0, 1, false);
                }
                this.saveChanges();
            } else if (this.finalStep == 16) {
                this.finalStep = 0;
                this.setSmash(false);
                this.markForUpdate();
            }
        } else if (this.hasCraftWork()) {
            this.getMainNode().ifPresent(grid -> {
                IEnergyService eg = grid.getEnergyService();
                IEnergySource src = this;
                int speedFactor = switch (this.upgrades.getInstalledUpgrades(AEItems.SPEED_CARD)) {
                    default -> 2;
                    case 1 -> 3;
                    case 2 -> 5;
                    case 3 -> 10;
                    case 4 -> 50;
                };
                int powerConsumption = 10 * speedFactor;
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.setProcessingTime(this.getProcessingTime() + speedFactor);
                }
            });
            if (this.getProcessingTime() > this.getMaxProcessingTime()) {
                class_1799 outputCopy;
                this.setProcessingTime(this.getMaxProcessingTime());
                InscriberRecipe out = this.getTask();
                if (out != null && this.sideItemHandler.insertItem(1, outputCopy = out.getResultItem().method_7972(), true).method_7960()) {
                    this.setSmash(true);
                    this.finalStep = 0;
                    this.markForUpdate();
                }
            }
        }
        if (this.pushOutResult()) {
            return TickRateModulation.URGENT;
        }
        return this.hasCraftWork() ? TickRateModulation.URGENT : (this.hasAutoExportWork() ? TickRateModulation.SLOWER : TickRateModulation.SLEEP);
    }

    private boolean pushOutResult() {
        if (!this.hasAutoExportWork()) {
            return false;
        }
        EnumSet<class_2350> pushSides = EnumSet.allOf(class_2350.class);
        if (this.isSeparateSides()) {
            pushSides.remove(this.getTop());
            pushSides.remove(this.getTop().method_10153());
        }
        for (class_2350 dir : pushSides) {
            ItemTransfer target = InternalInventory.wrapExternal(this.field_11863, this.method_11016().method_10093(dir), dir.method_10153());
            if (target == null) continue;
            int startItems = this.sideItemHandler.getStackInSlot(1).method_7947();
            this.sideItemHandler.insertItem(1, target.addItems(this.sideItemHandler.extractItem(1, 64, false)), false);
            int endItems = this.sideItemHandler.getStackInSlot(1).method_7947();
            if (startItems == endItems) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)ISegmentedInventory.STORAGE)) {
            return this.getInternalInventory();
        }
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    private boolean isSeparateSides() {
        return this.configManager.getSetting(Settings.INSCRIBER_SEPARATE_SIDES) == YesNo.YES;
    }

    @Override
    public InternalInventory getExposedInventoryForSide(class_2350 facing) {
        if (this.isSeparateSides()) {
            if (facing == this.getTop()) {
                return this.topItemHandlerExtern;
            }
            if (facing == this.getTop().method_10153()) {
                return this.bottomItemHandlerExtern;
            }
            return this.sideItemHandlerExtern;
        }
        return this.combinedItemHandlerExtern;
    }

    @Override
    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    @Override
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    private void onConfigChanged(IConfigManager manager, Setting<?> setting) {
        if (setting == Settings.AUTO_EXPORT) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
        }
        if (setting == Settings.INSCRIBER_SEPARATE_SIDES) {
            this.markForUpdate();
        }
        this.saveChanges();
    }

    public long getClientStart() {
        return this.clientStart;
    }

    private void setClientStart(long clientStart) {
        this.clientStart = clientStart;
    }

    public boolean isSmash() {
        return this.smash;
    }

    public void setSmash(boolean smash) {
        if (smash && !this.smash) {
            this.setClientStart(System.currentTimeMillis());
        }
        this.smash = smash;
    }

    public boolean isRepeatSmash() {
        return this.repeatSmash;
    }

    public void setRepeatSmash(boolean repeatSmash) {
        this.repeatSmash = repeatSmash;
    }

    public int getMaxProcessingTime() {
        return 200;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    private void setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
    }

    @Nullable
    public ICrankable getCrankable(class_2350 direction) {
        if (direction != this.getFront()) {
            return new Crankable();
        }
        return null;
    }

    public class BaseFilter
    implements IAEItemFilter {
        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            if (slot == 1) {
                return true;
            }
            if ((inv == InscriberBlockEntity.this.topItemHandler || inv == InscriberBlockEntity.this.bottomItemHandler) && AEItems.NAME_PRESS.isSameAs(stack)) {
                return true;
            }
            if (inv == InscriberBlockEntity.this.sideItemHandler && (AEItems.NAME_PRESS.isSameAs(InscriberBlockEntity.this.topItemHandler.getStackInSlot(0)) || AEItems.NAME_PRESS.isSameAs(InscriberBlockEntity.this.bottomItemHandler.getStackInSlot(0)))) {
                return true;
            }
            class_1799 bot = InscriberBlockEntity.this.bottomItemHandler.getStackInSlot(0);
            class_1799 middle = InscriberBlockEntity.this.sideItemHandler.getStackInSlot(0);
            class_1799 top = InscriberBlockEntity.this.topItemHandler.getStackInSlot(0);
            if (inv == InscriberBlockEntity.this.bottomItemHandler) {
                bot = stack;
            }
            if (inv == InscriberBlockEntity.this.sideItemHandler) {
                middle = stack;
            }
            if (inv == InscriberBlockEntity.this.topItemHandler) {
                top = stack;
            }
            for (InscriberRecipe recipe : InscriberRecipes.getRecipes(InscriberBlockEntity.this.method_10997())) {
                if (!middle.method_7960() && !recipe.getMiddleInput().method_8093(middle)) continue;
                if (bot.method_7960() && top.method_7960()) {
                    return true;
                }
                if (!(bot.method_7960() ? recipe.getTopOptional().method_8093(top) || recipe.getBottomOptional().method_8093(top) : (top.method_7960() ? recipe.getBottomOptional().method_8093(bot) || recipe.getTopOptional().method_8093(bot) : recipe.getTopOptional().method_8093(top) && recipe.getBottomOptional().method_8093(bot) || recipe.getBottomOptional().method_8093(top) && recipe.getTopOptional().method_8093(bot)))) continue;
                return true;
            }
            return false;
        }
    }

    public class AutomationFilter
    implements IAEItemFilter {
        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            if (slot == 1) {
                return true;
            }
            if (InscriberBlockEntity.this.isSmash()) {
                return false;
            }
            return InscriberBlockEntity.this.isSeparateSides() && (inv == InscriberBlockEntity.this.topItemHandler || inv == InscriberBlockEntity.this.bottomItemHandler);
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            if (slot == 1) {
                return false;
            }
            return !InscriberBlockEntity.this.isSmash();
        }
    }

    class Crankable
    implements ICrankable {
        Crankable() {
        }

        @Override
        public boolean canTurn() {
            return InscriberBlockEntity.this.getInternalCurrentPower() < InscriberBlockEntity.this.getInternalMaxPower();
        }

        @Override
        public void applyTurn() {
            InscriberBlockEntity.this.injectExternalPower(PowerUnits.AE, 160.0, Actionable.MODULATE);
        }
    }
}

