/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.api.config.ActionItems;
import appeng.client.Point;
import appeng.client.gui.Icon;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.me.items.EncodingModePanel;
import appeng.client.gui.me.items.PatternEncodingTermScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.menu.SlotSemantics;
import java.util.List;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_768;

public class CraftingEncodingPanel
extends EncodingModePanel {
    private static final Blitter BG = Blitter.texture("guis/pattern_modes.png").src(0, 0, 126, 68);
    private final ActionButton clearBtn = new ActionButton(ActionItems.CLOSE, act -> this.menu.clear());
    private final ToggleButton substitutionsBtn;
    private final ToggleButton fluidSubstitutionsBtn;

    public CraftingEncodingPanel(PatternEncodingTermScreen<?> screen, WidgetContainer widgets) {
        super(screen, widgets);
        this.clearBtn.setHalfSize(true);
        widgets.add("craftingClearPattern", (class_339)this.clearBtn);
        this.substitutionsBtn = this.createCraftingSubstitutionButton(widgets);
        this.fluidSubstitutionsBtn = this.createCraftingFluidSubstitutionButton(widgets);
    }

    @Override
    public class_1799 getTabIconItem() {
        return class_1802.field_8465.method_7854();
    }

    @Override
    public class_2561 getTabTooltip() {
        return GuiText.CraftingPattern.text();
    }

    private ToggleButton createCraftingSubstitutionButton(WidgetContainer widgets) {
        ToggleButton button = new ToggleButton(Icon.SUBSTITUTION_ENABLED, Icon.SUBSTITUTION_DISABLED, this.menu::setSubstitute);
        button.setHalfSize(true);
        button.setTooltipOn(List.of(ButtonToolTips.SubstitutionsOn.text(), ButtonToolTips.SubstitutionsDescEnabled.text()));
        button.setTooltipOff(List.of(ButtonToolTips.SubstitutionsOff.text(), ButtonToolTips.SubstitutionsDescDisabled.text()));
        widgets.add("craftingSubstitutions", (class_339)button);
        return button;
    }

    private ToggleButton createCraftingFluidSubstitutionButton(WidgetContainer widgets) {
        ToggleButton button = new ToggleButton(Icon.FLUID_SUBSTITUTION_ENABLED, Icon.FLUID_SUBSTITUTION_DISABLED, this.menu::setSubstituteFluids);
        button.setHalfSize(true);
        button.setTooltipOn(List.of(ButtonToolTips.FluidSubstitutions.text(), ButtonToolTips.FluidSubstitutionsDescEnabled.text()));
        button.setTooltipOff(List.of(ButtonToolTips.FluidSubstitutions.text(), ButtonToolTips.FluidSubstitutionsDescDisabled.text()));
        widgets.add("craftingFluidSubstitutions", (class_339)button);
        return button;
    }

    @Override
    public void drawBackgroundLayer(class_332 guiGraphics, class_768 bounds, Point mouse) {
        BG.dest(bounds.method_3321() + 9, bounds.method_3322() + bounds.method_3320() - 164).blit(guiGraphics);
        int absMouseX = bounds.method_3321() + mouse.getX();
        int absMouseY = bounds.method_3322() + mouse.getY();
        if (this.menu.substituteFluids && this.fluidSubstitutionsBtn.method_25405(absMouseX, absMouseY)) {
            for (Integer slotIndex : this.menu.slotsSupportingFluidSubstitution) {
                this.drawSlotGreenBG(bounds, guiGraphics, this.menu.getCraftingGridSlots()[slotIndex]);
            }
        }
    }

    private void drawSlotGreenBG(class_768 bounds, class_332 guiGraphics, class_1735 slot) {
        int x = bounds.method_3321() + slot.field_7873;
        int y = bounds.method_3322() + slot.field_7872;
        guiGraphics.method_25294(x, y, x + 16, y + 16, 0x7F00FF00);
    }

    @Override
    public void updateBeforeRender() {
        this.substitutionsBtn.setState(this.menu.substitute);
        this.fluidSubstitutionsBtn.setState(this.menu.substituteFluids);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.clearBtn.setVisibility(visible);
        this.substitutionsBtn.setVisibility(visible);
        this.fluidSubstitutionsBtn.setVisibility(visible);
        this.screen.setSlotsHidden(SlotSemantics.CRAFTING_GRID, !visible);
        this.screen.setSlotsHidden(SlotSemantics.CRAFTING_RESULT, !visible);
    }
}

