/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.features.Locatables;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.blockentity.qnb.QuantumBridgeBlockEntity;
import appeng.core.AELog;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.MBCalculator;
import appeng.me.service.helpers.ConnectionWrapper;
import appeng.util.iterators.ChainedIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class QuantumCluster
implements IAECluster,
IActionHost {
    private static final Set<QuantumCluster> ACTIVE_CLUSTERS = new HashSet<QuantumCluster>();
    private final class_2338 boundsMin;
    private final class_2338 boundsMax;
    private boolean isDestroyed = false;
    private boolean updateStatus = true;
    private QuantumBridgeBlockEntity[] Ring;
    private boolean registered = false;
    private ConnectionWrapper connection;
    private long thisSide;
    private long otherSide;
    private QuantumBridgeBlockEntity center;

    public QuantumCluster(class_2338 min, class_2338 max) {
        this.boundsMin = min.method_10062();
        this.boundsMax = max.method_10062();
        this.setRing(new QuantumBridgeBlockEntity[8]);
    }

    private void onUnload(class_3218 level) {
        if (this.center.method_10997() == level) {
            this.setUpdateStatus(false);
            this.destroy();
        }
    }

    @Override
    public void updateStatus(boolean updateGrid) {
        long qe = this.center.getQEFrequency();
        if (this.thisSide != qe && this.thisSide != -qe) {
            if (qe != 0L) {
                if (this.thisSide != 0L) {
                    Locatables.quantumNetworkBridges().unregister(this.center.method_10997(), this.getLocatableKey());
                }
                if (this.canUseNode(-qe)) {
                    this.otherSide = qe;
                    this.thisSide = -qe;
                } else if (this.canUseNode(qe)) {
                    this.thisSide = qe;
                    this.otherSide = -qe;
                }
                Locatables.quantumNetworkBridges().register(this.center.method_10997(), this.getLocatableKey(), this);
            } else {
                Locatables.quantumNetworkBridges().unregister(this.center.method_10997(), this.getLocatableKey());
                this.otherSide = 0L;
                this.thisSide = 0L;
            }
        }
        IActionHost myOtherSide = this.otherSide == 0L ? null : Locatables.quantumNetworkBridges().get(this.center.method_10997(), this.otherSide);
        boolean shutdown = false;
        if (myOtherSide instanceof QuantumCluster) {
            QuantumCluster sideB = (QuantumCluster)myOtherSide;
            QuantumCluster sideA = this;
            if (sideA.isActive() && sideB.isActive()) {
                if (this.connection != null && this.connection.getConnection() != null) {
                    IGridNode a = this.connection.getConnection().a();
                    IGridNode b = this.connection.getConnection().b();
                    IGridNode sa = sideA.getNode();
                    IGridNode sb = sideB.getNode();
                    if (!(a != sa && b != sa || a != sb && b != sb)) {
                        return;
                    }
                }
                if (sideA.connection != null && sideA.connection.getConnection() != null) {
                    sideA.connection.getConnection().destroy();
                    sideA.connection = new ConnectionWrapper(null);
                }
                if (sideB.connection != null && sideB.connection.getConnection() != null) {
                    sideB.connection.getConnection().destroy();
                    sideB.connection = new ConnectionWrapper(null);
                }
                sideA.connection = sideB.connection = new ConnectionWrapper(GridHelper.createConnection(sideA.getNode(), sideB.getNode()));
            } else {
                shutdown = true;
            }
        } else {
            shutdown = true;
        }
        if (shutdown && this.connection != null && this.connection.getConnection() != null) {
            this.connection.getConnection().destroy();
            this.connection.setConnection(null);
            this.connection = new ConnectionWrapper(null);
        }
    }

    private boolean canUseNode(long qe) {
        IActionHost locatable = Locatables.quantumNetworkBridges().get(this.center.method_10997(), qe);
        if (locatable instanceof QuantumCluster) {
            QuantumCluster qc = (QuantumCluster)locatable;
            class_1937 level = qc.center.method_10997();
            if (!qc.isDestroyed) {
                if (level.method_22340(qc.center.method_11016())) {
                    class_3218 cur = level.method_8503().method_3847(level.method_27983());
                    class_2586 te = level.method_8321(qc.center.method_11016());
                    return te != qc.center || level != cur;
                }
                AELog.warn("Found a registered QNB with serial %s whose chunk seems to be unloaded: %s", qe, qc);
            }
        }
        return true;
    }

    private boolean isActive() {
        if (this.isDestroyed || !this.registered) {
            return false;
        }
        return this.hasQES();
    }

    private IGridNode getNode() {
        return this.center.getGridNode();
    }

    private boolean hasQES() {
        return this.thisSide != 0L;
    }

    @Override
    public class_2338 getBoundsMin() {
        return this.boundsMin;
    }

    @Override
    public class_2338 getBoundsMax() {
        return this.boundsMax;
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        MBCalculator.setModificationInProgress(this);
        try {
            if (this.registered) {
                ACTIVE_CLUSTERS.remove(this);
                this.registered = false;
            }
            if (this.thisSide != 0L) {
                this.updateStatus(true);
                Locatables.quantumNetworkBridges().unregister(this.center.method_10997(), this.getLocatableKey());
            }
            this.center.updateStatus(null, (byte)-1, this.isUpdateStatus());
            for (QuantumBridgeBlockEntity r : this.getRing()) {
                r.updateStatus(null, (byte)-1, this.isUpdateStatus());
            }
            this.center = null;
            this.setRing(new QuantumBridgeBlockEntity[8]);
        }
        finally {
            MBCalculator.setModificationInProgress(null);
        }
    }

    public Iterator<QuantumBridgeBlockEntity> getBlockEntities() {
        return new ChainedIterator<QuantumBridgeBlockEntity>(this.getRing()[0], this.getRing()[1], this.getRing()[2], this.getRing()[3], this.getRing()[4], this.getRing()[5], this.getRing()[6], this.getRing()[7], this.center);
    }

    public boolean isCorner(QuantumBridgeBlockEntity quantumBridge) {
        return this.getRing()[0] == quantumBridge || this.getRing()[2] == quantumBridge || this.getRing()[4] == quantumBridge || this.getRing()[6] == quantumBridge;
    }

    private long getLocatableKey() {
        return this.thisSide;
    }

    public QuantumBridgeBlockEntity getCenter() {
        return this.center;
    }

    void setCenter(QuantumBridgeBlockEntity c) {
        this.registered = true;
        ACTIVE_CLUSTERS.add(this);
        this.center = c;
    }

    private boolean isUpdateStatus() {
        return this.updateStatus;
    }

    public void setUpdateStatus(boolean updateStatus) {
        this.updateStatus = updateStatus;
    }

    QuantumBridgeBlockEntity[] getRing() {
        return this.Ring;
    }

    private void setRing(QuantumBridgeBlockEntity[] ring) {
        this.Ring = ring;
    }

    public String toString() {
        if (this.center == null) {
            return "QuantumCluster{no-center}";
        }
        class_1937 level = this.center.method_10997();
        class_2338 pos = this.center.method_11016();
        return "QuantumCluster{" + level + "," + pos + "}";
    }

    @Override
    @Nullable
    public IGridNode getActionableNode() {
        return this.center.getMainNode().getNode();
    }

    static {
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> ACTIVE_CLUSTERS.clear());
        ServerWorldEvents.UNLOAD.register((server, level) -> {
            ArrayList<QuantumCluster> iteration = new ArrayList<QuantumCluster>(ACTIVE_CLUSTERS);
            for (QuantumCluster activeCluster : iteration) {
                activeCluster.onUnload(level);
            }
        });
    }
}

