/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.features.P2PTunnelAttunement;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.me.service.P2PService;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public abstract class P2PTunnelPart<T extends P2PTunnelPart<T>>
extends AEBasePart {
    private static final String CONFIG_NBT_TYPE = "p2pType";
    private static final String CONFIG_NBT_FREQ = "p2pFreq";
    private boolean output;
    private short freq;
    private final EnergyDrainHandler energyDrainHandler = new EnergyDrainHandler();

    public P2PTunnelPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setIdlePowerUsage(this.getPowerDrainPerTick());
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL);
    }

    protected float getPowerDrainPerTick() {
        return 1.0f;
    }

    @Nullable
    public T getInput() {
        if (this.getFrequency() == 0) {
            return null;
        }
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            P2PTunnelPart tunnel = P2PService.get(grid).getInput(this.getFrequency());
            if (this.getClass().isInstance(tunnel)) {
                return (T)tunnel;
            }
        }
        return null;
    }

    public List<T> getOutputs() {
        return this.getOutputStream().toList();
    }

    public Stream<T> getOutputStream() {
        IGrid grid;
        if (this.getMainNode().isActive() && (grid = this.getMainNode().getGrid()) != null) {
            return P2PService.get(grid).getOutputs(this.getFrequency(), this.getClass());
        }
        return Stream.empty();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
        bch.addBox(3.0, 3.0, 13.0, 13.0, 13.0, 14.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.setOutput(data.method_10577("output"));
        this.freq = data.method_10568("freq");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10556("output", this.isOutput());
        data.method_10575("freq", this.getFrequency());
    }

    @Override
    public boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        short oldf = this.freq;
        this.freq = data.readShort();
        return c || oldf != this.freq;
    }

    @Override
    public void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeShort((int)this.getFrequency());
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    @Override
    public boolean useStandardMemoryCard() {
        return false;
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        class_1792 partItem2;
        class_1792 class_17922;
        if (this.isClientSide()) {
            return true;
        }
        if (hand == class_1268.field_5810) {
            return false;
        }
        class_1799 is = player.method_5998(hand);
        if (!is.method_7960() && (class_17922 = is.method_7909()) instanceof IMemoryCard) {
            IMemoryCard mc = (IMemoryCard)class_17922;
            class_2487 configData = mc.getData(is);
            IPartItem<?> partItem2 = IPartItem.byId(new class_2960(configData.method_10558(CONFIG_NBT_TYPE)));
            if (partItem2 != null && P2PTunnelPart.class.isAssignableFrom(partItem2.getPartClass())) {
                P2PTunnelPart<Object> newBus = this;
                if (newBus.getPartItem() != partItem2) {
                    newBus = this.getHost().replacePart(partItem2, this.getSide(), player, hand);
                }
                if (newBus instanceof P2PTunnelPart) {
                    P2PTunnelPart newTunnel = newBus;
                    newTunnel.importSettings(SettingsFrom.MEMORY_CARD, configData, player);
                }
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                return true;
            }
            mc.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
            return false;
        }
        class_1799 newType = P2PTunnelAttunement.getTunnelPartByTriggerItem(is);
        if (!newType.method_7960() && newType.method_7909() != this.getPartItem() && (partItem2 = newType.method_7909()) instanceof IPartItem) {
            IPartItem partItem3 = (IPartItem)partItem2;
            boolean oldOutput = this.isOutput();
            short myFreq = this.getFrequency();
            Object tunnel = this.getHost().replacePart(partItem3, this.getSide(), player, hand);
            if (tunnel instanceof P2PTunnelPart) {
                P2PTunnelPart newTunnel = (P2PTunnelPart)tunnel;
                newTunnel.setOutput(oldOutput);
                newTunnel.onTunnelNetworkChange();
                newTunnel.getMainNode().ifPresent(grid -> P2PService.get(grid).updateFreq(newTunnel, myFreq));
            }
            Platform.notifyBlocksOfNeighbors(this.getLevel(), this.getBlockEntity().method_11016());
            return true;
        }
        return false;
    }

    @Override
    public boolean onPartShiftActivate(class_1657 player, class_1268 hand, class_243 pos) {
        class_1792 class_17922;
        class_1799 is = player.method_31548().method_7391();
        if (!is.method_7960() && (class_17922 = is.method_7909()) instanceof IMemoryCard) {
            IMemoryCard mc = (IMemoryCard)class_17922;
            if (this.isClientSide()) {
                return true;
            }
            class_2487 data = mc.getData(is);
            short storedFrequency = data.method_10568("freq");
            short newFreq = this.getFrequency();
            boolean wasOutput = this.isOutput();
            this.setOutput(false);
            boolean needsNewFrequency = wasOutput || this.getFrequency() == 0 || storedFrequency == newFreq;
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                P2PService p2p = P2PService.get(grid);
                if (needsNewFrequency) {
                    newFreq = p2p.newFrequency();
                }
                p2p.updateFreq(this, newFreq);
            }
            this.onTunnelConfigChange();
            String type = this.getPartItem().method_8389().method_7876();
            this.exportSettings(SettingsFrom.MEMORY_CARD, data);
            mc.setMemoryCardContents(is, type, data);
            if (needsNewFrequency) {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_RESET);
            } else {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
            }
            return true;
        }
        return false;
    }

    @Override
    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        short freq;
        super.importSettings(mode, input, player);
        if (input.method_10573(CONFIG_NBT_FREQ, 2) && (freq = input.method_10568(CONFIG_NBT_FREQ)) != this.freq) {
            this.setOutput(true);
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                P2PService.get(grid).updateFreq(this, freq);
            } else {
                this.setFrequency(freq);
                this.onTunnelNetworkChange();
            }
        }
    }

    @Override
    public void exportSettings(SettingsFrom mode, class_2487 output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            output.method_10582(CONFIG_NBT_TYPE, IPartItem.getId(this.getPartItem()).toString());
            if (this.freq != 0) {
                output.method_10575(CONFIG_NBT_FREQ, this.freq);
                AEColor[] colors = Platform.p2p().toColors(this.freq);
                int[] colorCode = new int[]{colors[0].ordinal(), colors[0].ordinal(), colors[1].ordinal(), colors[1].ordinal(), colors[2].ordinal(), colors[2].ordinal(), colors[3].ordinal(), colors[3].ordinal()};
                output.method_10539("colorCode", colorCode);
            }
        }
    }

    public void onTunnelConfigChange() {
    }

    public void onTunnelNetworkChange() {
    }

    protected void queueTunnelDrain(PowerUnits unit, double f, TransactionContext transaction) {
        double ae_to_tax = unit.convertTo(PowerUnits.AE, f * 0.05);
        this.energyDrainHandler.updateSnapshots(transaction);
        this.energyDrainHandler.pendingEnergy += ae_to_tax;
    }

    protected void queueTunnelDrain(PowerUnits unit, double f) {
        double ae_to_tax = unit.convertTo(PowerUnits.AE, f * 0.05);
        this.getMainNode().ifPresent(grid -> grid.getEnergyService().extractAEPower(ae_to_tax, Actionable.MODULATE, PowerMultiplier.ONE));
    }

    public short getFrequency() {
        return this.freq;
    }

    public void setFrequency(short freq) {
        short oldf = this.freq;
        this.freq = freq;
        if (oldf != this.freq) {
            this.getHost().markForSave();
            this.getHost().markForUpdate();
        }
    }

    public boolean isOutput() {
        return this.output;
    }

    void setOutput(boolean output) {
        this.output = output;
        this.getHost().markForSave();
    }

    @Override
    public Object getRenderAttachmentData() {
        long ret = Short.toUnsignedLong(this.getFrequency());
        if (this.isActive() && this.isPowered()) {
            ret |= 0x10000L;
        }
        return ret;
    }

    private class EnergyDrainHandler
    extends SnapshotParticipant<Double> {
        private double pendingEnergy;

        private EnergyDrainHandler() {
        }

        protected Double createSnapshot() {
            return this.pendingEnergy;
        }

        protected void readSnapshot(Double snapshot) {
            this.pendingEnergy = snapshot;
        }

        protected void onFinalCommit() {
            if (this.pendingEnergy > 0.0) {
                P2PTunnelPart.this.getMainNode().ifPresent(grid -> grid.getEnergyService().extractAEPower(this.pendingEnergy, Actionable.MODULATE, PowerMultiplier.ONE));
                this.pendingEnergy = 0.0;
            }
        }
    }
}

