/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundClaimStatesPacket
extends LazyPacket<LazyPacket.Encoder<ClientboundClaimStatesPacket>, ClientboundClaimStatesPacket> {
    public static final int MAX_STATES = 128;
    public static final LazyPacket.Encoder<ClientboundClaimStatesPacket> ENCODER = new LazyPacket.Encoder();
    private final List<PlayerChunkClaim> claimStates;

    public ClientboundClaimStatesPacket(List<PlayerChunkClaim> claimStates) {
        this.claimStates = claimStates;
    }

    @Override
    protected LazyPacket.Encoder<ClientboundClaimStatesPacket> getEncoder() {
        return ENCODER;
    }

    @Override
    protected void writeOnPrepare(LazyPacket.Encoder<ClientboundClaimStatesPacket> encoder, class_2540 dest) {
        class_2487 nbt = new class_2487();
        class_2499 stateListTag = new class_2499();
        for (int i = 0; i < this.claimStates.size(); ++i) {
            PlayerChunkClaim state = this.claimStates.get(i);
            class_2487 claimStateNbt = new class_2487();
            claimStateNbt.method_25927("p", state.getPlayerId());
            claimStateNbt.method_10569("s", state.getSubConfigIndex());
            claimStateNbt.method_10556("f", state.isForceloadable());
            claimStateNbt.method_10569("i", state.getSyncIndex());
            stateListTag.add((Object)claimStateNbt);
        }
        nbt.method_10566("l", (class_2520)stateListTag);
        dest.method_10794(nbt);
    }

    public static class ClientHandler
    implements Consumer<ClientboundClaimStatesPacket> {
        @Override
        public void accept(ClientboundClaimStatesPacket t) {
            for (PlayerChunkClaim claimState : t.claimStates) {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimState(claimState);
            }
        }
    }

    public static class Decoder
    implements Function<class_2540, ClientboundClaimStatesPacket> {
        @Override
        public ClientboundClaimStatesPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 16384) {
                    return null;
                }
                class_2487 nbt = input.method_30617();
                if (nbt == null) {
                    return null;
                }
                class_2499 stateListTag = nbt.method_10554("l", 10);
                if (stateListTag.size() > 128) {
                    OpenPartiesAndClaims.LOGGER.info("Received claim state list is too large!");
                    return null;
                }
                ArrayList<PlayerChunkClaim> claimStates = new ArrayList<PlayerChunkClaim>(stateListTag.size());
                for (int i = 0; i < stateListTag.size(); ++i) {
                    class_2487 claimStateNbt = stateListTag.method_10602(i);
                    UUID playerId = claimStateNbt.method_25926("p");
                    int subConfigIndex = claimStateNbt.method_10550("s");
                    boolean forceloadable = claimStateNbt.method_10577("f");
                    int syncIndex = claimStateNbt.method_10550("i");
                    claimStates.add(new PlayerChunkClaim(playerId, subConfigIndex, forceloadable, syncIndex));
                }
                return new ClientboundClaimStatesPacket(claimStates);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }
}

