/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundClaimsClaimUpdatePacket
extends LazyPacket<LazyPacket.Encoder<ClientboundClaimsClaimUpdatePacket>, ClientboundClaimsClaimUpdatePacket> {
    public static final LazyPacket.Encoder<ClientboundClaimsClaimUpdatePacket> ENCODER = new LazyPacket.Encoder();
    private final class_2960 dimension;
    private final int x;
    private final int z;
    private final UUID playerId;
    private final int subConfigIndex;
    private final boolean forceLoaded;
    private final int claimSyncIndex;

    public ClientboundClaimsClaimUpdatePacket(class_2960 dimension, int x, int z, UUID playerId, int subConfigIndex, boolean forceLoaded, int claimSyncIndex) {
        this.dimension = dimension;
        this.x = x;
        this.z = z;
        this.playerId = playerId;
        this.subConfigIndex = subConfigIndex;
        this.forceLoaded = forceLoaded;
        this.claimSyncIndex = claimSyncIndex;
    }

    @Override
    protected LazyPacket.Encoder<ClientboundClaimsClaimUpdatePacket> getEncoder() {
        return ENCODER;
    }

    @Override
    protected void writeOnPrepare(LazyPacket.Encoder<ClientboundClaimsClaimUpdatePacket> encoder, class_2540 u) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("d", this.dimension.toString());
        nbt.method_10569("x", this.x);
        nbt.method_10569("z", this.z);
        if (this.playerId != null) {
            nbt.method_10569("i", this.claimSyncIndex);
            nbt.method_25927("p", this.playerId);
            nbt.method_10569("s", this.subConfigIndex);
            nbt.method_10556("f", this.forceLoaded);
        }
        u.method_10794(nbt);
    }

    public String toString() {
        return String.format("[%s, %d, %d, %s, %s, %d, %d]", this.dimension, this.x, this.z, this.playerId, this.forceLoaded, this.subConfigIndex, this.claimSyncIndex);
    }

    public static class ClientHandler
    implements Consumer<ClientboundClaimsClaimUpdatePacket> {
        @Override
        public void accept(ClientboundClaimsClaimUpdatePacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimUpdate(t.dimension, t.x, t.z, t.playerId, t.subConfigIndex, t.forceLoaded, t.claimSyncIndex);
        }
    }

    public static class Decoder
    implements Function<class_2540, ClientboundClaimsClaimUpdatePacket> {
        @Override
        public ClientboundClaimsClaimUpdatePacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 10000) {
                    return null;
                }
                class_2487 nbt = input.method_30617();
                if (nbt == null) {
                    return null;
                }
                String dimensionString = nbt.method_10558("d");
                if (dimensionString.isEmpty() || dimensionString.length() > 2048) {
                    return null;
                }
                int x = nbt.method_10550("x");
                int z = nbt.method_10550("z");
                int claimStateIndex = -1;
                UUID playerId = null;
                int subConfigIndex = -1;
                boolean forceload = false;
                if (nbt.method_10545("p")) {
                    claimStateIndex = nbt.method_10550("i");
                    playerId = nbt.method_25926("p");
                    subConfigIndex = nbt.method_10550("s");
                    forceload = nbt.method_10577("f");
                }
                return new ClientboundClaimsClaimUpdatePacket(new class_2960(dimensionString), x, z, playerId, subConfigIndex, forceload, claimStateIndex);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }
}

