/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundSubClaimPropertiesPacket
extends LazyPacket<LazyPacket.Encoder<ClientboundSubClaimPropertiesPacket>, ClientboundSubClaimPropertiesPacket> {
    public static final int MAX_PROPERTIES = 32;
    public static final LazyPacket.Encoder<ClientboundSubClaimPropertiesPacket> ENCODER = new LazyPacket.Encoder();
    private final List<SubClaimProperties> properties;

    public ClientboundSubClaimPropertiesPacket(List<SubClaimProperties> properties) {
        this.properties = properties;
    }

    @Override
    protected LazyPacket.Encoder<ClientboundSubClaimPropertiesPacket> getEncoder() {
        return ENCODER;
    }

    @Override
    protected void writeOnPrepare(LazyPacket.Encoder<ClientboundSubClaimPropertiesPacket> encoder, class_2540 dest) {
        class_2487 nbt = new class_2487();
        class_2499 propertiesListTag = new class_2499();
        for (int i = 0; i < this.properties.size(); ++i) {
            SubClaimProperties propertiesEntry = this.properties.get(i);
            class_2487 propertiesEntryNbt = new class_2487();
            propertiesEntryNbt.method_25927("p", propertiesEntry.playerId);
            propertiesEntryNbt.method_10569("i", propertiesEntry.subConfigIndex);
            if (propertiesEntry.claimsName != null) {
                propertiesEntryNbt.method_10582("n", propertiesEntry.claimsName);
            }
            if (propertiesEntry.claimsColor != null) {
                propertiesEntryNbt.method_10569("c", propertiesEntry.claimsColor.intValue());
            }
            propertiesListTag.add((Object)propertiesEntryNbt);
        }
        nbt.method_10566("l", (class_2520)propertiesListTag);
        dest.method_10794(nbt);
    }

    public static class SubClaimProperties {
        private final UUID playerId;
        private final int subConfigIndex;
        private final String claimsName;
        private final Integer claimsColor;

        public SubClaimProperties(UUID playerId, int subConfigIndex, String claimsName, Integer claimsColor) {
            this.playerId = playerId;
            this.subConfigIndex = subConfigIndex;
            this.claimsName = claimsName;
            this.claimsColor = claimsColor;
        }

        public String toString() {
            return String.format("[%s, %d, %s, %d]", this.playerId, this.subConfigIndex, this.claimsName, this.claimsColor);
        }
    }

    public static class ClientHandler
    implements Consumer<ClientboundSubClaimPropertiesPacket> {
        @Override
        public void accept(ClientboundSubClaimPropertiesPacket t) {
            for (SubClaimProperties propertiesEntry : t.properties) {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onSubClaimInfo(propertiesEntry.playerId, propertiesEntry.subConfigIndex, propertiesEntry.claimsName, propertiesEntry.claimsColor);
            }
        }
    }

    public static class Decoder
    implements Function<class_2540, ClientboundSubClaimPropertiesPacket> {
        @Override
        public ClientboundSubClaimPropertiesPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 32768) {
                    return null;
                }
                class_2487 nbt = input.method_30617();
                if (nbt == null) {
                    return null;
                }
                class_2499 propertiesListTag = nbt.method_10554("l", 10);
                if (propertiesListTag.size() > 32) {
                    OpenPartiesAndClaims.LOGGER.info("Received sub-claim properties list is too large!");
                    return null;
                }
                ArrayList<SubClaimProperties> propertiesList = new ArrayList<SubClaimProperties>(propertiesListTag.size());
                for (int i = 0; i < propertiesListTag.size(); ++i) {
                    class_2487 propertiesEntryNbt = propertiesListTag.method_10602(i);
                    String claimsName = propertiesEntryNbt.method_10558("n");
                    if (claimsName.length() > 128) {
                        OpenPartiesAndClaims.LOGGER.info("Received sub-claim properties list with invalid claims name!");
                        return null;
                    }
                    UUID playerId = propertiesEntryNbt.method_25926("p");
                    int subConfigIndex = propertiesEntryNbt.method_10550("i");
                    Integer claimsColor = propertiesEntryNbt.method_10573("c", 3) ? Integer.valueOf(propertiesEntryNbt.method_10550("c")) : null;
                    propertiesList.add(new SubClaimProperties(playerId, subConfigIndex, claimsName, claimsColor));
                }
                return new ClientboundSubClaimPropertiesPacket(propertiesList);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }
}

