/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.protection;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_2960;
import xaero.pac.OpenPartiesAndClaims;

public class WildcardResolver {
    private static final Pattern WILDCARD_FORMAT = Pattern.compile("[\\(\\)\\*\\|a-zA-Z0-9_\\-\\.\\/\\:]+");
    private static final Pattern WILDCARD_TO_REGEX_REPLACE_PATTERN = Pattern.compile("([\\.\\-\\:\\/])");
    private static final Function<String, String> WILDCARD_TO_REGEX = s -> WILDCARD_TO_REGEX_REPLACE_PATTERN.matcher((CharSequence)s).replaceAll("\\\\$1").replace("*", ".*");

    public <T> List<T> resolveResourceLocations(Function<class_2960, T> getter, Iterable<T> iterable, Function<T, class_2960> keyGetter, String string) {
        if (class_2960.method_20207((String)string)) {
            T object = getter.apply(new class_2960(string));
            return object == null ? List.of() : List.of(object);
        }
        if (!WILDCARD_FORMAT.matcher(string).matches()) {
            OpenPartiesAndClaims.LOGGER.error("Invalid resource location or wildcard in the server config file: " + string + ". Additional characters allowed for wildcards are (, ), | and *.");
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        try {
            Pattern regexPattern = Pattern.compile(WILDCARD_TO_REGEX.apply(string));
            for (T element : iterable) {
                class_2960 key = keyGetter.apply(element);
                if (!regexPattern.matcher(key.toString()).matches()) continue;
                result.add(element);
            }
        }
        catch (PatternSyntaxException pse) {
            OpenPartiesAndClaims.LOGGER.error("Invalid wildcard format in the server config file: " + string + ". Additional characters allowed for wildcards are (, ), | and *.", (Throwable)pse);
            return null;
        }
        return result;
    }
}

