/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public enum FactoryCapacityTiers {
    BURNED((class_2561)class_2561.method_43471((String)"tier.factory_api.burned").method_27692(class_124.field_1079), 0.0, 0, 0),
    BASIC((class_2561)class_2561.method_43471((String)"tier.factory_api.basic").method_27692(class_124.field_1080), 0.2, 800, 1),
    ADVANCED((class_2561)class_2561.method_43471((String)"tier.factory_api.advanced").method_27692(class_124.field_1061), 0.6, 2000, 3),
    HIGH((class_2561)class_2561.method_43471((String)"tier.factory_api.high").method_27692(class_124.field_1078), 0.5, 4000, 8),
    ULTIMATE((class_2561)class_2561.method_43471((String)"tier.factory_api.ultimate").method_27692(class_124.field_1064), 0.63, 6000, 12),
    QUANTUM((class_2561)class_2561.method_43471((String)"tier.factory_api.quantum").method_27692(class_124.field_1062), 0.8, 10000, 16),
    CREATIVE((class_2561)class_2561.method_43471((String)"tier.factory_api.creative").method_27692(class_124.field_1076), 1.0, Integer.MAX_VALUE, Integer.MAX_VALUE);

    private final double conductivity;
    public final int initialCapacity;
    public final int capacityMultiplier;
    public final class_2561 localizedName;

    private FactoryCapacityTiers(class_2561 name, double j, int initialCapacity, int multiplier) {
        this.localizedName = name;
        this.conductivity = j;
        this.initialCapacity = initialCapacity;
        this.capacityMultiplier = multiplier;
    }

    public class_5250 getEnergyTierComponent(boolean isStored) {
        return this.getPrefixComponent("energy", isStored).method_27692(class_124.field_1075).method_10852(this.localizedName);
    }

    public class_5250 getOutputTierComponent() {
        return this.getPrefixComponent("energy", class_1074.method_4662((String)"tier.factory_api.output", (Object[])new Object[0])).method_27692(class_124.field_1075).method_10852(this.localizedName);
    }

    public class_5250 getTierComponent(boolean isStored) {
        return this.getPrefixComponent("capacity", isStored).method_27692(class_124.field_1080).method_10852(this.localizedName);
    }

    public class_5250 getPrefixComponent(String keyType, boolean isStored) {
        if (isStored) {
            return this.getPrefixComponent(keyType, class_1074.method_4662((String)"tier.factory_api.stored", (Object[])new Object[0]));
        }
        return this.getPrefixComponent(keyType, "");
    }

    public class_5250 getPrefixComponent(String keyType, Object ... objects) {
        return class_2561.method_43469((String)"tier.factory_api.display", (Object[])new Object[]{class_1074.method_4662((String)("tier.factory_api." + keyType), (Object[])objects)});
    }

    public boolean supportTier(FactoryCapacityTiers tier) {
        return this.ordinal() >= tier.ordinal();
    }

    public double getConductivity() {
        return this.conductivity;
    }

    public double getPowFactor() {
        return Math.pow(this.conductivity, 2.0);
    }

    public boolean isBurned() {
        return this == BURNED;
    }

    public int getDefaultCapacity() {
        return this.initialCapacity * 10;
    }

    public int getStorageCapacity() {
        return this.getDefaultCapacity() * this.capacityMultiplier;
    }

    public FactoryCapacityTiers increase(int ordinal) {
        return FactoryCapacityTiers.values()[Math.min(FactoryCapacityTiers.values().length - 1, this.ordinal() + ordinal)];
    }

    public int convertEnergyTo(int energy, FactoryCapacityTiers tier) {
        return (int)Math.round(Math.max((double)energy + (this.getConductivity() - tier.getConductivity()) * (double)energy * (double)this.initialCapacity / (double)tier.initialCapacity, 0.0));
    }
}

