/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.BlockSide;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.FluidSide;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.ItemSide;
import wily.factoryapi.base.SideList;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.Storages;
import wily.factoryapi.base.TransportState;

public interface IFactoryExpandedStorage
extends IFactoryStorage {
    default public <T> void replaceSidedStorage(BlockSide blockSide, SideList<T> side, T replacement) {
        IFactoryExpandedStorage iFactoryExpandedStorage = this;
        if (iFactoryExpandedStorage instanceof class_2586) {
            class_2586 be = (class_2586)iFactoryExpandedStorage;
            side.put(blockSide.blockStateToFacing(be.method_11010()), replacement);
        }
    }

    default public class_2371<FactoryItemSlot> getSlots(@Nullable class_1657 player) {
        return class_2371.method_10211();
    }

    default public List<IPlatformFluidHandler<?>> getTanks() {
        return class_2371.method_10211();
    }

    default public Map<SlotsIdentifier, int[]> itemSlotsIdentifiers() {
        LinkedHashMap<SlotsIdentifier, int[]> map = new LinkedHashMap<SlotsIdentifier, int[]>();
        for (FactoryItemSlot slot : this.getSlots(null)) {
            int[] list = map.getOrDefault(slot.identifier(), new int[0]);
            if (ArrayUtils.contains((int[])list, (int)slot.method_34266())) continue;
            list = ArrayUtils.add((int[])list, (int)slot.method_34266());
            map.put(slot.identifier(), list);
        }
        return map;
    }

    default public List<class_2350> getBlockedSides() {
        return Collections.emptyList();
    }

    default public List<SlotsIdentifier> getSlotsIdentifiers() {
        return List.copyOf(this.itemSlotsIdentifiers().keySet());
    }

    default public void loadTag(class_2487 compoundTag) {
        this.getStorage(Storages.CRAFTY_ENERGY).ifPresent(e -> e.deserializeTag(compoundTag.method_10562("CYEnergy")));
        this.getStorage(Storages.ENERGY).ifPresent(e -> e.deserializeTag(compoundTag.method_10562("Energy")));
        if (!this.getTanks().isEmpty()) {
            this.getTanks().forEach(tank -> tank.deserializeTag(compoundTag.method_10562(tank.getName())));
        }
        this.getStorage(Storages.ITEM).ifPresent(e -> e.deserializeTag((class_2520)compoundTag.method_10562("inventory")));
        this.fluidSides().ifPresent(f -> FluidSide.deserializeNBT(compoundTag.method_10562("fluidSides"), f, this.getTanks()));
        this.itemSides().ifPresent(i -> ItemSide.deserializeNBT(compoundTag.method_10562("itemSides"), i, this.getSlotsIdentifiers()));
        this.energySides().ifPresent(e -> TransportState.deserializeTag(compoundTag.method_10562("energySides"), e));
    }

    default public void saveTag(class_2487 compoundTag) {
        this.getStorage(Storages.CRAFTY_ENERGY).ifPresent(e -> compoundTag.method_10566("CYEnergy", e.serializeTag()));
        this.getStorage(Storages.ENERGY).ifPresent(e -> compoundTag.method_10566("Energy", e.serializeTag()));
        if (!this.getTanks().isEmpty()) {
            this.getTanks().forEach(tank -> compoundTag.method_10566(tank.getName(), tank.serializeTag()));
        }
        this.getStorage(Storages.ITEM).ifPresent(i -> compoundTag.method_10566("inventory", i.serializeTag()));
        this.fluidSides().ifPresent(f -> compoundTag.method_10566("fluidSides", (class_2520)FluidSide.serializeTag(f, this.getTanks())));
        this.itemSides().ifPresent(i -> compoundTag.method_10566("itemSides", (class_2520)ItemSide.serializeTag(i, this.getSlotsIdentifiers())));
        this.energySides().ifPresent(e -> compoundTag.method_10566("energySides", (class_2520)TransportState.serializeTag(e)));
    }
}

