/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.ISideType;
import wily.factoryapi.base.TransportState;

public class SideList<T>
extends class_2371<T> {
    private final TransportStateHandler<T> transportStateHandler;

    public SideList(TransportStateHandler<T> transportStateHandler, Supplier<T> defaultValue) {
        super(new ArrayList<Object>(Arrays.stream(class_2350.values()).map(d -> defaultValue.get()).toList()), defaultValue.get());
        this.transportStateHandler = transportStateHandler;
    }

    public SideList(Supplier<T> defaultValue) {
        this((sideList, direction) -> (TransportState)sideList.get(direction), defaultValue);
    }

    public static <T extends ISideType<?, ?>> SideList<T> createSideTypeList(Supplier<T> defaultValue) {
        return new SideList<T>(new TransportStateHandler<T>(){

            @Override
            public TransportState get(SideList<T> sideList, class_2350 direction) {
                return ((ISideType)sideList.get(direction)).getTransport();
            }

            @Override
            public void set(TransportState transportState, SideList<T> sideList, class_2350 direction) {
                ((ISideType)sideList.get(direction)).withTransport(transportState);
            }
        }, defaultValue);
    }

    public T get(class_2350 direction) {
        return (T)(direction == null ? null : super.get(direction.ordinal()));
    }

    public void put(class_2350 direction, T side) {
        this.set(direction.ordinal(), side);
    }

    public TransportState getTransport(class_2350 direction) {
        return this.getTransportOrDefault(direction, TransportState.NONE);
    }

    public TransportState getTransportOrDefault(@Nullable class_2350 direction, TransportState defaultState) {
        return direction == null ? defaultState : this.transportStateHandler.get(this, direction);
    }

    public void setTransport(TransportState transportState, class_2350 direction) {
        this.transportStateHandler.set(transportState, this, direction);
    }

    public void forEach(BiConsumer<class_2350, ? super T> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.size(); ++i) {
            action.accept(class_2350.values()[i], (class_2350)this.get(i));
        }
    }

    public static interface TransportStateHandler<T> {
        public TransportState get(SideList<T> var1, class_2350 var2);

        default public void set(TransportState transportState, SideList<T> sideList, class_2350 direction) {
            sideList.put(direction, transportState);
        }
    }
}

