/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import wily.factoryapi.base.CraftyTransaction;
import wily.factoryapi.base.FactoryCapacityTiers;
import wily.factoryapi.base.ICraftyEnergyStorage;
import wily.factoryapi.base.TransportState;

public class SimpleItemCraftyStorage
implements ICraftyEnergyStorage {
    private static final String KEY = "energy";
    private int capacity;
    private final int maxOutput;
    private final int maxInput;
    class_1799 container;
    TransportState transportState;
    final boolean isBlockItem;
    public final FactoryCapacityTiers supportableTier;
    public FactoryCapacityTiers storedTier = FactoryCapacityTiers.BASIC;

    public SimpleItemCraftyStorage(class_1799 stack, int initialEnergy, int capacity, int maxOutput, int maxInput, TransportState transportState, FactoryCapacityTiers supportableTier, boolean isBlockItem) {
        this.supportableTier = supportableTier;
        this.isBlockItem = isBlockItem;
        this.capacity = capacity;
        this.container = stack;
        class_2487 tag = stack.method_7948();
        if (isBlockItem) {
            tag = tag.method_10562("BlockEntityTag");
        }
        if (tag.method_10562("CYEnergy").method_33133()) {
            class_2487 storage = new class_2487();
            storage.method_10569(KEY, initialEnergy);
            storage.method_10569("supportedTier", supportableTier.ordinal());
            storage.method_10569("tier", this.storedTier.ordinal());
            tag.method_10566("CYEnergy", (class_2520)storage);
            if (isBlockItem) {
                stack.method_7948().method_10566("BlockEntityTag", (class_2520)tag);
            }
        }
        this.transportState = transportState;
        this.maxOutput = maxOutput;
        this.maxInput = maxInput;
    }

    public SimpleItemCraftyStorage(class_1799 stack, int capacity, TransportState transportState, FactoryCapacityTiers supportableTier) {
        this(stack, 0, capacity, capacity, capacity, transportState, supportableTier, stack.method_7909() instanceof class_1747);
    }

    private class_2487 getEnergyCompound() {
        class_2487 tag = this.container.method_7948();
        if (this.isBlockItem) {
            tag = tag.method_10562("BlockEntityTag");
        }
        return tag.method_10562("CYEnergy");
    }

    @Override
    public CraftyTransaction receiveEnergy(CraftyTransaction transaction, boolean simulate) {
        if (transaction.isEmpty()) {
            return CraftyTransaction.EMPTY;
        }
        int energyReceived = Math.min(this.getMaxReceive(), transaction.energy);
        int energy = this.getEnergyStored();
        if (!simulate) {
            if (!this.supportableTier.supportTier(transaction.tier)) {
                return CraftyTransaction.EMPTY;
            }
            this.setStoredTier(transaction.tier);
            this.setEnergyStored(energy += energyReceived);
        }
        return new CraftyTransaction(energyReceived, transaction.tier);
    }

    @Override
    public CraftyTransaction consumeEnergy(CraftyTransaction transaction, boolean simulate) {
        if (transaction.isEmpty()) {
            return CraftyTransaction.EMPTY;
        }
        int energy = this.getEnergyStored();
        int energyExtracted = Math.min(energy, Math.min(this.getMaxConsume(), transaction.energy));
        if (!simulate) {
            if (!this.storedTier.supportTier(transaction.tier)) {
                energyExtracted = this.storedTier.convertEnergyTo(energyExtracted, transaction.tier);
            }
            this.setEnergyStored(energy -= energyExtracted);
        }
        return new CraftyTransaction(energyExtracted, transaction.tier);
    }

    @Override
    public FactoryCapacityTiers getSupportedTier() {
        return FactoryCapacityTiers.values()[this.getEnergyCompound().method_10550("supportedTier")];
    }

    @Override
    public FactoryCapacityTiers getStoredTier() {
        return FactoryCapacityTiers.values()[this.getEnergyCompound().method_10550("tier")];
    }

    @Override
    public int getEnergyStored() {
        return this.getEnergyCompound().method_10550(KEY) * this.container.method_7947();
    }

    @Override
    public void setEnergyStored(int energy) {
        class_2487 tag = this.getEnergyCompound();
        tag.method_10569(KEY, energy);
    }

    @Override
    public void setStoredTier(FactoryCapacityTiers tier) {
        class_2487 tag = this.getEnergyCompound();
        tag.method_10569("tier", tier.ordinal());
    }

    @Override
    public void setSupportedTier(FactoryCapacityTiers tier) {
        class_2487 tag = this.getEnergyCompound();
        tag.method_10569("supportedTier", tier.ordinal());
    }

    @Override
    public int getMaxEnergyStored() {
        return this.capacity * this.container.method_7947();
    }

    @Override
    public class_2487 serializeTag() {
        return this.getEnergyCompound();
    }

    @Override
    public void deserializeTag(class_2487 nbt) {
        this.container.method_7980(nbt);
    }

    @Override
    public int getMaxConsume() {
        return Math.min(this.getEnergyStored(), this.maxOutput);
    }

    @Override
    public int getMaxReceive() {
        return Math.min(this.getSpace(), this.maxInput);
    }

    @Override
    public ICraftyEnergyStorage getHandler() {
        return this;
    }

    @Override
    public TransportState getTransport() {
        return this.transportState;
    }
}

