/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_465;
import net.minecraft.class_768;
import net.minecraft.class_918;
import wily.factoryapi.base.client.IWindowWidget;
import wily.factoryapi.base.client.drawable.AbstractDrawableButton;
import wily.factoryapi.base.client.drawable.DrawableStatic;
import wily.factoryapi.base.client.drawable.IFactoryDrawableType;
import wily.factoryapi.util.ScreenUtil;

public abstract class FactoryScreenWindow<T extends class_465<?>>
extends class_339
implements IWindowWidget {
    public final AbstractDrawableButton<?> config;
    private double actualMouseX;
    private double actualMouseY;
    public boolean dragging = false;
    public boolean useGeneratedBackground;
    protected final class_918 itemRenderer;
    protected final class_327 font;
    protected final List<class_4068> nestedRenderables;
    protected final DrawableStatic drawable;
    public T parent;
    int lastX;
    int lastY;

    public FactoryScreenWindow(AbstractDrawableButton<?> config, DrawableStatic drawable, T parent) {
        super(drawable.method_3321(), drawable.method_3322(), drawable.width(), drawable.height(), (class_2561)class_2561.method_43473());
        this.font = class_310.method_1551().field_1772;
        this.nestedRenderables = new ArrayList<class_4068>();
        this.config = config;
        this.lastX = this.method_46426();
        this.lastY = this.method_46427();
        this.parent = parent;
        this.drawable = drawable;
        this.itemRenderer = class_310.method_1551().method_1480();
    }

    @Override
    public boolean isVisible() {
        return this.config.selected == Boolean.TRUE && (Boolean)this.config.visible.get() != false;
    }

    public void onClose() {
        this.config.selected = false;
        Consumer<FactoryScreenWindow> onClick = w -> {
            if (w.isVisible()) {
                w.onClickWidget();
            }
        };
        this.parent.method_25396().forEach(l -> {
            if (l instanceof FactoryScreenWindow) {
                FactoryScreenWindow s = (FactoryScreenWindow)l;
                onClick.accept(s);
            }
        });
        T t = this.parent;
        if (t instanceof IWindowWidget) {
            IWindowWidget w2 = (IWindowWidget)t;
            w2.getNestedRenderables().forEach(l -> {
                if (l instanceof FactoryScreenWindow) {
                    FactoryScreenWindow s = (FactoryScreenWindow)l;
                    onClick.accept(s);
                }
            });
        }
    }

    public void onClickWidget() {
        this.field_22765 = 1.0f;
        this.parent.method_25395((class_364)this);
    }

    public void onClickOutside(double mouseX, double mouseY) {
        this.method_25365(false);
        this.field_22765 = 0.88f;
    }

    public boolean method_25404(int i, int j, int k) {
        if (i == 256 && this.isVisible()) {
            this.onClose();
            return true;
        }
        return false;
    }

    protected void renderBg(class_332 graphics, int i, int j, float f) {
        graphics.method_51448().method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
        if (this.useGeneratedBackground) {
            ScreenUtil.drawGUIBackground(graphics, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        } else {
            this.drawable.draw(graphics, this.method_46426(), this.method_46427());
        }
        IWindowWidget.super.method_25394(graphics, i, j, f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        graphics.method_51448().method_22909();
    }

    @Override
    public List<? extends class_4068> getNestedRenderables() {
        return this.nestedRenderables;
    }

    @Override
    public <R extends class_4068> R addNestedRenderable(R drawable) {
        this.nestedRenderables.add(drawable);
        return drawable;
    }

    @Override
    public void method_25394(class_332 graphics, int i, int j, float f) {
        if (!this.isVisible()) {
            return;
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(0.0, 0.0, (double)this.getBlitOffset());
        this.renderBg(graphics, i, j, f);
        this.method_48579(graphics, i, j, f);
        this.renderToolTip(graphics, i, j);
        graphics.method_51448().method_22909();
    }

    public float getBlitOffset() {
        return 450.0f;
    }

    public void renderToolTip(class_332 graphics, int i, int j) {
    }

    public boolean method_25405(double d, double e) {
        return this.isVisible() && IFactoryDrawableType.getMouseLimit(d, e, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
    }

    public void updateActualMouse(double mouseX, double mouseY) {
        this.actualMouseX = mouseX;
        this.actualMouseY = mouseY;
    }

    public void updateLastMouse(int mouseX, int mouseY) {
        this.lastX = mouseX;
        this.lastY = mouseY;
    }

    @Override
    public boolean method_25402(double d, double e, int i) {
        if (!this.isVisible()) {
            return false;
        }
        if (i == 0) {
            if (this.method_25405(d, e) || this.config.method_25405(d, e)) {
                this.onClickWidget();
                if (this.method_25405(d, e)) {
                    this.updateActualMouse(d, e);
                }
            } else {
                this.onClickOutside(d, e);
            }
        }
        return IWindowWidget.super.method_25402(d, e, i);
    }

    @Override
    public boolean method_25406(double d, double e, int i) {
        if (this.dragging) {
            this.dragging = false;
            this.parent.method_25398(false);
            this.updateLastMouse(this.method_46426(), this.method_46427());
            return true;
        }
        return IWindowWidget.super.method_25406(d, e, i);
    }

    @Override
    public boolean method_25403(double d, double e, int i, double f, double g) {
        if (!this.isVisible() || this.parent.method_25397() && !this.dragging) {
            return false;
        }
        if (IWindowWidget.super.method_25403(d, e, i, f, g)) {
            return true;
        }
        if (i == 0 && (this.method_25405(d, e) || this.dragging)) {
            double newX = (double)this.lastX + d - this.actualMouseX;
            double newY = (double)this.lastY + e - this.actualMouseY;
            if (newX + (double)this.field_22758 < (double)((class_465)this.parent).field_22789 && newX > 0.0) {
                this.method_46421((int)newX);
            }
            if (newY + (double)this.field_22759 < (double)((class_465)this.parent).field_22790 && newY > 0.0) {
                this.method_46419((int)newY);
            }
            this.dragging = true;
            this.parent.method_25398(true);
            return true;
        }
        return false;
    }

    @Override
    public class_768 getBounds() {
        return new class_768(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
    }
}

