/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client.drawable;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.function.BiConsumer;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.drawable.DrawableCustomWidth;
import wily.factoryapi.base.client.drawable.IFactoryDrawableType;
import wily.factoryapi.util.ScreenUtil;

public abstract class AbstractDrawableButton<D extends AbstractDrawableButton<D>>
extends DrawableCustomWidth<D>
implements class_364 {
    @Nullable
    public Boolean selected;
    protected BiConsumer<D, Integer> onPress = (b, i) -> {};
    public IFactoryDrawableType selection;
    protected boolean hoverSelection = true;
    public Color color;
    public float grave = 1.5f;

    public AbstractDrawableButton(int x, int y, IFactoryDrawableType buttonImage) {
        super(buttonImage, x, y);
    }

    public D onPress(BiConsumer<D, Integer> onPress) {
        this.onPress = onPress;
        return (D)this;
    }

    public D grave(float grave) {
        this.grave = grave;
        return (D)this;
    }

    public D color(Color color) {
        this.color = color;
        return (D)this;
    }

    public D icon(IFactoryDrawableType icon) {
        return (D)((AbstractDrawableButton)this.overlay(icon));
    }

    public D select(Boolean selected) {
        this.selected = selected;
        return (D)this;
    }

    public D selection(IFactoryDrawableType selection) {
        this.selection = selection;
        return (D)this;
    }

    public D selection(IFactoryDrawableType.Direction direction) {
        return this.selection(this.adjacentImage(direction));
    }

    public D withWidth(Integer width) {
        this.customWidth = width != null ? Integer.valueOf(Math.max(4, width)) : null;
        return (D)this;
    }

    public D disableHoverSelection() {
        this.hoverSelection = false;
        return (D)this;
    }

    public boolean method_25405(double d, double e) {
        return this.inMouseLimit(d, e);
    }

    public boolean method_25402(double d, double e, int i) {
        if (this.inMouseLimit(d, e) && ((Boolean)this.visible.get()).booleanValue()) {
            ScreenUtil.playButtonDownSound(this.grave);
            if (this.selected != null) {
                this.selected = this.selected == false;
            }
            this.onPress.accept(this, i);
            return true;
        }
        return false;
    }

    @Override
    public boolean inMouseLimit(double mouseX, double mouseY) {
        return IFactoryDrawableType.getMouseLimit(mouseX, mouseY, this.method_3321(), this.method_3322(), this.width(), this.height());
    }

    @Override
    public void draw(class_332 graphics) {
        this.draw(graphics, this.method_3321(), this.method_3322());
    }

    @Override
    public void draw(class_332 graphics, int x, int y) {
        if (this.color != null) {
            graphics.method_51422((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, 1.0f);
        }
        super.draw(graphics, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)RenderSystem.getShaderColor()[3]);
        if (this.isSelected() || this.hovered && this.hoverSelection) {
            if (this.selection != null) {
                this.selection.draw(graphics, x, y);
            } else {
                graphics.method_49601(x, y, this.width(), this.height(), -1);
            }
        }
    }

    public class_8030 method_48202() {
        return ScreenUtil.rect2iToRectangle(this);
    }

    public boolean isSelected() {
        return this.selected == Boolean.TRUE;
    }

    public void method_25365(boolean bl) {
        if (bl) {
            this.selected = true;
        }
    }

    public boolean method_25370() {
        return false;
    }
}

