/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client.drawable;

import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import wily.factoryapi.base.client.drawable.AbstractDrawableButton;
import wily.factoryapi.base.client.drawable.DrawableCustomWidth;
import wily.factoryapi.base.client.drawable.IFactoryDrawableType;

public class FactoryDrawableSlider
extends AbstractDrawableButton<FactoryDrawableSlider> {
    private final DrawableCustomWidth<?> sliderBackground;
    public int value;
    public final int maxValue;
    public int relativePosX = 0;
    public boolean dragging = false;
    protected Function<FactoryDrawableSlider, class_2561> customText;

    public FactoryDrawableSlider(int x, int y, Function<FactoryDrawableSlider, class_2561> customText, IFactoryDrawableType buttonImage, IFactoryDrawableType sliderBackground, int buttonWidth, int sliderWidth, int initialValue, int maxValue) {
        super(x, y, buttonImage);
        this.customText = customText;
        this.sliderBackground = new DrawableCustomWidth(sliderBackground);
        this.sliderBackground.customWidth = sliderWidth;
        this.value = initialValue;
        this.maxValue = maxValue;
        this.customWidth = buttonWidth;
    }

    public FactoryDrawableSlider(int x, int y, Function<FactoryDrawableSlider, class_2561> customText, IFactoryDrawableType buttonImage, int buttonWidth, int sliderWidth, int initialValue, int maxValue) {
        this(x, y, customText, buttonImage, IFactoryDrawableType.create(buttonImage.texture(), buttonImage.uvX() + buttonImage.width(), buttonImage.uvY(), sliderWidth, buttonImage.height()), buttonWidth, sliderWidth, initialValue, maxValue);
    }

    public int getValue() {
        return this.value;
    }

    public float getPercentage() {
        return (float)this.value / (float)this.maxValue;
    }

    @Override
    public boolean method_25402(double d, double e, int i) {
        if (this.inMouseLimit(d, e) && !this.inButtonLimit(d, e)) {
            this.value = this.getActualValue(d);
        }
        return super.method_25402(d, e, i);
    }

    protected int getActualValue(double mouseX) {
        return Math.round(Math.max(0.0f, Math.min(((float)mouseX - (float)this.method_3321()) / (float)this.sliderBackground.width() * (float)this.maxValue, (float)this.maxValue)));
    }

    public boolean method_25406(double d, double e, int i) {
        this.dragging = false;
        this.selected = false;
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int i, double f, double g) {
        if (!((Boolean)this.visible.get()).booleanValue()) {
            return false;
        }
        if (this.inButtonLimit(mouseX, mouseY) || this.dragging) {
            this.dragging = true;
            this.selected = true;
            this.value = this.getActualValue(mouseX);
            this.onPress.accept(this, i);
            return true;
        }
        return false;
    }

    @Override
    public boolean inMouseLimit(double mouseX, double mouseY) {
        return this.sliderBackground.inMouseLimit((int)mouseX, (int)mouseY, this.method_3321(), this.method_3322());
    }

    public boolean inButtonLimit(double mouseX, double mouseY) {
        return IFactoryDrawableType.getMouseLimit(mouseX, mouseY, this.relativePosX, this.method_3322(), this.width(), this.height());
    }

    @Override
    public void draw(class_332 graphics) {
        if (this.dragging) {
            this.selected = true;
        }
        this.sliderBackground.draw(graphics, this.method_3321(), this.method_3322());
        class_2561 comp = this.customText.apply(this);
        if (comp != null && !comp.getString().isEmpty()) {
            graphics.method_27535(this.mc.field_1772, comp, this.method_3321() + (this.sliderBackground.width() - this.mc.field_1772.method_1727(comp.getString())) / 2, this.method_3322() + this.height() / 2 - 4, -1);
        }
        this.relativePosX = (int)((float)this.method_3321() + this.getPercentage() * (float)(this.sliderBackground.width() - this.width()));
        this.draw(graphics, this.relativePosX, this.method_3322());
    }
}

