/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client.drawable;

import dev.architectury.fluid.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import wily.factoryapi.base.Progress;
import wily.factoryapi.base.client.drawable.DrawableStatic;
import wily.factoryapi.base.client.drawable.DrawableStaticProgress;
import wily.factoryapi.util.ProgressElementRenderUtil;

@Environment(value=EnvType.CLIENT)
public interface IFactoryDrawableType {
    public static final IFactoryDrawableType EMPTY = new IFactoryDrawableType(){

        @Override
        public void draw(class_332 graphics, int x, int y) {
        }

        @Override
        public class_2960 texture() {
            return null;
        }

        @Override
        public int width() {
            return 0;
        }

        @Override
        public int height() {
            return 0;
        }

        @Override
        public int uvX() {
            return 0;
        }

        @Override
        public int uvY() {
            return 0;
        }
    };

    public static IFactoryDrawableType empty() {
        return EMPTY;
    }

    public class_2960 texture();

    public static DrawableImage create(class_2960 texture, int uvX, int uvY, int width, int height) {
        return new DrawableImage(texture, uvX, uvY, width, height);
    }

    public static DrawableImage create(class_2960 texture, int width, int height) {
        return new DrawableImage(texture, 0, 0, width, height);
    }

    public int width();

    public int height();

    default public DrawableImage adjacentImage(Direction direction) {
        return IFactoryDrawableType.create(this.texture(), this.uvX() + (direction.isHorizontal() ? this.width() : 0), this.uvY() + (direction.isVertical() ? this.height() : 0), this.width(), this.height());
    }

    default public void drawAsFluidTank(class_332 graphics, int x, int y, FluidStack stack, long capacity, boolean hasColor) {
        ProgressElementRenderUtil.renderFluidTank(graphics, x, y, this, stack, capacity, hasColor);
    }

    @Deprecated
    default public void drawAsFluidTank(class_332 graphics, int x, int y, int progress, FluidStack stack, boolean hasColor) {
        this.drawAsFluidTank(graphics, x, y, stack, progress == 0 ? 0L : (long)((int)(stack.getAmount() / (long)(progress / this.height()))), hasColor);
    }

    default public boolean inMouseLimit(double mouseX, double mouseY, int posX, int posY) {
        return IFactoryDrawableType.getMouseLimit(mouseX, mouseY, posX, posY, this.width(), this.height());
    }

    default public void draw(class_332 graphics, int x, int y) {
        graphics.method_25302(this.texture(), x, y, this.uvX(), this.uvY(), this.width(), this.height());
    }

    public int uvX();

    public int uvY();

    public static boolean getMouseLimit(double mouseX, double mouseY, int posX, int posY, int sizeX, int sizeY) {
        return mouseX >= (double)posX && mouseX < (double)(posX + sizeX) && mouseY >= (double)posY && mouseY < (double)(posY + sizeY);
    }

    public record DrawableImage(class_2960 texture, int uvX, int uvY, int width, int height) implements IFactoryDrawableType
    {
        @Deprecated
        public DrawableProgress asProgress(Progress.Identifier identifier, boolean reverse, Direction plane) {
            return this.asProgress(reverse, plane);
        }

        public DrawableProgress asProgress(boolean reverse, Direction plane) {
            return new DrawableProgress(this, reverse, plane);
        }

        public DrawableStatic createStatic(int posX, int posY) {
            return new DrawableStatic(this, posX, posY);
        }
    }

    public static enum Direction {
        VERTICAL,
        HORIZONTAL;


        public boolean isVertical() {
            return this == VERTICAL;
        }

        public boolean isHorizontal() {
            return this == HORIZONTAL;
        }
    }

    public record DrawableProgress(DrawableImage drawable, boolean reverse, Direction plane) implements IFactoryDrawableType
    {
        public void drawProgress(class_332 graphics, int x, int y, float percentage) {
            ProgressElementRenderUtil.renderDefaultProgress(graphics, x, y, percentage, this);
        }

        public void drawProgress(class_332 graphics, int x, int y, int progress, int max) {
            ProgressElementRenderUtil.renderDefaultProgress(graphics, x, y, max <= 0 ? 0.0f : (float)progress / (float)max, this);
        }

        public void drawProgress(class_332 graphics, int relativeX, int relativeY, Progress progress) {
            progress.forEach(p -> this.drawProgress(graphics, relativeX + p.x, relativeY + p.y, (Integer)p.get(), p.maxProgress));
        }

        public DrawableStaticProgress createStatic(int posX, int posY) {
            return new DrawableStaticProgress(this, posX, posY);
        }

        @Override
        public class_2960 texture() {
            return this.drawable.texture;
        }

        @Override
        public int width() {
            return this.drawable.width;
        }

        @Override
        public int height() {
            return this.drawable.height;
        }

        @Override
        public int uvX() {
            return this.drawable.uvX;
        }

        @Override
        public int uvY() {
            return this.drawable.uvY;
        }
    }
}

