/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.fabric;

import dev.architectury.fluid.FluidStack;
import java.nio.file.Path;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.impl.SimpleItemEnergyStorageImpl;
import wily.factoryapi.ItemContainerUtil;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.ICraftyEnergyStorage;
import wily.factoryapi.base.ICraftyStorageItem;
import wily.factoryapi.base.IEnergyStorageItem;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IFluidHandlerItem;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandlerApi;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.SimpleItemCraftyStorage;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.Storages;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.fabric.ItemContainerUtilImpl;
import wily.factoryapi.fabric.base.CraftyEnergyStorage;
import wily.factoryapi.fabric.base.FabricEnergyStorage;
import wily.factoryapi.fabric.base.FabricEnergyStoragePlatform;
import wily.factoryapi.fabric.base.FabricFluidStorage;
import wily.factoryapi.fabric.base.FabricItemFluidStorage;
import wily.factoryapi.fabric.base.FabricItemStorage;

public class FactoryAPIPlatformImpl {
    public static Path getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static IPlatformFluidHandler<?> getFluidHandlerApi(long Capacity, class_2586 be, Predicate<FluidStack> validator, SlotsIdentifier differential, TransportState transportState) {
        return new FabricFluidStorage(Capacity, be, validator, differential, transportState);
    }

    public static IPlatformItemHandler<?> getItemHandlerApi(int Capacity, class_2586 be) {
        return new FabricItemStorage(Capacity, be, TransportState.EXTRACT_INSERT);
    }

    public static IPlatformItemHandler<?> filteredOf(IPlatformItemHandler itemHandler, class_2350 direction, int[] slots, TransportState transportState) {
        return FabricItemStorage.filtered(itemHandler, direction, slots, transportState);
    }

    public static IPlatformFluidHandler<?> filteredOf(IPlatformFluidHandler fluidHandler, TransportState transportState) {
        return FabricFluidStorage.filtered(fluidHandler, transportState);
    }

    public static IPlatformFluidHandler<?> getItemFluidHandler(class_1799 container) {
        ContainerItemContext context = ItemContainerUtilImpl.slotContextFromItemStack(container);
        Storage handStorage = (Storage)context.find(FluidStorage.ITEM);
        if (handStorage instanceof IPlatformFluidHandler) {
            IPlatformFluidHandler p = (IPlatformFluidHandler)handStorage;
            return p;
        }
        if (container.method_7909() instanceof IFluidHandlerItem) {
            return FactoryAPIPlatformImpl.getItemFluidHandler(container, context);
        }
        return handStorage != null ? () -> handStorage : null;
    }

    public static IPlatformFluidHandler<?> getItemFluidHandler(class_1799 container, ContainerItemContext context) {
        FabricItemFluidStorage fabricItemFluidStorage;
        class_1792 class_17922 = container.method_7909();
        if (class_17922 instanceof IFluidHandlerItem) {
            IFluidHandlerItem f = (IFluidHandlerItem)class_17922;
            fabricItemFluidStorage = new FabricItemFluidStorage(context, f.getCapacity(), f::isFluidValid, f.getTransport());
        } else {
            fabricItemFluidStorage = null;
        }
        return fabricItemFluidStorage;
    }

    public static IPlatformEnergyStorage<?> getItemEnergyStorage(class_1799 container) {
        ContainerItemContext context = ItemContainerUtilImpl.slotContextFromItemStack(container);
        EnergyStorage handStorage = (EnergyStorage)EnergyStorage.ITEM.find(container, (Object)context);
        if (handStorage instanceof IPlatformEnergyStorage) {
            IPlatformEnergyStorage p = (IPlatformEnergyStorage)handStorage;
            return p;
        }
        if (container.method_7909() instanceof IEnergyStorageItem) {
            return FactoryAPIPlatformImpl.getItemEnergyStorage(container, context);
        }
        return handStorage != null ? () -> handStorage : null;
    }

    public static IPlatformEnergyStorage<?> getItemEnergyStorage(class_1799 container, ContainerItemContext context) {
        FabricEnergyStoragePlatform fabricEnergyStoragePlatform;
        class_1792 class_17922 = container.method_7909();
        if (class_17922 instanceof IEnergyStorageItem) {
            IEnergyStorageItem f = (IEnergyStorageItem)class_17922;
            fabricEnergyStoragePlatform = () -> SimpleItemEnergyStorageImpl.createSimpleStorage((ContainerItemContext)context, (long)f.getCapacity(), (long)(f.getTransport().canInsert() ? (long)f.getMaxReceive() : 0L), (long)(f.getTransport().canExtract() ? (long)f.getMaxConsume() : 0L));
        } else {
            fabricEnergyStoragePlatform = null;
        }
        return fabricEnergyStoragePlatform;
    }

    public static IPlatformEnergyStorage<?> getEnergyStorageApi(int Capacity, class_2586 be) {
        return new FabricEnergyStorage(Capacity, be);
    }

    public static class_2561 getPlatformEnergyComponent() {
        return class_2561.method_43470((String)"Energy (E)").method_27692(class_124.field_1065);
    }

    public static IPlatformEnergyStorage filteredOf(IPlatformEnergyStorage fluidHandler, TransportState transportState) {
        return FabricEnergyStorage.filtered(fluidHandler, transportState);
    }

    public static IFactoryStorage getPlatformFactoryStorage(final class_2586 be) {
        if (be instanceof IFactoryStorage) {
            IFactoryStorage s = (IFactoryStorage)be;
            return s;
        }
        return new IFactoryStorage(){

            @Override
            public <T extends IPlatformHandlerApi<?>> ArbitrarySupplier<T> getStorage(Storages.Storage<T> storage, class_2350 direction) {
                if (be.method_11002()) {
                    ICraftyEnergyStorage energyStorage;
                    if (storage == Storages.ITEM) {
                        Storage variantStorage = (Storage)ItemStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, (Object)direction);
                        if (variantStorage instanceof IPlatformItemHandler) {
                            return () -> (IPlatformHandlerApi)variantStorage;
                        }
                        if (variantStorage != null) {
                            return () -> () -> variantStorage;
                        }
                    } else if (storage == Storages.FLUID) {
                        Storage variantStorage = (Storage)FluidStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, (Object)direction);
                        if (variantStorage instanceof IPlatformFluidHandler) {
                            return () -> (IPlatformHandlerApi)variantStorage;
                        }
                        if (variantStorage != null) {
                            return () -> () -> variantStorage;
                        }
                    } else if (storage == Storages.ENERGY) {
                        EnergyStorage energyStorage2 = (EnergyStorage)EnergyStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, (Object)direction);
                        if (energyStorage2 instanceof IPlatformEnergyStorage) {
                            return () -> (IPlatformHandlerApi)energyStorage2;
                        }
                        if (energyStorage2 != null) {
                            return () -> () -> energyStorage2;
                        }
                    } else if (storage == Storages.CRAFTY_ENERGY && (energyStorage = (ICraftyEnergyStorage)CraftyEnergyStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, (Object)direction)) != null) {
                        return () -> energyStorage;
                    }
                }
                return () -> null;
            }
        };
    }

    public static ICraftyEnergyStorage getItemCraftyEnergyStorage(class_1799 container) {
        ICraftyEnergyStorage craftyStorage = (ICraftyEnergyStorage)CraftyEnergyStorage.ITEM.find(container, (Object)ItemContainerUtilImpl.slotContextFromItemStack(container));
        if (craftyStorage == null) {
            return FactoryAPIPlatformImpl.getItemCraftyEnergyStorageApi(container);
        }
        return craftyStorage;
    }

    public static ICraftyEnergyStorage getItemCraftyEnergyStorageApi(class_1799 container) {
        SimpleItemCraftyStorage simpleItemCraftyStorage;
        class_1792 class_17922 = container.method_7909();
        if (class_17922 instanceof ICraftyStorageItem) {
            ICraftyStorageItem f = (ICraftyStorageItem)class_17922;
            simpleItemCraftyStorage = new SimpleItemCraftyStorage(container, 0, f.getCapacity(), f.getMaxConsume(), f.getMaxReceive(), f.getTransport(), f.getSupportedEnergyTier(), ItemContainerUtil.isBlockItem(container));
        } else {
            simpleItemCraftyStorage = null;
        }
        return simpleItemCraftyStorage;
    }
}

