/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.fabric;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import team.reborn.energy.api.EnergyStorage;
import wily.factoryapi.ItemContainerUtil;

public class ItemContainerEnergyCompat {
    public static boolean isEnergyContainer(class_1799 stack) {
        ContainerItemContext context = ContainerItemContext.withConstant((class_1799)stack);
        return context.find(EnergyStorage.ITEM) != null;
    }

    public static ItemContainerUtil.ItemEnergyContext insertEnergy(int energy, ContainerItemContext context, class_1657 player) {
        StoragePreconditions.notNegative((long)energy);
        EnergyStorage handStorage = (EnergyStorage)context.find(EnergyStorage.ITEM);
        if (handStorage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                try (Transaction nested = transaction.openNested();){
                    energy = (int)handStorage.insert((long)energy, (TransactionContext)nested);
                    if (player == null || !player.method_7337()) {
                        nested.commit();
                    }
                }
                transaction.commit();
                ItemContainerUtil.ItemEnergyContext itemEnergyContext = new ItemContainerUtil.ItemEnergyContext(energy, context.getItemVariant().toStack((int)context.getAmount()));
                return itemEnergyContext;
            }
        }
        return new ItemContainerUtil.ItemEnergyContext(0, context.getItemVariant().toStack((int)context.getAmount()));
    }

    public static ItemContainerUtil.ItemEnergyContext extractEnergy(int energy, ContainerItemContext context, class_1657 player) {
        StoragePreconditions.notNegative((long)energy);
        EnergyStorage handStorage = (EnergyStorage)context.find(EnergyStorage.ITEM);
        if (handStorage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                int amount;
                try (Transaction nested = transaction.openNested();){
                    amount = (int)handStorage.extract((long)energy, (TransactionContext)nested);
                    if (player == null || !player.method_7337()) {
                        nested.commit();
                    }
                }
                transaction.commit();
                ItemContainerUtil.ItemEnergyContext itemEnergyContext = new ItemContainerUtil.ItemEnergyContext(amount, context.getItemVariant().toStack((int)context.getAmount()));
                return itemEnergyContext;
            }
        }
        return new ItemContainerUtil.ItemEnergyContext(0, context.getItemVariant().toStack((int)context.getAmount()));
    }

    public static int getEnergy(class_1799 stack) {
        EnergyStorage handStorage = (EnergyStorage)ContainerItemContext.withConstant((class_1799)stack).find(EnergyStorage.ITEM);
        if (handStorage != null) {
            return (int)handStorage.getAmount();
        }
        return 0;
    }
}

