/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.fabric;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidBucketHooksImpl;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.ItemContainerUtil;
import wily.factoryapi.fabric.ItemContainerEnergyCompat;

public class ItemContainerUtilImpl {
    protected static boolean bucket(ContainerItemContext context) {
        class_1755 bucketItem;
        class_1792 class_17922 = context.getItemVariant().getItem();
        return class_17922 instanceof class_1755 && FluidBucketHooksImpl.getFluid((class_1755)(bucketItem = (class_1755)class_17922)) != null;
    }

    public static boolean isFluidContainer(class_1799 stack) {
        ContainerItemContext context = ItemContainerUtilImpl.slotContextFromItemStack(stack);
        return context.find(FluidStorage.ITEM) != null;
    }

    public static FluidStack getFluid(ContainerItemContext context) {
        Iterator iterator;
        Storage handStorage = (Storage)context.find(FluidStorage.ITEM);
        if (handStorage != null && (iterator = handStorage.iterator()).hasNext()) {
            StorageView view = (StorageView)iterator.next();
            return FluidStackHooksFabric.fromFabric((StorageView)view);
        }
        return FluidStack.empty();
    }

    public static FluidStack getFluid(class_1657 player, class_1268 hand) {
        return ItemContainerUtilImpl.getFluid(ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand));
    }

    public static FluidStack getFluid(class_1799 stack) {
        return ItemContainerUtilImpl.getFluid(ItemContainerUtilImpl.slotContextFromItemStack(stack));
    }

    public static ItemContainerUtil.ItemFluidContext fillItem(class_1799 stack, FluidStack fluidStack) {
        return ItemContainerUtilImpl.fillItem(ItemContainerUtilImpl.slotContextFromItemStack(stack), fluidStack, null);
    }

    public static long fillItem(FluidStack fluidStack, class_1657 player, class_1268 hand) {
        ContainerItemContext context = ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand);
        return ItemContainerUtilImpl.fillItem(context, fluidStack, player).fluidStack().getAmount();
    }

    public static ItemContainerUtil.ItemFluidContext fillItem(ContainerItemContext context, FluidStack fluidStack, @Nullable class_1657 player) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)FluidStackHooksFabric.toFabric((FluidStack)fluidStack), (long)fluidStack.getAmount());
        Storage handStorage = (Storage)context.find(FluidStorage.ITEM);
        if (handStorage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                try (Transaction nested = transaction.openNested();){
                    fluidStack.setAmount(handStorage.insert((Object)FluidStackHooksFabric.toFabric((FluidStack)fluidStack), fluidStack.getAmount(), (TransactionContext)nested));
                    if (player != null) {
                        player.method_37908().method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), FluidVariantAttributes.getFillSound((FluidVariant)FluidStackHooksFabric.toFabric((FluidStack)fluidStack)), class_3419.field_15248, 1.0f, 1.0f);
                        if (!player.method_7337()) {
                            nested.commit();
                        }
                    } else {
                        nested.commit();
                    }
                }
                transaction.commit();
                ItemContainerUtil.ItemFluidContext itemFluidContext = new ItemContainerUtil.ItemFluidContext(fluidStack, context.getItemVariant().toStack((int)context.getAmount()));
                return itemFluidContext;
            }
        }
        return new ItemContainerUtil.ItemFluidContext(context.getItemVariant().toStack((int)context.getAmount()));
    }

    public static ItemContainerUtil.ItemFluidContext drainItem(long maxDrain, ContainerItemContext context, @Nullable class_1657 player) {
        Storage handStorage = (Storage)context.find(FluidStorage.ITEM);
        if (handStorage != null) {
            for (StorageView view : handStorage) {
                if (view.isResourceBlank()) continue;
                FluidVariant storedResource = (FluidVariant)view.getResource();
                try (Transaction transaction = Transaction.openOuter();){
                    long amount = view.extract((Object)storedResource, maxDrain, (TransactionContext)transaction);
                    if (player != null) {
                        if (amount > 0L) {
                            player.method_37908().method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), FluidVariantAttributes.getEmptySound((FluidVariant)storedResource), class_3419.field_15245, 1.0f, 1.0f);
                        }
                        if (!player.method_7337()) {
                            transaction.commit();
                        }
                    } else {
                        transaction.commit();
                    }
                    ItemContainerUtil.ItemFluidContext itemFluidContext = new ItemContainerUtil.ItemFluidContext(FluidStack.create((class_3611)storedResource.getFluid(), (long)amount), context.getItemVariant().toStack((int)context.getAmount()));
                    return itemFluidContext;
                }
            }
        }
        return new ItemContainerUtil.ItemFluidContext(context.getItemVariant().toStack((int)context.getAmount()));
    }

    public static FluidStack drainItem(long maxDrain, class_1657 player, class_1268 hand) {
        ContainerItemContext context = ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand);
        return ItemContainerUtilImpl.drainItem(maxDrain, context, player).fluidStack();
    }

    public static ItemContainerUtil.ItemFluidContext drainItem(long maxDrain, class_1799 stack) {
        return ItemContainerUtilImpl.drainItem(maxDrain, ItemContainerUtilImpl.slotContextFromItemStack(stack), null);
    }

    public static boolean isEnergyContainer(class_1799 stack) {
        return ItemContainerEnergyCompat.isEnergyContainer(stack);
    }

    public static int insertEnergy(int energy, class_1657 player, class_1268 hand) {
        return ItemContainerEnergyCompat.insertEnergy(energy, ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand), player).contextEnergy();
    }

    public static ItemContainerUtil.ItemEnergyContext insertEnergy(int energy, class_1799 stack) {
        return ItemContainerEnergyCompat.insertEnergy(energy, ItemContainerUtilImpl.slotContextFromItemStack(stack), null);
    }

    public static int extractEnergy(int energy, class_1657 player, class_1268 hand) {
        return ItemContainerEnergyCompat.extractEnergy(energy, ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand), player).contextEnergy();
    }

    public static ItemContainerUtil.ItemEnergyContext extractEnergy(int energy, class_1799 stack) {
        return ItemContainerEnergyCompat.extractEnergy(energy, ItemContainerUtilImpl.slotContextFromItemStack(stack), null);
    }

    public static ContainerItemContext slotContextFromItemStack(class_1799 stack) {
        return ContainerItemContext.ofSingleSlot((SingleSlotStorage)InventoryStorage.of((class_1263)new class_1277(new class_1799[]{stack}), null).getSlot(0));
    }

    public static int getEnergy(class_1799 stack) {
        return ItemContainerEnergyCompat.getEnergy(stack);
    }
}

