/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.fabric.base;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.fabric.base.FabricFluidStoragePlatform;

public class FabricFluidStorage
extends SingleVariantStorage<FluidVariant>
implements FabricFluidStoragePlatform {
    private final class_2586 be;
    protected Predicate<FluidStack> validator;
    private final SlotsIdentifier differential;
    protected final TransportState transportState;
    protected long capacity;

    public FabricFluidStorage(long Capacity, class_2586 be, TransportState transportState) {
        this(Capacity, be, f -> true, SlotsIdentifier.GENERIC, transportState);
    }

    public FabricFluidStorage(long capacity, class_2586 be, Predicate<FluidStack> validator, SlotsIdentifier differential, TransportState transportState) {
        this.be = be;
        this.validator = validator;
        this.differential = differential;
        this.transportState = transportState;
        this.capacity = capacity;
    }

    public static FabricFluidStorage filtered(final IPlatformFluidHandler<FabricFluidStorage> fluidHandler, TransportState transportState) {
        FabricFluidStorage newFluidHandler = new FabricFluidStorage(fluidHandler.getMaxFluid(), ((FabricFluidStorage)fluidHandler.getHandler()).be, fluidHandler::isFluidValid, fluidHandler.identifier(), transportState){

            @Override
            @NotNull
            public FluidStack getFluidStack() {
                return fluidHandler.getFluidStack();
            }

            public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
                if (!this.canInsert(insertedVariant)) {
                    return 0L;
                }
                return ((FabricFluidStorage)fluidHandler.getHandler()).insert((TransferVariant)insertedVariant, maxAmount, transaction);
            }

            public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
                if (!this.canExtract(extractedVariant)) {
                    return 0L;
                }
                return ((FabricFluidStorage)fluidHandler.getHandler()).extract((TransferVariant)extractedVariant, maxAmount, transaction);
            }

            protected boolean canExtract(FluidVariant variant) {
                return super.canExtract((TransferVariant)variant) && this.transportState.canExtract();
            }

            @Override
            protected boolean canInsert(FluidVariant variant) {
                return super.canInsert(variant) && this.transportState.canInsert();
            }

            @Override
            public void setFluid(FluidStack fluidStack) {
                fluidHandler.setFluid(fluidStack);
            }
        };
        return newFluidHandler;
    }

    @Override
    public long getMaxFluid() {
        return this.getCapacity();
    }

    @Override
    public boolean isFluidValid(@NotNull FluidStack stack) {
        return this.validator.test(stack);
    }

    @Override
    @NotNull
    public FluidStack drain(long maxDrain, boolean simulate) {
        return this.drain(this.getFluidStack().copyWithAmount(maxDrain), simulate);
    }

    @Override
    public void setFluid(FluidStack fluidStack) {
        this.amount = fluidStack.getAmount();
        this.variant = FluidStackHooksFabric.toFabric((FluidStack)fluidStack);
    }

    @Override
    public SlotsIdentifier identifier() {
        return this.differential;
    }

    protected FluidVariant getBlankVariant() {
        return FluidVariant.blank();
    }

    protected long getCapacity(FluidVariant variant) {
        return this.capacity;
    }

    protected void onFinalCommit() {
        this.be.method_5431();
        super.onFinalCommit();
    }

    @Override
    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    protected boolean canInsert(FluidVariant variant) {
        return this.isFluidValid(FluidStackHooksFabric.fromFabric((FluidVariant)variant, (long)FluidStack.bucketAmount()));
    }

    @Override
    public SingleVariantStorage<FluidVariant> getHandler() {
        return this;
    }

    @Override
    public TransportState getTransport() {
        return this.transportState;
    }
}

