/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.fabric.base;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;

public interface FabricFluidStoragePlatform
extends IPlatformFluidHandler<Storage<FluidVariant>> {
    @Override
    @NotNull
    default public FluidStack getFluidStack() {
        Iterator iterator = ((Storage)this.getHandler()).iterator();
        if (iterator.hasNext()) {
            StorageView view = (StorageView)iterator.next();
            return FluidStackHooksFabric.fromFabric((StorageView)view);
        }
        return FluidStack.empty();
    }

    @Override
    default public void deserializeTag(class_2487 tag) {
        this.setFluid(FluidStackHooksFabric.fromFabric((FluidVariant)FluidVariant.fromNbt((class_2487)tag.method_10562("fluidVariant")), (long)tag.method_10537("amount")));
        if (tag.method_10545("capacity")) {
            this.setCapacity(tag.method_10537("capacity"));
        }
    }

    @Override
    default public class_2487 serializeTag() {
        class_2487 tag = new class_2487();
        for (StorageView view : (Storage)this.getHandler()) {
            tag.method_10566("fluidVariant", (class_2520)((FluidVariant)view.getResource()).toNbt());
            tag.method_10544("amount", view.getAmount());
            tag.method_10544("capacity", view.getCapacity());
        }
        return tag;
    }

    @Override
    default public long getMaxFluid() {
        Iterator iterator = ((Storage)this.getHandler()).iterator();
        if (iterator.hasNext()) {
            StorageView view = (StorageView)iterator.next();
            return view.getCapacity();
        }
        return 0L;
    }

    @Override
    default public boolean isFluidValid(@NotNull FluidStack stack) {
        return true;
    }

    @Override
    default public long fill(FluidStack resource, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long i = !simulate ? (long)((int)((Storage)this.getHandler()).insert((Object)FluidStackHooksFabric.toFabric((FluidStack)resource), resource.getAmount(), (TransactionContext)transaction)) : (long)((int)((Storage)this.getHandler()).simulateInsert((Object)FluidStackHooksFabric.toFabric((FluidStack)resource), resource.getAmount(), (TransactionContext)transaction));
            transaction.commit();
            long l = i;
            return l;
        }
    }

    @Override
    @NotNull
    default public FluidStack drain(FluidStack resource, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long i = !simulate ? (long)((int)((Storage)this.getHandler()).extract((Object)FluidStackHooksFabric.toFabric((FluidStack)resource), resource.getAmount(), (TransactionContext)transaction)) : (long)((int)((Storage)this.getHandler()).simulateExtract((Object)FluidStackHooksFabric.toFabric((FluidStack)resource), resource.getAmount(), (TransactionContext)transaction));
            transaction.commit();
            FluidStack fluidStack = FluidStack.create((class_3611)resource.getFluid(), (long)i);
            return fluidStack;
        }
    }

    @Override
    @NotNull
    default public FluidStack drain(long maxDrain, boolean simulate) {
        Iterator iterator = ((Storage)this.getHandler()).iterator();
        if (iterator.hasNext()) {
            StorageView view = (StorageView)iterator.next();
            return this.drain(FluidStackHooksFabric.fromFabric((FluidVariant)((FluidVariant)view.getResource()), (long)maxDrain), simulate);
        }
        return FluidStack.empty();
    }

    @Override
    default public void setFluid(FluidStack fluidStack) {
        for (StorageView view : (Storage)this.getHandler()) {
            this.drain((int)view.getAmount(), false);
        }
        this.fill(fluidStack, false);
    }

    @Override
    default public SlotsIdentifier identifier() {
        return SlotsIdentifier.GENERIC;
    }

    @Override
    default public TransportState getTransport() {
        return TransportState.EXTRACT_INSERT;
    }
}

