/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.fabric.base;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantItemStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.ItemContainerUtil;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.fabric.base.FabricFluidStoragePlatform;

public class FabricItemFluidStorage
extends SingleVariantItemStorage<FluidVariant>
implements FabricFluidStoragePlatform {
    private long Capacity;
    ContainerItemContext context;
    protected Predicate<FluidStack> validator;
    protected TransportState transportState;

    public FabricItemFluidStorage(ContainerItemContext c, long Capacity) {
        this(c, Capacity, f -> true, TransportState.EXTRACT_INSERT);
    }

    public FabricItemFluidStorage(ContainerItemContext c, long Capacity, Predicate<FluidStack> validator, TransportState transportState) {
        super(c);
        this.context = c;
        this.Capacity = Capacity;
        this.validator = validator;
        this.transportState = transportState;
    }

    protected FluidVariant getBlankResource() {
        return FluidVariant.blank();
    }

    protected FluidVariant getResource(ItemVariant currentVariant) {
        return FluidVariant.fromNbt((class_2487)this.getFluidCompound(currentVariant.toStack()).method_10562("fluidVariant"));
    }

    protected long getAmount(ItemVariant currentVariant) {
        return this.getFluidCompound(currentVariant.toStack()).method_10550("amount");
    }

    protected long getCapacity(FluidVariant variant) {
        return this.getMaxFluid();
    }

    protected ItemVariant getUpdatedVariant(ItemVariant currentVariant, FluidVariant newResource, long newAmount) {
        class_1799 stack = currentVariant.toStack();
        stack.method_7980(this.getUpdatedTag(FluidStack.create((class_3611)newResource.getFluid(), (long)newAmount)));
        return ItemVariant.of((class_1799)stack);
    }

    private class_2487 getUpdatedTag(FluidStack newStack) {
        class_1799 stack = this.context.getItemVariant().toStack();
        boolean b = ItemContainerUtil.isBlockItem(stack);
        class_2487 tag = stack.method_7948();
        if (b) {
            tag = tag.method_10562("BlockEntityTag");
        }
        class_2487 newTag = new class_2487();
        newTag.method_10566("fluidVariant", (class_2520)FluidStackHooksFabric.toFabric((FluidStack)newStack).toNbt());
        newTag.method_10544("amount", newStack.getAmount());
        tag.method_10566(b ? "singleTank" : "fluidStorage", (class_2520)newTag);
        if (b) {
            stack.method_7969().method_10566("BlockEntityTag", (class_2520)tag);
        }
        return stack.method_7969();
    }

    private class_2487 getFluidCompound(class_1799 stack) {
        return ItemContainerUtil.isBlockItem(stack) ? stack.method_7948().method_10562("BlockEntityTag").method_10562("singleTank") : stack.method_7948().method_10562("fluidStorage");
    }

    @Override
    @NotNull
    public FluidStack getFluidStack() {
        return FluidStack.create((class_3611)this.getResource(this.context.getItemVariant()).getFluid(), (long)this.getAmount());
    }

    @Override
    public long getMaxFluid() {
        return this.Capacity;
    }

    @Override
    public boolean isFluidValid(@NotNull FluidStack stack) {
        return this.validator.test(stack);
    }

    protected boolean canInsert(FluidVariant variant) {
        return this.isFluidValid(FluidStackHooksFabric.fromFabric((FluidVariant)variant, (long)FluidStack.bucketAmount())) && this.getTransport().canInsert();
    }

    protected boolean canExtract(FluidVariant variant) {
        return this.isFluidValid(FluidStackHooksFabric.fromFabric((FluidVariant)variant, (long)FluidStack.bucketAmount())) && this.getTransport().canExtract();
    }

    @Override
    @NotNull
    public FluidStack drain(long maxDrain, boolean simulate) {
        return this.drain(FluidStackHooksFabric.fromFabric((FluidVariant)((FluidVariant)this.getResource()), (long)maxDrain), simulate);
    }

    @Override
    public void setFluid(FluidStack fluidStack) {
        try (Transaction transaction = Transaction.openOuter();){
            this.context.exchange(this.getUpdatedVariant(this.context.getItemVariant(), FluidStackHooksFabric.toFabric((FluidStack)fluidStack), fluidStack.getAmount()), 1L, (TransactionContext)transaction);
        }
    }

    @Override
    public SlotsIdentifier identifier() {
        return SlotsIdentifier.GENERIC;
    }

    @Override
    public Storage<FluidVariant> getHandler() {
        return this;
    }

    @Override
    public TransportState getTransport() {
        return this.transportState;
    }

    @Override
    public void setCapacity(long capacity) {
        this.getFluidCompound(this.context.getItemVariant().toStack()).method_10569("capacity", (int)capacity);
    }
}

