/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.fabric.base;

import java.util.function.BiPredicate;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.TransportState;

public interface FabricItemStoragePlatform
extends IPlatformItemHandler<Storage<ItemVariant>> {
    default public int method_5439() {
        int s = 0;
        for (StorageView view : (Storage)this.getHandler()) {
            ++s;
        }
        return s;
    }

    default public boolean method_5442() {
        for (StorageView view : (Storage)this.getHandler()) {
            if (view.isResourceBlank()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    default public class_1799 method_5438(int slot) {
        Object object = this.getHandler();
        if (object instanceof SlottedStorage) {
            SlottedStorage slots = (SlottedStorage)object;
            return ((ItemVariant)slots.getSlot(slot).getResource()).toStack(slots.getSlotCount());
        }
        return class_1799.field_8037;
    }

    default public class_1799 method_5441(int i) {
        Object object = this.getHandler();
        if (object instanceof SlottedStorage) {
            class_1799 stack;
            SlottedStorage slots = (SlottedStorage)object;
            SingleSlotStorage slot = slots.getSlot(i);
            try (Transaction transaction = Transaction.openOuter();){
                stack = ((ItemVariant)slot.getResource()).toStack((int)slot.extract((Object)((ItemVariant)slot.getResource()), slot.getAmount(), (TransactionContext)transaction));
                transaction.commit();
            }
            return stack;
        }
        return class_1799.field_8037;
    }

    default public void method_5447(int i, class_1799 itemStack) {
        Object object = this.getHandler();
        if (object instanceof SlottedStorage) {
            SlottedStorage slots = (SlottedStorage)object;
            SingleSlotStorage slot = slots.getSlot(i);
            try (Transaction transaction = Transaction.openOuter();){
                slot.extract((Object)((ItemVariant)slot.getResource()), slot.getAmount(), (TransactionContext)transaction);
                slot.insert((Object)ItemVariant.of((class_1799)itemStack), (long)itemStack.method_7947(), (TransactionContext)transaction);
                transaction.commit();
            }
        }
    }

    default public void method_5431() {
    }

    @Override
    @NotNull
    default public class_1799 insertItem(int i, @NotNull class_1799 stack, boolean simulate) {
        SlottedStorage slots;
        SingleSlotStorage slot;
        ItemVariant slotVariant;
        Object object;
        class_1799 inserted = class_1799.field_8037;
        if (!stack.method_7960() && (object = this.getHandler()) instanceof SlottedStorage && (slotVariant = (ItemVariant)(slot = (slots = (SlottedStorage)object).getSlot(i)).getResource()).matches(stack)) {
            try (Transaction transaction = Transaction.openOuter();){
                int count = (int)slot.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
                transaction.commit();
                inserted = ((ItemVariant)slot.getResource()).toStack(count);
            }
        }
        return inserted;
    }

    @Override
    @NotNull
    default public class_1799 extractItem(int i, int amount, boolean simulate) {
        SlottedStorage slots;
        SingleSlotStorage slot;
        ItemVariant slotVariant;
        Object object;
        class_1799 extracted = class_1799.field_8037;
        if (amount > 0 && (object = this.getHandler()) instanceof SlottedStorage && !(slotVariant = (ItemVariant)(slot = (slots = (SlottedStorage)object).getSlot(i)).getResource()).isBlank()) {
            try (Transaction transaction = Transaction.openOuter();){
                int count = (int)slot.extract((Object)((ItemVariant)slot.getResource()), (long)amount, (TransactionContext)transaction);
                transaction.commit();
                extracted = slotVariant.toStack(count);
            }
        }
        return extracted;
    }

    @Override
    default public void setExtractableSlots(BiPredicate<Integer, class_1799> extractableSlots) {
    }

    @Override
    default public void setInsertableSlots(BiPredicate<Integer, class_1799> insertableSlots) {
    }

    default public void method_5448() {
        for (StorageView view : (Storage)this.getHandler()) {
            if (view.isResourceBlank()) continue;
            Transaction transaction = Transaction.openOuter();
            try {
                view.extract((Object)((ItemVariant)view.getResource()), view.getAmount(), (TransactionContext)transaction);
                transaction.commit();
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
    }

    @Override
    default public TransportState getTransport() {
        return TransportState.EXTRACT_INSERT;
    }

    @Override
    default public class_2487 serializeTag() {
        return new class_2487();
    }

    @Override
    default public void deserializeTag(class_2487 nbt) {
    }
}

