/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_757;
import wily.factoryapi.base.client.drawable.IFactoryDrawableType;
import wily.factoryapi.util.FluidRenderUtil;

@Environment(value=EnvType.CLIENT)
public class ProgressElementRenderUtil {
    public static void renderDefaultProgress(class_332 gui, int x, int y, float percentage, IFactoryDrawableType.DrawableProgress type) {
        int progress = Math.round(percentage * (float)(type.plane().isVertical() ? type.height() : type.width()));
        if (type.reverse()) {
            if (type.plane().isHorizontal()) {
                x += type.width() - progress;
            } else {
                y += type.height() - progress;
            }
        }
        if (progress > 0) {
            if (type.plane().isHorizontal()) {
                gui.method_25302(type.texture(), x, y, type.uvX(), type.uvY(), progress, type.height());
            } else {
                gui.method_25302(type.texture(), x, y + type.height() - progress, type.uvX(), type.uvY() + (type.height() - progress), type.width(), progress);
            }
        }
    }

    public static void renderFluidTank(class_332 graphics, int x, int y, IFactoryDrawableType type, FluidStack stack, long capacity, boolean hasColor) {
        int progress;
        int n = progress = capacity <= 0L ? 0 : Math.round((float)stack.getAmount() / (float)capacity * (float)type.height());
        if (progress > 0) {
            RenderSystem.enableBlend();
            progress = (int)((double)progress / 1.3);
            int fluidWidth = type.width();
            int posY = y + type.height() - progress;
            class_1058 fluidSprite = FluidRenderUtil.fluidSprite(stack, hasColor);
            RenderSystem.setShaderTexture((int)0, (class_2960)fluidSprite.method_45852());
            RenderSystem.setShader(class_757::method_34542);
            for (int i = 0; i < fluidWidth; i += 16) {
                for (int j = 0; j < progress; j += 16) {
                    FluidRenderUtil.renderTiledFluid(graphics, x, posY, i, j, progress, fluidWidth, fluidSprite);
                }
            }
            RenderSystem.disableBlend();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)type.texture());
        type.draw(graphics, x, y);
    }
}

