/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.common.client;

import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.common.CommonMain;
import compasses.expandedstorage.common.block.AbstractChestBlock;
import compasses.expandedstorage.common.block.ChestBlock;
import compasses.expandedstorage.common.block.entity.ChestBlockEntity;
import compasses.expandedstorage.common.block.misc.Property;
import compasses.expandedstorage.common.block.misc.PropertyRetriever;
import compasses.expandedstorage.common.misc.Utils;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_827;

public final class ChestBlockEntityRenderer
implements class_827<ChestBlockEntity> {
    public static final class_5601 SINGLE_LAYER = new class_5601(Utils.id("single_chest"), "main");
    public static final class_5601 LEFT_LAYER = new class_5601(Utils.id("left_chest"), "main");
    public static final class_5601 RIGHT_LAYER = new class_5601(Utils.id("right_chest"), "main");
    public static final class_5601 TOP_LAYER = new class_5601(Utils.id("top_chest"), "main");
    public static final class_5601 BOTTOM_LAYER = new class_5601(Utils.id("bottom_chest"), "main");
    public static final class_5601 FRONT_LAYER = new class_5601(Utils.id("front_chest"), "main");
    public static final class_5601 BACK_LAYER = new class_5601(Utils.id("back_chest"), "main");
    private static final class_2680 DEFAULT_STATE = ((class_2248)class_7923.field_41175.method_10223(Utils.id("wood_chest"))).method_9564();
    private static final Property<ChestBlockEntity, Float2FloatFunction> LID_OPENNESS_FUNCTION_GETTER = new Property<ChestBlockEntity, Float2FloatFunction>(){

        @Override
        public Float2FloatFunction get(ChestBlockEntity first, ChestBlockEntity second) {
            return delta -> Math.max(first.getLidOpenness(delta), second.getLidOpenness(delta));
        }

        @Override
        public Float2FloatFunction get(ChestBlockEntity single) {
            return single::getLidOpenness;
        }
    };
    private static final Property<ChestBlockEntity, Int2IntFunction> BRIGHTNESS_PROPERTY = new Property<ChestBlockEntity, Int2IntFunction>(){

        @Override
        public Int2IntFunction get(ChestBlockEntity first, ChestBlockEntity second) {
            return i -> {
                int firstLightColor = class_761.method_23794((class_1920)first.method_10997(), (class_2338)first.method_11016());
                int firstBlockLight = class_765.method_24186((int)firstLightColor);
                int firstSkyLight = class_765.method_24187((int)firstLightColor);
                int secondLightColor = class_761.method_23794((class_1920)second.method_10997(), (class_2338)second.method_11016());
                int secondBlockLight = class_765.method_24186((int)secondLightColor);
                int secondSkyLight = class_765.method_24187((int)secondLightColor);
                return class_765.method_23687((int)Math.max(firstBlockLight, secondBlockLight), (int)Math.max(firstSkyLight, secondSkyLight));
            };
        }

        @Override
        public Int2IntFunction get(ChestBlockEntity single) {
            return i -> i;
        }
    };
    private final class_630 singleBottom;
    private final class_630 singleLid;
    private final class_630 singleLock;
    private final class_630 leftBottom;
    private final class_630 leftLid;
    private final class_630 leftLock;
    private final class_630 rightBottom;
    private final class_630 rightLid;
    private final class_630 rightLock;
    private final class_630 topBottom;
    private final class_630 topLid;
    private final class_630 topLock;
    private final class_630 bottomBottom;
    private final class_630 frontBottom;
    private final class_630 frontLid;
    private final class_630 frontLock;
    private final class_630 backBottom;
    private final class_630 backLid;

    public ChestBlockEntityRenderer(class_5614.class_5615 context) {
        class_630 single = context.method_32140(SINGLE_LAYER);
        this.singleBottom = single.method_32086("bottom");
        this.singleLid = single.method_32086("lid");
        this.singleLock = single.method_32086("lock");
        class_630 left = context.method_32140(LEFT_LAYER);
        this.leftBottom = left.method_32086("bottom");
        this.leftLid = left.method_32086("lid");
        this.leftLock = left.method_32086("lock");
        class_630 right = context.method_32140(RIGHT_LAYER);
        this.rightBottom = right.method_32086("bottom");
        this.rightLid = right.method_32086("lid");
        this.rightLock = right.method_32086("lock");
        class_630 top = context.method_32140(TOP_LAYER);
        this.topBottom = top.method_32086("bottom");
        this.topLid = top.method_32086("lid");
        this.topLock = top.method_32086("lock");
        class_630 bottom = context.method_32140(BOTTOM_LAYER);
        this.bottomBottom = bottom.method_32086("bottom");
        class_630 front = context.method_32140(FRONT_LAYER);
        this.frontBottom = front.method_32086("bottom");
        this.frontLid = front.method_32086("lid");
        this.frontLock = front.method_32086("lock");
        class_630 back = context.method_32140(BACK_LAYER);
        this.backBottom = back.method_32086("bottom");
        this.backLid = back.method_32086("lid");
    }

    public static class_5607 createSingleBodyLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117("bottom", class_5606.method_32108().method_32101(0, 19).method_32097(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), class_5603.field_27701);
        partDefinition.method_32117("lid", class_5606.method_32108().method_32101(0, 0).method_32097(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.method_32117("lock", class_5606.method_32108().method_32101(0, 0).method_32097(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)8.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)48);
    }

    public static class_5607 createLeftBodyLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117("bottom", class_5606.method_32108().method_32101(0, 19).method_32097(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), class_5603.field_27701);
        partDefinition.method_32117("lid", class_5606.method_32108().method_32101(0, 0).method_32097(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.method_32117("lock", class_5606.method_32108().method_32101(0, 0).method_32097(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)8.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)48);
    }

    public static class_5607 createRightBodyLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117("bottom", class_5606.method_32108().method_32101(0, 19).method_32097(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), class_5603.field_27701);
        partDefinition.method_32117("lid", class_5606.method_32108().method_32101(0, 0).method_32097(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.method_32117("lock", class_5606.method_32108().method_32101(0, 0).method_32097(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)8.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)48);
    }

    public static class_5607 createTopBodyLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117("bottom", class_5606.method_32108().method_32101(0, 19).method_32097(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), class_5603.field_27701);
        partDefinition.method_32117("lid", class_5606.method_32108().method_32101(0, 0).method_32097(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.method_32117("lock", class_5606.method_32108().method_32101(0, 0).method_32097(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)8.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)48);
    }

    public static class_5607 createBottomBodyLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117("bottom", class_5606.method_32108().method_32101(0, 0).method_32097(1.0f, 0.0f, 1.0f, 14.0f, 16.0f, 14.0f), class_5603.field_27701);
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)32);
    }

    public static class_5607 createFrontBodyLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117("bottom", class_5606.method_32108().method_32101(0, 20).method_32097(1.0f, 0.0f, 0.0f, 14.0f, 10.0f, 15.0f), class_5603.field_27701);
        partDefinition.method_32117("lid", class_5606.method_32108().method_32101(0, 0).method_32097(1.0f, 0.0f, 15.0f, 14.0f, 5.0f, 15.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)-15.0f));
        partDefinition.method_32117("lock", class_5606.method_32108().method_32101(0, 0).method_32097(7.0f, -1.0f, 31.0f, 2.0f, 4.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)8.0f, (float)-16.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)48);
    }

    public static class_5607 createBackBodyLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117("bottom", class_5606.method_32108().method_32101(0, 20).method_32097(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 15.0f), class_5603.field_27701);
        partDefinition.method_32117("lid", class_5606.method_32108().method_32101(0, 0).method_32097(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 15.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)1.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)48, (int)48);
    }

    private static float getLidOpenness(float delta) {
        delta = 1.0f - delta;
        delta = 1.0f - delta * delta * delta;
        return -delta * 1.5707964f;
    }

    private static void renderBottom(class_4587 stack, class_4588 consumer, class_630 bottom, int light, int overlay) {
        bottom.method_22698(stack, consumer, light, overlay);
    }

    private static void renderTop(class_4587 stack, class_4588 consumer, class_630 top, int light, int overlay, float openness) {
        top.field_3654 = openness;
        top.method_22698(stack, consumer, light, overlay);
    }

    public void render(ChestBlockEntity entity, float delta, class_4587 stack, class_4597 provider, int light, int overlay) {
        class_2248 class_22482;
        class_2680 state;
        class_2960 blockId = entity.getBlockId();
        class_2680 class_26802 = state = entity.method_11002() ? entity.method_11010() : (class_2680)DEFAULT_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035);
        if (blockId == null || !((class_22482 = state.method_26204()) instanceof ChestBlock)) {
            return;
        }
        ChestBlock block = (ChestBlock)class_22482;
        EsChestType chestType = (EsChestType)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE));
        stack.method_22903();
        stack.method_22904(0.5, 0.5, 0.5);
        int yOffset = entity.isDinnerbone() ? 180 : 0;
        stack.method_22907(class_7833.field_40716.rotationDegrees(-((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10144()));
        if (yOffset == 180) {
            stack.method_22907(class_7833.field_40718.rotationDegrees((float)yOffset));
            if (chestType == EsChestType.LEFT) {
                chestType = EsChestType.RIGHT;
            } else if (chestType == EsChestType.RIGHT) {
                chestType = EsChestType.LEFT;
            } else if (chestType == EsChestType.TOP) {
                chestType = EsChestType.BOTTOM;
            } else if (chestType == EsChestType.BOTTOM) {
                chestType = EsChestType.TOP;
            }
        }
        stack.method_22904(-0.5, -0.5, -0.5);
        PropertyRetriever<ChestBlockEntity> retriever = entity.method_11002() ? AbstractChestBlock.createPropertyRetriever(block, state, (class_1936)entity.method_10997(), entity.method_11016(), true) : PropertyRetriever.createDirect(entity);
        class_4588 consumer = new class_4730(class_4722.field_21709, CommonMain.getChestTexture(blockId, chestType)).method_24145(provider, class_1921::method_23576);
        float lidOpenness = ChestBlockEntityRenderer.getLidOpenness(retriever.get(LID_OPENNESS_FUNCTION_GETTER).orElse(f -> 0.0f).get(delta));
        int brightness = retriever.get(BRIGHTNESS_PROPERTY).orElse(i -> i).applyAsInt(light);
        if (chestType == EsChestType.SINGLE) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.singleBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.singleLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.singleLock, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.TOP) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.topBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.topLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.topLock, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.BOTTOM) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.bottomBottom, brightness, overlay);
        } else if (chestType == EsChestType.FRONT) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.frontBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.frontLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.frontLock, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.BACK) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.backBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.backLid, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.LEFT) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.leftBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.leftLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.leftLock, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.RIGHT) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.rightBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.rightLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.rightLock, brightness, overlay, lidOpenness);
        }
        stack.method_22909();
    }
}

