/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.common.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import compasses.expandedstorage.common.CommonClient;
import compasses.expandedstorage.common.client.ScreenConstructor;
import compasses.expandedstorage.common.client.SizedSimpleTexture;
import compasses.expandedstorage.common.client.function.ScreenSize;
import compasses.expandedstorage.common.client.function.ScreenSizeRetriever;
import compasses.expandedstorage.common.client.gui.CopyFunction;
import compasses.expandedstorage.common.client.gui.FakePickScreen;
import compasses.expandedstorage.common.client.gui.MiniStorageScreen;
import compasses.expandedstorage.common.client.gui.PickScreen;
import compasses.expandedstorage.common.inventory.handler.AbstractHandler;
import compasses.expandedstorage.common.misc.ErrorlessTextureGetter;
import compasses.expandedstorage.common.misc.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScreen
extends class_465<AbstractHandler> {
    private static final Map<class_2960, ScreenConstructor<?>> SCREEN_CONSTRUCTORS = new HashMap();
    private static final Map<class_2960, ScreenSizeRetriever> SIZE_RETRIEVERS = new HashMap<class_2960, ScreenSizeRetriever>();
    private static final Set<class_2960> PREFERS_SINGLE_SCREEN = new HashSet<class_2960>();
    protected final int inventoryWidth;
    protected final int inventoryHeight;
    protected final int totalSlots;
    protected final class_2960 textureLocation;
    protected final int textureWidth;
    protected final int textureHeight;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractScreen(AbstractHandler handler, class_1661 playerInventory, class_2561 title, ScreenSize screenSize) {
        super((class_1703)handler, playerInventory, title);
        this.totalSlots = handler.getInventory().method_5439();
        this.inventoryWidth = screenSize.getWidth();
        this.inventoryHeight = screenSize.getHeight();
        class_2960 class_29602 = this.textureLocation = this instanceof MiniStorageScreen ? Utils.id("textures/gui/container/mini_chest_screen.png") : Utils.id("textures/gui/container/shared_" + this.inventoryWidth + "_" + this.inventoryHeight + ".png");
        if (!(this instanceof FakePickScreen)) {
            class_1044 texture;
            boolean isTexturePresent = ((ErrorlessTextureGetter)class_310.method_1551().method_1531()).expandedstorage$isTexturePresent(this.textureLocation);
            if (!isTexturePresent && !(this instanceof MiniStorageScreen)) {
                int guiWidth = 36 + 18 * this.inventoryWidth;
                int guiHeight = 132 + 18 * this.inventoryHeight;
                int textureWidth = (int)(Math.ceil((float)guiWidth / 16.0f) * 16.0);
                int textureHeight = (int)(Math.ceil((float)guiHeight / 16.0f) * 16.0);
                RenderSystem.setShaderTexture((int)0, (class_2960)Utils.id("textures/gui/container/atlas_gen.png"));
                RenderSystem.bindTexture((int)RenderSystem.getShaderTexture((int)0));
                try (class_1011 atlas = new class_1011(96, 96, false);){
                    atlas.method_4327(0, false);
                    try (class_1011 image = new class_1011(textureWidth, textureHeight, false);){
                        image.method_4326(0, 0, textureWidth, textureHeight, 0xFFFFFF);
                        AbstractScreen.renderGui(this.inventoryWidth, this.inventoryHeight, (destX, destY, w, h, srcX, srcY) -> atlas.method_47594(image, srcX, srcY, destX, destY, w, h, false, false));
                        if (Utils.textureSaveRoot != null) {
                            try {
                                image.method_4314(Utils.textureSaveRoot.resolve("shared_" + this.inventoryWidth + "_" + this.inventoryHeight + ".png"));
                            }
                            catch (IOException e) {
                                System.out.println("Failed to save genned image.");
                            }
                        }
                        class_1043 texture2 = new class_1043(image);
                        class_310.method_1551().method_1531().method_4616(this.textureLocation, (class_1044)texture2);
                    }
                }
            }
            if ((texture = class_310.method_1551().method_1531().method_4619(this.textureLocation)) instanceof class_1043) {
                class_1043 dynamicTexture = (class_1043)texture;
                this.textureWidth = dynamicTexture.method_4525().method_4307();
                this.textureHeight = dynamicTexture.method_4525().method_4323();
                return;
            } else {
                if (!(texture instanceof SizedSimpleTexture)) throw new IllegalStateException();
                SizedSimpleTexture simpleTexture = (SizedSimpleTexture)texture;
                this.textureWidth = simpleTexture.getWidth();
                this.textureHeight = simpleTexture.getHeight();
            }
            return;
        }
        this.textureWidth = 0;
        this.textureHeight = 0;
    }

    public static void renderGui(int inventoryWidth, int inventoryHeight, CopyFunction function) {
        int x;
        int x2;
        int x3;
        function.apply(0, 0, 7, 17, 1, 1);
        for (x3 = 0; x3 < inventoryWidth; ++x3) {
            function.apply(7 + x3 * 18, 0, 18, 17, 9, 1);
        }
        function.apply(7 + inventoryWidth * 18, 0, 7, 17, 28, 1);
        function.apply(7 + inventoryWidth * 18 + 7, 0, 22, 17, 36, 1);
        for (int y = 0; y < inventoryHeight; ++y) {
            int scollbarYOffset = y == 0 ? 19 : (y == inventoryHeight - 1 ? 57 : 38);
            function.apply(0, 17 + 18 * y, 7, 18, 1, 19);
            for (x2 = 0; x2 < inventoryWidth; ++x2) {
                function.apply(7 + 18 * x2, 17 + 18 * y, 18, 18, 9, 19);
            }
            function.apply(7 + 18 * inventoryWidth, 17 + 18 * y, 7, 18, 28, 19);
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * y, 22, 18, 36, scollbarYOffset);
        }
        function.apply(0, 17 + 18 * inventoryHeight, 7, 14, 1, 38);
        for (x3 = 0; x3 < inventoryWidth; ++x3) {
            function.apply(7 + 18 * x3, 17 + 18 * inventoryHeight, 18, 14, 9, 38);
        }
        function.apply(7 + 18 * inventoryWidth, 17 + 18 * inventoryHeight, 7, 14, 28, 38);
        if (inventoryWidth > 9) {
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * inventoryHeight, 22, 17, 59, 76);
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * inventoryHeight + 17, 12, 15, 59, 1);
        } else {
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * inventoryHeight, 22, 7, 36, 76);
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * inventoryHeight + 7, 12, 15, 59, 1);
        }
        if (inventoryWidth > 9) {
            function.apply(0, 17 + 18 * inventoryHeight + 7 + 3, 7, 7, 1, 58);
            int sideParts = (int)Math.ceil((float)(inventoryWidth - 9) / 2.0f);
            for (int i = 0; i < sideParts; ++i) {
                function.apply(7 + 18 * i, 17 + 18 * inventoryHeight + 7 + 3, 18, 7, 9, 58);
                function.apply(7 + 18 * (inventoryWidth - i - 1), 17 + 18 * inventoryHeight + 7 + 3, 18, 7, 9, 58);
            }
            function.apply(7 + 18 * inventoryWidth, 17 + 18 * inventoryHeight + 7 + 3, 7, 7, 28, 58);
        }
        int startX = (int)((float)(inventoryWidth - 9) / 2.0f * 18.0f);
        for (int y = 0; y < 3; ++y) {
            function.apply(startX, 17 + 18 * (inventoryHeight + y) + 14, 7, 18, 1, 19);
            for (x2 = 0; x2 < 9; ++x2) {
                function.apply(startX + 7 + 18 * x2, 17 + 18 * (inventoryHeight + y) + 14, 18, 18, 9, 19);
            }
            function.apply(startX + 7 + 162, 17 + 18 * (inventoryHeight + y) + 14, 7, 18, 28, 19);
        }
        function.apply(startX, 17 + 18 * (inventoryHeight + 3) + 14, 7, 4, 1, 53);
        function.apply(startX, 17 + 18 * (inventoryHeight + 3) + 14 + 4, 7, 18, 1, 19);
        function.apply(startX, 17 + 18 * (inventoryHeight + 4) + 14 + 4, 7, 7, 1, 58);
        for (x = 0; x < 9; ++x) {
            function.apply(startX + 7 + 18 * x, 17 + 18 * (inventoryHeight + 3) + 14, 18, 4, 9, 53);
            function.apply(startX + 7 + 18 * x, 17 + 18 * (inventoryHeight + 3) + 14 + 4, 18, 18, 9, 19);
            function.apply(startX + 7 + 18 * x, 17 + 18 * (inventoryHeight + 4) + 14 + 4, 18, 7, 9, 58);
        }
        function.apply(startX + 7 + 162, 17 + 18 * (inventoryHeight + 3) + 14, 7, 4, 28, 53);
        function.apply(startX + 7 + 162, 17 + 18 * (inventoryHeight + 3) + 14 + 4, 7, 18, 28, 19);
        function.apply(startX + 7 + 162, 17 + 18 * (inventoryHeight + 4) + 14 + 4, 7, 7, 28, 58);
        if (inventoryWidth > 9) {
            function.apply(startX, 17 + 18 * inventoryHeight + 14, 3, 3, 20, 66);
            function.apply(startX + 162 + 11, 17 + 18 * inventoryHeight + 14, 3, 3, 24, 66);
        }
        for (x = 0; x < inventoryWidth; ++x) {
            function.apply(7 + 18 * x, 17 + 18 * (inventoryHeight + 4) + 14 + 4 + 7, 18, 18, 1, 66);
        }
    }

    public static AbstractScreen createScreen(AbstractHandler handler, class_1661 playerInventory, class_2561 title) {
        ScreenSize screenSize;
        class_2960 forcedScreenType = handler.getForcedScreenType();
        class_2960 preference = forcedScreenType != null ? forcedScreenType : CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        int scaledWidth = class_310.method_1551().method_22683().method_4486();
        int scaledHeight = class_310.method_1551().method_22683().method_4502();
        int slots = handler.getInventory().method_5439();
        if (forcedScreenType == null && AbstractScreen.canSingleScreenDisplay(slots, scaledWidth, scaledHeight) && AbstractScreen.shouldPreferSingleScreen(preference)) {
            preference = Utils.SINGLE_SCREEN_TYPE;
        }
        if ((screenSize = SIZE_RETRIEVERS.get(preference).get(slots, scaledWidth, scaledHeight)) == null) {
            throw new IllegalStateException("screenSize should never be null...");
        }
        return SCREEN_CONSTRUCTORS.get(preference).createScreen(handler, playerInventory, title, screenSize);
    }

    private static boolean shouldPreferSingleScreen(class_2960 type) {
        return PREFERS_SINGLE_SCREEN.contains(type);
    }

    private static boolean canSingleScreenDisplay(int slots, int scaledWidth, int scaledHeight) {
        if (slots <= 54) {
            return true;
        }
        if (scaledHeight >= 276) {
            if (slots <= 81) {
                return true;
            }
            if (scaledWidth >= 230 && slots <= 108) {
                return true;
            }
            if (scaledWidth >= 284 && slots <= 135) {
                return true;
            }
            if (scaledWidth >= 338 && slots <= 162) {
                return true;
            }
        }
        if (scaledWidth >= 338) {
            if (scaledHeight >= 330 && slots <= 216) {
                return true;
            }
            return scaledHeight >= 384 && slots <= 270;
        }
        return false;
    }

    public static void declareScreenType(class_2960 type, ScreenConstructor<?> screenConstructor) {
        SCREEN_CONSTRUCTORS.putIfAbsent(type, screenConstructor);
    }

    public static void declareScreenSizeRetriever(class_2960 type, ScreenSizeRetriever retriever) {
        SIZE_RETRIEVERS.putIfAbsent(type, retriever);
    }

    public static boolean isScreenTypeDeclared(class_2960 type) {
        return SCREEN_CONSTRUCTORS.containsKey(type);
    }

    public static void setPrefersSingleScreen(class_2960 type) {
        PREFERS_SINGLE_SCREEN.add(type);
    }

    @Nullable
    public static ScreenSize getScreenSize(class_2960 type, int slots, int scaledWidth, int scaledHeight) {
        return SIZE_RETRIEVERS.get(type).get(slots, scaledWidth, scaledHeight);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
    }

    public final boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.handleKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (CommonClient.platformHelper().isConfigKeyPressed(keyCode, scanCode, modifiers) && ((AbstractHandler)this.field_2797).getForcedScreenType() == null && !CommonClient.platformHelper().configWrapper().getPreferredScreenType().equals((Object)Utils.UNSET_SCREEN_TYPE)) {
            this.field_22787.method_1507((class_437)new PickScreen(this));
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @NotNull
    @ApiStatus.OverrideOnly
    public List<class_768> getExclusionZones() {
        return List.of();
    }

    public int getInventoryWidth() {
        return this.inventoryWidth;
    }
}

