/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.common.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import compasses.expandedstorage.common.CommonClient;
import compasses.expandedstorage.common.client.function.ScreenSize;
import compasses.expandedstorage.common.client.gui.AbstractScreen;
import compasses.expandedstorage.common.client.gui.TexturedRect;
import compasses.expandedstorage.common.client.gui.widget.PageButton;
import compasses.expandedstorage.common.inventory.handler.AbstractHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;

@IPNGuiHint(button=IPNButton.MOVE_TO_CONTAINER, horizontalOffset=58)
public final class PageScreen
extends AbstractScreen {
    private final Set<TexturedRect> blankArea = new LinkedHashSet<TexturedRect>();
    private final int blankSlots;
    private final int pages;
    private PageButton leftPageButton;
    private PageButton rightPageButton;
    private int page = 1;
    private class_5250 currentPageText;
    private float pageTextX;

    public PageScreen(AbstractHandler handler, class_1661 playerInventory, class_2561 title, ScreenSize screenSize) {
        super(handler, playerInventory, title, screenSize);
        this.initializeSlots(playerInventory);
        int slotsPerPage = this.inventoryWidth * this.inventoryHeight;
        this.pages = class_3532.method_15384((double)((double)this.totalSlots / (double)slotsPerPage));
        int lastPageSlots = this.totalSlots - (this.pages - 1) * slotsPerPage;
        this.blankSlots = slotsPerPage - lastPageSlots;
        this.field_2792 = 7 + 18 * this.inventoryWidth + 7;
        this.field_2779 = 17 + 18 * this.inventoryHeight + 14 + 54 + 4 + 18 + 7;
    }

    protected void method_25426() {
        super.method_25426();
        this.recalculateBlankArea();
    }

    private static boolean regionIntersects(class_339 widget, int x, int y, int width, int height) {
        return widget.method_46426() <= x + width && y <= widget.method_46427() + widget.method_25364() || x <= widget.method_46426() + widget.method_25368() && widget.method_46427() <= y + height;
    }

    public static ScreenSize retrieveScreenSize(int slots, int scaledWidth, int scaledHeight) {
        ArrayList<Pair<ScreenSize, ScreenSize>> options = new ArrayList<Pair<ScreenSize, ScreenSize>>();
        PageScreen.addEntry(options, slots, 9, 3);
        PageScreen.addEntry(options, slots, 9, 6);
        if (scaledHeight >= 276 && slots > 54) {
            PageScreen.addEntry(options, slots, 9, 9);
        }
        if (slots > 90) {
            PageScreen.addEntry(options, slots, 15, 6);
        }
        Pair<ScreenSize, ScreenSize> picked = options.get(0);
        for (int i = 1; i < options.size(); ++i) {
            Pair<ScreenSize, ScreenSize> option = options.get(i);
            int currentPages = ((ScreenSize)picked.getSecond()).getWidth();
            int currentBlankSlots = ((ScreenSize)picked.getSecond()).getHeight();
            int currentWidth = ((ScreenSize)picked.getFirst()).getWidth();
            int newPages = ((ScreenSize)option.getSecond()).getWidth();
            int newBlankSlots = ((ScreenSize)option.getSecond()).getHeight();
            int newWidth = ((ScreenSize)option.getFirst()).getWidth();
            int newHeight = ((ScreenSize)option.getFirst()).getHeight();
            if (newBlankSlots <= currentBlankSlots && newPages < currentPages && currentWidth == newWidth) {
                picked = option;
                continue;
            }
            if (CommonClient.platformHelper().configWrapper().preferSmallerScreens() && currentPages == newPages + 1 && (double)newBlankSlots < (double)(newWidth * newHeight) / 2.0 || newPages >= currentPages || !((double)newBlankSlots < (double)(newWidth * newHeight) / 2.0)) continue;
            picked = option;
        }
        return (ScreenSize)picked.getFirst();
    }

    private static void addEntry(ArrayList<Pair<ScreenSize, ScreenSize>> options, int slots, int width, int height) {
        int pages = class_3532.method_15384((double)((double)slots / (double)(width * height)));
        int blanked = slots - pages * width * height;
        options.add((Pair<ScreenSize, ScreenSize>)new Pair((Object)ScreenSize.of(width, height), (Object)ScreenSize.of(pages, blanked)));
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_25290(this.textureLocation, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, this.textureWidth, this.textureHeight);
        if (this.page == this.pages) {
            this.blankArea.forEach(image -> image.render(graphics));
        }
    }

    private void initializeSlots(class_1661 playerInventory) {
        ((AbstractHandler)this.field_2797).resetSlotPositions(true, this.inventoryWidth, this.inventoryHeight);
        int playerInvLeft = (this.inventoryWidth * 18 + 14) / 2 - 80;
        int playerInvTop = 32 + this.inventoryHeight * 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.field_2797).addClientSlot(new class_1735((class_1263)playerInventory, y * 9 + x + 9, playerInvLeft + 18 * x, playerInvTop + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.field_2797).addClientSlot(new class_1735((class_1263)playerInventory, x, playerInvLeft + 18 * x, playerInvTop + 58));
        }
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        int outsideRegion;
        if (this.inventoryWidth > 9 && mouseY >= (double)(top + 17 + this.inventoryHeight * 18 + 17) && (mouseX < (double)(left + (outsideRegion = (this.field_2792 - 176) / 2)) || mouseX > (double)(left + this.field_2792 - outsideRegion))) {
            return true;
        }
        return super.method_2381(mouseX, mouseY, left, top, button);
    }

    private void setPage(int oldPage, int newPage) {
        if (newPage == 0 || newPage > this.pages) {
            return;
        }
        this.page = newPage;
        if (newPage > oldPage) {
            if (this.page == this.pages) {
                this.rightPageButton.setActive(false);
            }
            if (!this.leftPageButton.field_22763) {
                this.leftPageButton.setActive(true);
            }
        } else if (newPage < oldPage) {
            if (this.page == 1) {
                this.leftPageButton.setActive(false);
            }
            if (!this.rightPageButton.field_22763) {
                this.rightPageButton.setActive(true);
            }
        }
        int slotsPerPage = this.inventoryWidth * this.inventoryHeight;
        int oldMin = slotsPerPage * (oldPage - 1);
        int oldMax = Math.min(oldMin + slotsPerPage, this.totalSlots);
        ((AbstractHandler)this.field_2797).moveSlotRange(oldMin, oldMax, -2000);
        int newMin = slotsPerPage * (newPage - 1);
        int newMax = Math.min(newMin + slotsPerPage, this.totalSlots);
        ((AbstractHandler)this.field_2797).moveSlotRange(newMin, newMax, 2000);
        this.setPageText();
    }

    private void setPageText() {
        this.currentPageText = class_2561.method_43469((String)"screen.ellemes_container_lib.page_x_y", (Object[])new Object[]{this.page, this.pages});
        this.pageTextX = (float)(this.leftPageButton.method_46426() + this.leftPageButton.method_25368() + this.rightPageButton.method_46426()) / 2.0f - (float)this.field_22793.method_27525((class_5348)this.currentPageText) / 2.0f + 0.5f;
    }

    private void recalculateBlankArea() {
        if (this.blankSlots > 0) {
            this.blankArea.clear();
            int rows = Math.floorDiv(this.blankSlots, this.inventoryWidth);
            int remainder = this.blankSlots - this.inventoryWidth * rows;
            int yTop = this.field_2800 + 17 + (this.inventoryHeight - 1) * 18;
            int xLeft = this.field_2776 + 7;
            for (int i = 0; i < rows; ++i) {
                this.blankArea.add(new TexturedRect(this.textureLocation, xLeft, yTop, this.inventoryWidth * 18, 18, 7, this.field_2779, this.textureWidth, this.textureHeight));
                yTop -= 18;
            }
            if (remainder > 0) {
                int xRight = this.field_2776 + 7 + this.inventoryWidth * 18;
                int width = remainder * 18;
                this.blankArea.add(new TexturedRect(this.textureLocation, xRight - width, yTop, width, 18, 7, this.field_2779, this.textureWidth, this.textureHeight));
            }
        }
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51439(this.field_22793, this.field_22785, 8, 6, 0x404040, false);
        graphics.method_51439(this.field_22793, this.field_29347, 8, this.field_2779 - 96 + 2, 0x404040, false);
        if (this.currentPageText != null) {
            graphics.method_51430(this.field_22793, this.currentPageText.method_30937(), (int)(this.pageTextX - (float)this.field_2776), this.field_2779 - 94, 0x404040, false);
        }
    }

    @Override
    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 262 || keyCode == 267) {
            this.setPage(this.page, PageScreen.method_25442() ? this.pages : this.page + 1);
            return true;
        }
        if (keyCode == 263 || keyCode == 266) {
            this.setPage(this.page, PageScreen.method_25442() ? 1 : this.page - 1);
            return true;
        }
        return false;
    }

    public void addPageButtons() {
        int x;
        int width = 54;
        int originalX = x = this.field_2776 + this.field_2792 - 61;
        int y = this.field_2800 + this.field_2779 - 96;
        ArrayList<class_339> renderableChildren = new ArrayList<class_339>();
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof class_339)) continue;
            class_339 widget = (class_339)child;
            renderableChildren.add(widget);
        }
        renderableChildren.sort(Comparator.comparingInt(a -> -a.method_46426()));
        for (class_339 widget : renderableChildren) {
            if (!PageScreen.regionIntersects(widget, x, y, width, 12)) continue;
            x = widget.method_46426() - width - 2;
        }
        if (x == originalX && CommonClient.platformHelper().isModLoaded("inventoryprofiles")) {
            x -= 14;
        }
        this.leftPageButton = new PageButton(x, y, 0, (class_2561)class_2561.method_43471((String)"screen.ellemes_container_lib.prev_page"), button -> this.setPage(this.page, this.page - 1));
        this.leftPageButton.field_22763 = this.page != 1;
        this.method_37063((class_364)this.leftPageButton);
        this.rightPageButton = new PageButton(x + 42, y, 1, (class_2561)class_2561.method_43471((String)"screen.ellemes_container_lib.next_page"), button -> this.setPage(this.page, this.page + 1));
        this.rightPageButton.field_22763 = this.page != this.pages;
        this.method_37063((class_364)this.rightPageButton);
        this.setPageText();
    }
}

