/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.common.datagen.providers;

import com.google.gson.JsonElement;
import compasses.expandedstorage.common.block.AbstractChestBlock;
import compasses.expandedstorage.common.block.BarrelBlock;
import compasses.expandedstorage.common.block.ChestBlock;
import compasses.expandedstorage.common.block.CopperBarrelBlock;
import compasses.expandedstorage.common.block.MiniStorageBlock;
import compasses.expandedstorage.common.datagen.content.ModEntityTypes;
import compasses.expandedstorage.common.datagen.content.ModTags;
import compasses.expandedstorage.common.entity.ChestMinecart;
import compasses.expandedstorage.common.misc.Utils;
import compasses.expandedstorage.common.recipe.BlockConversionRecipe;
import compasses.expandedstorage.common.recipe.ConversionRecipe;
import compasses.expandedstorage.common.recipe.EntityConversionRecipe;
import compasses.expandedstorage.common.recipe.conditions.AndCondition;
import compasses.expandedstorage.common.recipe.conditions.HasPropertyCondition;
import compasses.expandedstorage.common.recipe.conditions.IsInTagCondition;
import compasses.expandedstorage.common.recipe.conditions.IsRegistryObject;
import compasses.expandedstorage.common.recipe.conditions.RecipeCondition;
import compasses.expandedstorage.common.recipe.misc.PartialBlockState;
import compasses.expandedstorage.common.recipe.misc.RecipeTool;
import compasses.expandedstorage.common.registration.ModBlocks;
import compasses.expandedstorage.common.registration.ModItems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public abstract class ConversionRecipeProvider
implements class_2405 {
    protected static final RecipeTool UNNAMED_MUTATOR = new RecipeTool.MutatorTool(null);
    protected static final RecipeTool SPARROW_MUTATOR = new RecipeTool.MutatorTool("sparrow");
    protected static final RecipeTool WOOD_TO_COPPER_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.WOOD_TO_COPPER_CONVERSION_KIT);
    protected static final RecipeTool WOOD_TO_IRON_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.WOOD_TO_IRON_CONVERSION_KIT);
    protected static final RecipeTool WOOD_TO_GOLD_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.WOOD_TO_GOLD_CONVERSION_KIT);
    protected static final RecipeTool WOOD_TO_DIAMOND_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.WOOD_TO_DIAMOND_CONVERSION_KIT);
    protected static final RecipeTool WOOD_TO_OBSIDIAN_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.WOOD_TO_OBSIDIAN_CONVERSION_KIT);
    protected static final RecipeTool WOOD_TO_NETHERITE_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.WOOD_TO_NETHERITE_CONVERSION_KIT);
    protected static final RecipeTool COPPER_TO_IRON_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.COPPER_TO_IRON_CONVERSION_KIT);
    protected static final RecipeTool COPPER_TO_GOLD_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.COPPER_TO_GOLD_CONVERSION_KIT);
    protected static final RecipeTool COPPER_TO_DIAMOND_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.COPPER_TO_DIAMOND_CONVERSION_KIT);
    protected static final RecipeTool COPPER_TO_OBSIDIAN_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.COPPER_TO_OBSIDIAN_CONVERSION_KIT);
    protected static final RecipeTool COPPER_TO_NETHERITE_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.COPPER_TO_NETHERITE_CONVERSION_KIT);
    protected static final RecipeTool IRON_TO_GOLD_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.IRON_TO_GOLD_CONVERSION_KIT);
    protected static final RecipeTool IRON_TO_DIAMOND_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.IRON_TO_DIAMOND_CONVERSION_KIT);
    protected static final RecipeTool IRON_TO_OBSIDIAN_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.IRON_TO_OBSIDIAN_CONVERSION_KIT);
    protected static final RecipeTool IRON_TO_NETHERITE_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.IRON_TO_NETHERITE_CONVERSION_KIT);
    protected static final RecipeTool GOLD_TO_DIAMOND_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.GOLD_TO_DIAMOND_CONVERSION_KIT);
    protected static final RecipeTool GOLD_TO_OBSIDIAN_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.GOLD_TO_OBSIDIAN_CONVERSION_KIT);
    protected static final RecipeTool GOLD_TO_NETHERITE_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.GOLD_TO_NETHERITE_CONVERSION_KIT);
    protected static final RecipeTool DIAMOND_TO_OBSIDIAN_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.DIAMOND_TO_OBSIDIAN_CONVERSION_KIT);
    protected static final RecipeTool DIAMOND_TO_NETHERITE_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.DIAMOND_TO_NETHERITE_CONVERSION_KIT);
    protected static final RecipeTool OBSIDIAN_TO_NETHERITE_CONVERSION_KIT = new RecipeTool.UpgradeTool(ModItems.OBSIDIAN_TO_NETHERITE_CONVERSION_KIT);
    protected final class_7784.class_7489 pathProvider;
    private final HashMap<class_2960, BlockConversionRecipe<?>> blockRecipes = new HashMap();
    private final HashMap<class_2960, EntityConversionRecipe<?>> entityRecipes = new HashMap();

    public ConversionRecipeProvider(class_7784 output) {
        this.pathProvider = output.method_45973(class_7784.class_7490.field_39367, "conversion_recipes");
        this.pathProvider.method_44107(new class_2960("expandedstorage", "block/wood_to_copper_chest"));
    }

    protected void registerBlockRecipe(class_2960 id, BlockConversionRecipe<?> recipe) {
        class_2960 realId = new class_2960(id.method_12836(), "block/" + id.method_12832());
        if (this.blockRecipes.containsKey(realId)) {
            throw new IllegalStateException("Tried registering duplicate block recipe with id: " + realId);
        }
        this.blockRecipes.put(realId, recipe);
    }

    protected void registerEntityRecipe(class_2960 id, EntityConversionRecipe<?> recipe) {
        class_2960 realId = new class_2960(id.method_12836(), "entity/" + id.method_12832());
        if (this.entityRecipes.containsKey(realId)) {
            throw new IllegalStateException("Tried registering duplicate entity recipe with id: " + realId);
        }
        this.entityRecipes.put(realId, recipe);
    }

    protected void simpleBlockThemeSwap(class_2960 id, class_2248 from, class_2248 to) {
        this.registerBlockRecipe(id, new BlockConversionRecipe<class_2248>(UNNAMED_MUTATOR, new PartialBlockState<class_2248>(to), new IsRegistryObject((class_2378<?>)class_7923.field_41175, from.method_40142().method_40237().method_29177())));
    }

    protected void sparrowBlockThemeSwap(class_2960 id, class_2248 from, boolean fromSparrow, class_2248 to, boolean toSparrow) {
        class_2960 fromId = from.method_40142().method_40237().method_29177();
        this.registerBlockRecipe(id, new BlockConversionRecipe<class_2248>(SPARROW_MUTATOR, new PartialBlockState<class_2248>(to, Map.of(MiniStorageBlock.SPARROW, toSparrow)), new AndCondition(new IsRegistryObject((class_2378<?>)class_7923.field_41175, fromId), new HasPropertyCondition(fromId, Map.of(MiniStorageBlock.SPARROW, fromSparrow), false))));
    }

    protected void sparrowReversibleBlockThemeSwap(String blockName, class_2248 block) {
        class_2960 blockId = block.method_40142().method_40237().method_29177();
        this.registerBlockRecipe(Utils.id("%s_to_with_sparrow".formatted(blockName)), new BlockConversionRecipe<class_2248>(SPARROW_MUTATOR, new PartialBlockState<class_2248>(block, Map.of(MiniStorageBlock.SPARROW, true)), new AndCondition(new IsRegistryObject((class_2378<?>)class_7923.field_41175, blockId), new HasPropertyCondition(blockId, Map.of(MiniStorageBlock.SPARROW, false), false))));
        this.registerBlockRecipe(Utils.id("%s_to_without_sparrow".formatted(blockName)), new BlockConversionRecipe<class_2248>(UNNAMED_MUTATOR, new PartialBlockState<class_2248>(block, Map.of(MiniStorageBlock.SPARROW, false)), new AndCondition(new IsRegistryObject((class_2378<?>)class_7923.field_41175, blockId), new HasPropertyCondition(blockId, Map.of(MiniStorageBlock.SPARROW, true), false))));
    }

    protected void simpleEntityThemeSwap(class_2960 id, class_1299<?> from, class_1299<?> to) {
        this.registerEntityRecipe(id, new EntityConversionRecipe(UNNAMED_MUTATOR, to, new IsRegistryObject((class_2378<?>)class_7923.field_41177, from.method_40124().method_40237().method_29177())));
    }

    public CompletableFuture<?> method_10319(class_7403 cachedOutput) {
        this.blockRecipes.clear();
        this.entityRecipes.clear();
        this.registerBlockRecipes();
        this.registerEntityRecipes();
        return CompletableFuture.allOf((CompletableFuture[])Stream.concat(this.blockRecipes.entrySet().stream(), this.entityRecipes.entrySet().stream()).map(entry -> {
            JsonElement json = ((ConversionRecipe)entry.getValue()).toJson();
            Path path = this.pathProvider.method_44107((class_2960)entry.getKey());
            return class_2405.method_10320((class_7403)cachedOutput, (JsonElement)json, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    protected abstract void registerBlockRecipes();

    protected void registerBlockRecipes(RecipeCondition isWoodBarrel, RecipeCondition isWoodChest) {
        RecipeCondition isWoodTier = new IsInTagCondition(ModTags.Blocks.ES_WOODEN_CHESTS);
        IsRegistryObject isIronTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.IRON_CHEST.getBlockId());
        IsRegistryObject isGoldTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.GOLD_CHEST.getBlockId());
        IsRegistryObject isDiamondTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.DIAMOND_CHEST.getBlockId());
        IsRegistryObject isObsidianTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.OBSIDIAN_CHEST.getBlockId());
        PartialBlockState<AbstractChestBlock> ironChest = new PartialBlockState<ChestBlock>(ModBlocks.IRON_CHEST);
        PartialBlockState<AbstractChestBlock> goldChest = new PartialBlockState<ChestBlock>(ModBlocks.GOLD_CHEST);
        PartialBlockState<AbstractChestBlock> diamondChest = new PartialBlockState<ChestBlock>(ModBlocks.DIAMOND_CHEST);
        PartialBlockState<AbstractChestBlock> obsidianChest = new PartialBlockState<ChestBlock>(ModBlocks.OBSIDIAN_CHEST);
        PartialBlockState<AbstractChestBlock> netheriteChest = new PartialBlockState<ChestBlock>(ModBlocks.NETHERITE_CHEST);
        this.registerBlockRecipe(Utils.id("wood_to_iron_chest"), new BlockConversionRecipe<ChestBlock>(WOOD_TO_IRON_CONVERSION_KIT, ironChest, isWoodTier));
        this.registerBlockRecipe(Utils.id("wood_to_gold_chest"), new BlockConversionRecipe<ChestBlock>(WOOD_TO_GOLD_CONVERSION_KIT, goldChest, isWoodTier));
        this.registerBlockRecipe(Utils.id("wood_to_diamond_chest"), new BlockConversionRecipe<ChestBlock>(WOOD_TO_DIAMOND_CONVERSION_KIT, diamondChest, isWoodTier));
        this.registerBlockRecipe(Utils.id("wood_to_obsidian_chest"), new BlockConversionRecipe<ChestBlock>(WOOD_TO_OBSIDIAN_CONVERSION_KIT, obsidianChest, isWoodTier));
        this.registerBlockRecipe(Utils.id("wood_to_netherite_chest"), new BlockConversionRecipe<ChestBlock>(WOOD_TO_NETHERITE_CONVERSION_KIT, netheriteChest, isWoodTier));
        this.registerBlockRecipe(Utils.id("iron_to_gold_chest"), new BlockConversionRecipe<ChestBlock>(IRON_TO_GOLD_CONVERSION_KIT, goldChest, isIronTier));
        this.registerBlockRecipe(Utils.id("iron_to_diamond_chest"), new BlockConversionRecipe<ChestBlock>(IRON_TO_DIAMOND_CONVERSION_KIT, diamondChest, isIronTier));
        this.registerBlockRecipe(Utils.id("iron_to_obsidian_chest"), new BlockConversionRecipe<ChestBlock>(IRON_TO_OBSIDIAN_CONVERSION_KIT, obsidianChest, isIronTier));
        this.registerBlockRecipe(Utils.id("iron_to_netherite_chest"), new BlockConversionRecipe<ChestBlock>(IRON_TO_NETHERITE_CONVERSION_KIT, netheriteChest, isIronTier));
        this.registerBlockRecipe(Utils.id("gold_to_diamond_chest"), new BlockConversionRecipe<ChestBlock>(GOLD_TO_DIAMOND_CONVERSION_KIT, diamondChest, isGoldTier));
        this.registerBlockRecipe(Utils.id("gold_to_obsidian_chest"), new BlockConversionRecipe<ChestBlock>(GOLD_TO_OBSIDIAN_CONVERSION_KIT, obsidianChest, isGoldTier));
        this.registerBlockRecipe(Utils.id("gold_to_netherite_chest"), new BlockConversionRecipe<ChestBlock>(GOLD_TO_NETHERITE_CONVERSION_KIT, netheriteChest, isGoldTier));
        this.registerBlockRecipe(Utils.id("diamond_to_obsidian_chest"), new BlockConversionRecipe<ChestBlock>(DIAMOND_TO_OBSIDIAN_CONVERSION_KIT, obsidianChest, isDiamondTier));
        this.registerBlockRecipe(Utils.id("diamond_to_netherite_chest"), new BlockConversionRecipe<ChestBlock>(DIAMOND_TO_NETHERITE_CONVERSION_KIT, netheriteChest, isDiamondTier));
        this.registerBlockRecipe(Utils.id("obsidian_to_netherite_chest"), new BlockConversionRecipe<ChestBlock>(OBSIDIAN_TO_NETHERITE_CONVERSION_KIT, netheriteChest, isObsidianTier));
        isWoodTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.OLD_WOOD_CHEST.getBlockId());
        isIronTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.OLD_IRON_CHEST.getBlockId());
        isGoldTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.OLD_GOLD_CHEST.getBlockId());
        isDiamondTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.OLD_DIAMOND_CHEST.getBlockId());
        isObsidianTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.OLD_OBSIDIAN_CHEST.getBlockId());
        ironChest = new PartialBlockState<AbstractChestBlock>(ModBlocks.OLD_IRON_CHEST);
        goldChest = new PartialBlockState<AbstractChestBlock>(ModBlocks.OLD_GOLD_CHEST);
        diamondChest = new PartialBlockState<AbstractChestBlock>(ModBlocks.OLD_DIAMOND_CHEST);
        obsidianChest = new PartialBlockState<AbstractChestBlock>(ModBlocks.OLD_OBSIDIAN_CHEST);
        netheriteChest = new PartialBlockState<AbstractChestBlock>(ModBlocks.OLD_NETHERITE_CHEST);
        this.registerBlockRecipe(Utils.id("wood_to_iron_old_chest"), new BlockConversionRecipe<ChestBlock>(WOOD_TO_IRON_CONVERSION_KIT, ironChest, isWoodTier));
        this.registerBlockRecipe(Utils.id("wood_to_gold_old_chest"), new BlockConversionRecipe<ChestBlock>(WOOD_TO_GOLD_CONVERSION_KIT, goldChest, isWoodTier));
        this.registerBlockRecipe(Utils.id("wood_to_diamond_old_chest"), new BlockConversionRecipe<ChestBlock>(WOOD_TO_DIAMOND_CONVERSION_KIT, diamondChest, isWoodTier));
        this.registerBlockRecipe(Utils.id("wood_to_obsidian_old_chest"), new BlockConversionRecipe<ChestBlock>(WOOD_TO_OBSIDIAN_CONVERSION_KIT, obsidianChest, isWoodTier));
        this.registerBlockRecipe(Utils.id("wood_to_netherite_old_chest"), new BlockConversionRecipe<ChestBlock>(WOOD_TO_NETHERITE_CONVERSION_KIT, netheriteChest, isWoodTier));
        this.registerBlockRecipe(Utils.id("iron_to_gold_old_chest"), new BlockConversionRecipe<ChestBlock>(IRON_TO_GOLD_CONVERSION_KIT, goldChest, isIronTier));
        this.registerBlockRecipe(Utils.id("iron_to_diamond_old_chest"), new BlockConversionRecipe<ChestBlock>(IRON_TO_DIAMOND_CONVERSION_KIT, diamondChest, isIronTier));
        this.registerBlockRecipe(Utils.id("iron_to_obsidian_old_chest"), new BlockConversionRecipe<ChestBlock>(IRON_TO_OBSIDIAN_CONVERSION_KIT, obsidianChest, isIronTier));
        this.registerBlockRecipe(Utils.id("iron_to_netherite_old_chest"), new BlockConversionRecipe<ChestBlock>(IRON_TO_NETHERITE_CONVERSION_KIT, netheriteChest, isIronTier));
        this.registerBlockRecipe(Utils.id("gold_to_diamond_old_chest"), new BlockConversionRecipe<ChestBlock>(GOLD_TO_DIAMOND_CONVERSION_KIT, diamondChest, isGoldTier));
        this.registerBlockRecipe(Utils.id("gold_to_obsidian_old_chest"), new BlockConversionRecipe<ChestBlock>(GOLD_TO_OBSIDIAN_CONVERSION_KIT, obsidianChest, isGoldTier));
        this.registerBlockRecipe(Utils.id("gold_to_netherite_old_chest"), new BlockConversionRecipe<ChestBlock>(GOLD_TO_NETHERITE_CONVERSION_KIT, netheriteChest, isGoldTier));
        this.registerBlockRecipe(Utils.id("diamond_to_obsidian_old_chest"), new BlockConversionRecipe<ChestBlock>(DIAMOND_TO_OBSIDIAN_CONVERSION_KIT, obsidianChest, isDiamondTier));
        this.registerBlockRecipe(Utils.id("diamond_to_netherite_old_chest"), new BlockConversionRecipe<ChestBlock>(DIAMOND_TO_NETHERITE_CONVERSION_KIT, netheriteChest, isDiamondTier));
        this.registerBlockRecipe(Utils.id("obsidian_to_netherite_old_chest"), new BlockConversionRecipe<ChestBlock>(OBSIDIAN_TO_NETHERITE_CONVERSION_KIT, netheriteChest, isObsidianTier));
        IsInTagCondition isCopperTier = new IsInTagCondition(ModTags.Blocks.COPPER_BARRELS);
        isIronTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.IRON_BARREL.getBlockId());
        isGoldTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.GOLD_BARREL.getBlockId());
        isDiamondTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.DIAMOND_BARREL.getBlockId());
        isObsidianTier = new IsRegistryObject((class_2378<?>)class_7923.field_41175, ModBlocks.OBSIDIAN_BARREL.getBlockId());
        PartialBlockState<BarrelBlock> ironBarrel = new PartialBlockState<BarrelBlock>(ModBlocks.IRON_BARREL);
        PartialBlockState<BarrelBlock> goldBarrel = new PartialBlockState<BarrelBlock>(ModBlocks.GOLD_BARREL);
        PartialBlockState<BarrelBlock> diamondBarrel = new PartialBlockState<BarrelBlock>(ModBlocks.DIAMOND_BARREL);
        PartialBlockState<BarrelBlock> obsidianBarrel = new PartialBlockState<BarrelBlock>(ModBlocks.OBSIDIAN_BARREL);
        PartialBlockState<BarrelBlock> netheriteBarrel = new PartialBlockState<BarrelBlock>(ModBlocks.NETHERITE_BARREL);
        this.registerBlockRecipe(Utils.id("wood_to_copper_barrel"), new BlockConversionRecipe<CopperBarrelBlock>(WOOD_TO_COPPER_CONVERSION_KIT, new PartialBlockState<CopperBarrelBlock>(ModBlocks.COPPER_BARREL), isWoodBarrel));
        this.registerBlockRecipe(Utils.id("wood_to_iron_barrel"), new BlockConversionRecipe<BarrelBlock>(WOOD_TO_IRON_CONVERSION_KIT, ironBarrel, isWoodBarrel));
        this.registerBlockRecipe(Utils.id("wood_to_gold_barrel"), new BlockConversionRecipe<BarrelBlock>(WOOD_TO_GOLD_CONVERSION_KIT, goldBarrel, isWoodBarrel));
        this.registerBlockRecipe(Utils.id("wood_to_diamond_barrel"), new BlockConversionRecipe<BarrelBlock>(WOOD_TO_DIAMOND_CONVERSION_KIT, diamondBarrel, isWoodBarrel));
        this.registerBlockRecipe(Utils.id("wood_to_obsidian_barrel"), new BlockConversionRecipe<BarrelBlock>(WOOD_TO_OBSIDIAN_CONVERSION_KIT, obsidianBarrel, isWoodBarrel));
        this.registerBlockRecipe(Utils.id("wood_to_netherite_barrel"), new BlockConversionRecipe<BarrelBlock>(WOOD_TO_NETHERITE_CONVERSION_KIT, netheriteBarrel, isWoodBarrel));
        this.registerBlockRecipe(Utils.id("copper_to_iron_barrel"), new BlockConversionRecipe<BarrelBlock>(COPPER_TO_IRON_CONVERSION_KIT, ironBarrel, isCopperTier));
        this.registerBlockRecipe(Utils.id("copper_to_gold_barrel"), new BlockConversionRecipe<BarrelBlock>(COPPER_TO_GOLD_CONVERSION_KIT, goldBarrel, isCopperTier));
        this.registerBlockRecipe(Utils.id("copper_to_diamond_barrel"), new BlockConversionRecipe<BarrelBlock>(COPPER_TO_DIAMOND_CONVERSION_KIT, diamondBarrel, isCopperTier));
        this.registerBlockRecipe(Utils.id("copper_to_obsidian_barrel"), new BlockConversionRecipe<BarrelBlock>(COPPER_TO_OBSIDIAN_CONVERSION_KIT, obsidianBarrel, isCopperTier));
        this.registerBlockRecipe(Utils.id("copper_to_netherite_barrel"), new BlockConversionRecipe<BarrelBlock>(COPPER_TO_NETHERITE_CONVERSION_KIT, netheriteBarrel, isCopperTier));
        this.registerBlockRecipe(Utils.id("iron_to_gold_barrel"), new BlockConversionRecipe<BarrelBlock>(IRON_TO_GOLD_CONVERSION_KIT, goldBarrel, isIronTier));
        this.registerBlockRecipe(Utils.id("iron_to_diamond_barrel"), new BlockConversionRecipe<BarrelBlock>(IRON_TO_DIAMOND_CONVERSION_KIT, diamondBarrel, isIronTier));
        this.registerBlockRecipe(Utils.id("iron_to_obsidian_barrel"), new BlockConversionRecipe<BarrelBlock>(IRON_TO_OBSIDIAN_CONVERSION_KIT, obsidianBarrel, isIronTier));
        this.registerBlockRecipe(Utils.id("iron_to_netherite_barrel"), new BlockConversionRecipe<BarrelBlock>(IRON_TO_NETHERITE_CONVERSION_KIT, netheriteBarrel, isIronTier));
        this.registerBlockRecipe(Utils.id("gold_to_diamond_barrel"), new BlockConversionRecipe<BarrelBlock>(GOLD_TO_DIAMOND_CONVERSION_KIT, diamondBarrel, isGoldTier));
        this.registerBlockRecipe(Utils.id("gold_to_obsidian_barrel"), new BlockConversionRecipe<BarrelBlock>(GOLD_TO_OBSIDIAN_CONVERSION_KIT, obsidianBarrel, isGoldTier));
        this.registerBlockRecipe(Utils.id("gold_to_netherite_barrel"), new BlockConversionRecipe<BarrelBlock>(GOLD_TO_NETHERITE_CONVERSION_KIT, netheriteBarrel, isGoldTier));
        this.registerBlockRecipe(Utils.id("diamond_to_obsidian_barrel"), new BlockConversionRecipe<BarrelBlock>(DIAMOND_TO_OBSIDIAN_CONVERSION_KIT, obsidianBarrel, isDiamondTier));
        this.registerBlockRecipe(Utils.id("diamond_to_netherite_barrel"), new BlockConversionRecipe<BarrelBlock>(DIAMOND_TO_NETHERITE_CONVERSION_KIT, netheriteBarrel, isDiamondTier));
        this.registerBlockRecipe(Utils.id("obsidian_to_netherite_barrel"), new BlockConversionRecipe<BarrelBlock>(OBSIDIAN_TO_NETHERITE_CONVERSION_KIT, netheriteBarrel, isObsidianTier));
        this.registerBlockRecipe(Utils.id("vanilla_to_wood_chest"), new BlockConversionRecipe<ChestBlock>(UNNAMED_MUTATOR, new PartialBlockState<ChestBlock>(ModBlocks.WOOD_CHEST), isWoodChest));
        this.simpleBlockThemeSwap(Utils.id("wood_to_pumpkin_chest"), ModBlocks.WOOD_CHEST, ModBlocks.PUMPKIN_CHEST);
        this.simpleBlockThemeSwap(Utils.id("pumpkin_to_present_chest"), ModBlocks.PUMPKIN_CHEST, ModBlocks.PRESENT);
        this.simpleBlockThemeSwap(Utils.id("present_to_bamboo_chest"), ModBlocks.PRESENT, ModBlocks.BAMBOO_CHEST);
        this.simpleBlockThemeSwap(Utils.id("bamboo_to_moss_chest"), ModBlocks.BAMBOO_CHEST, ModBlocks.MOSS_CHEST);
        this.simpleBlockThemeSwap(Utils.id("moss_to_old_wood_chest"), ModBlocks.MOSS_CHEST, ModBlocks.OLD_WOOD_CHEST);
        this.simpleBlockThemeSwap(Utils.id("old_wood_chest_to_wood_chest"), ModBlocks.OLD_WOOD_CHEST, ModBlocks.WOOD_CHEST);
        this.simpleBlockThemeSwap(Utils.id("iron_to_old_iron_chest"), ModBlocks.IRON_CHEST, ModBlocks.OLD_IRON_CHEST);
        this.simpleBlockThemeSwap(Utils.id("old_iron_to_iron_chest"), ModBlocks.OLD_IRON_CHEST, ModBlocks.IRON_CHEST);
        this.simpleBlockThemeSwap(Utils.id("gold_to_old_gold_chest"), ModBlocks.GOLD_CHEST, ModBlocks.OLD_GOLD_CHEST);
        this.simpleBlockThemeSwap(Utils.id("old_gold_to_gold_chest"), ModBlocks.OLD_GOLD_CHEST, ModBlocks.GOLD_CHEST);
        this.simpleBlockThemeSwap(Utils.id("diamond_to_old_diamond_chest"), ModBlocks.DIAMOND_CHEST, ModBlocks.OLD_DIAMOND_CHEST);
        this.simpleBlockThemeSwap(Utils.id("old_diamond_to_diamond_chest"), ModBlocks.OLD_DIAMOND_CHEST, ModBlocks.DIAMOND_CHEST);
        this.simpleBlockThemeSwap(Utils.id("obsidian_to_old_obsidian_chest"), ModBlocks.OBSIDIAN_CHEST, ModBlocks.OLD_OBSIDIAN_CHEST);
        this.simpleBlockThemeSwap(Utils.id("old_obsidian_to_obsidian_chest"), ModBlocks.OLD_OBSIDIAN_CHEST, ModBlocks.OBSIDIAN_CHEST);
        this.simpleBlockThemeSwap(Utils.id("netherite_to_old_netherite_chest"), ModBlocks.NETHERITE_CHEST, ModBlocks.OLD_NETHERITE_CHEST);
        this.simpleBlockThemeSwap(Utils.id("old_netherite_to_netherite_chest"), ModBlocks.OLD_NETHERITE_CHEST, ModBlocks.NETHERITE_CHEST);
        this.simpleBlockThemeSwap(Utils.id("vanilla_to_wood_mini_chest"), ModBlocks.VANILLA_WOOD_MINI_CHEST, ModBlocks.WOOD_MINI_CHEST);
        this.simpleBlockThemeSwap(Utils.id("wood_to_pumpkin_mini_chest"), ModBlocks.WOOD_MINI_CHEST, ModBlocks.PUMPKIN_MINI_CHEST);
        this.simpleBlockThemeSwap(Utils.id("pumpkin_to_red_mini_present"), ModBlocks.PUMPKIN_MINI_CHEST, ModBlocks.RED_MINI_PRESENT);
        this.simpleBlockThemeSwap(Utils.id("red_to_white_mini_present"), ModBlocks.RED_MINI_PRESENT, ModBlocks.WHITE_MINI_PRESENT);
        this.simpleBlockThemeSwap(Utils.id("white_to_candy_cane_mini_present"), ModBlocks.WHITE_MINI_PRESENT, ModBlocks.CANDY_CANE_MINI_PRESENT);
        this.simpleBlockThemeSwap(Utils.id("candy_cane_to_green_mini_present"), ModBlocks.CANDY_CANE_MINI_PRESENT, ModBlocks.GREEN_MINI_PRESENT);
        this.simpleBlockThemeSwap(Utils.id("green_to_lavender_present"), ModBlocks.GREEN_MINI_PRESENT, ModBlocks.LAVENDER_MINI_PRESENT);
        this.simpleBlockThemeSwap(Utils.id("lavender_to_pink_amethyst_mini_present"), ModBlocks.LAVENDER_MINI_PRESENT, ModBlocks.PINK_AMETHYST_MINI_PRESENT);
        this.simpleBlockThemeSwap(Utils.id("pink_amethyst_to_vanilla_mini_chest"), ModBlocks.PINK_AMETHYST_MINI_PRESENT, ModBlocks.VANILLA_WOOD_MINI_CHEST);
        this.sparrowBlockThemeSwap(Utils.id("pink_amethyst_to_vanilla_mini_chest_with_sparrow"), ModBlocks.PINK_AMETHYST_MINI_PRESENT, false, ModBlocks.VANILLA_WOOD_MINI_CHEST, true);
        this.sparrowBlockThemeSwap(Utils.id("vanilla_to_wood_mini_chest_with_sparrow"), ModBlocks.VANILLA_WOOD_MINI_CHEST, true, ModBlocks.WOOD_MINI_CHEST, true);
        this.sparrowBlockThemeSwap(Utils.id("wood_to_pumpkin_mini_chest_with_sparrow"), ModBlocks.WOOD_MINI_CHEST, true, ModBlocks.PUMPKIN_MINI_CHEST, true);
        this.sparrowBlockThemeSwap(Utils.id("pumpkin_to_red_mini_present_with_sparrow"), ModBlocks.PUMPKIN_MINI_CHEST, true, ModBlocks.RED_MINI_PRESENT, true);
        this.sparrowBlockThemeSwap(Utils.id("red_to_white_mini_present_with_sparrow"), ModBlocks.RED_MINI_PRESENT, true, ModBlocks.WHITE_MINI_PRESENT, true);
        this.sparrowBlockThemeSwap(Utils.id("white_to_candy_cane_mini_present_with_sparrow"), ModBlocks.WHITE_MINI_PRESENT, true, ModBlocks.CANDY_CANE_MINI_PRESENT, true);
        this.sparrowBlockThemeSwap(Utils.id("candy_cane_to_green_mini_present_with_sparrow"), ModBlocks.CANDY_CANE_MINI_PRESENT, true, ModBlocks.GREEN_MINI_PRESENT, true);
        this.sparrowBlockThemeSwap(Utils.id("green_to_lavender_present_with_sparrow"), ModBlocks.GREEN_MINI_PRESENT, true, ModBlocks.LAVENDER_MINI_PRESENT, true);
        this.sparrowBlockThemeSwap(Utils.id("lavender_to_pink_amethyst_mini_present_with_sparrow"), ModBlocks.LAVENDER_MINI_PRESENT, true, ModBlocks.PINK_AMETHYST_MINI_PRESENT, true);
        this.sparrowBlockThemeSwap(Utils.id("pink_amethyst_with_sparrow_to_vanilla_mini_chest"), ModBlocks.PINK_AMETHYST_MINI_PRESENT, true, ModBlocks.VANILLA_WOOD_MINI_CHEST, false);
        this.sparrowReversibleBlockThemeSwap("iron_mini_chest", ModBlocks.IRON_MINI_CHEST);
        this.sparrowReversibleBlockThemeSwap("gold_mini_chest", ModBlocks.GOLD_MINI_CHEST);
        this.sparrowReversibleBlockThemeSwap("diamond_mini_chest", ModBlocks.DIAMOND_MINI_CHEST);
        this.sparrowReversibleBlockThemeSwap("obsidian_mini_chest", ModBlocks.OBSIDIAN_MINI_CHEST);
        this.sparrowReversibleBlockThemeSwap("netherite_mini_chest", ModBlocks.NETHERITE_MINI_CHEST);
        this.sparrowReversibleBlockThemeSwap("copper_mini_barrel", ModBlocks.COPPER_MINI_BARREL);
        this.sparrowReversibleBlockThemeSwap("exposed_copper_mini_barrel", ModBlocks.EXPOSED_COPPER_MINI_BARREL);
        this.sparrowReversibleBlockThemeSwap("weathered_copper_mini_barrel", ModBlocks.WEATHERED_COPPER_MINI_BARREL);
        this.sparrowReversibleBlockThemeSwap("oxidized_copper_mini_barrel", ModBlocks.OXIDIZED_COPPER_MINI_BARREL);
        this.sparrowReversibleBlockThemeSwap("waxed_copper_mini_barrel", ModBlocks.WAXED_COPPER_MINI_BARREL);
        this.sparrowReversibleBlockThemeSwap("waxed_exposed_copper_mini_barrel", ModBlocks.WAXED_EXPOSED_COPPER_MINI_BARREL);
        this.sparrowReversibleBlockThemeSwap("waxed_weathered_copper_mini_barrel", ModBlocks.WAXED_WEATHERED_COPPER_MINI_BARREL);
        this.sparrowReversibleBlockThemeSwap("waxed_oxidized_copper_mini_barrel", ModBlocks.WAXED_OXIDIZED_COPPER_MINI_BARREL);
        this.sparrowReversibleBlockThemeSwap("iron_mini_barrel", ModBlocks.IRON_MINI_BARREL);
        this.sparrowReversibleBlockThemeSwap("gold_mini_barrel", ModBlocks.GOLD_MINI_BARREL);
        this.sparrowReversibleBlockThemeSwap("diamond_mini_barrel", ModBlocks.DIAMOND_MINI_BARREL);
        this.sparrowReversibleBlockThemeSwap("obsidian_mini_barrel", ModBlocks.OBSIDIAN_MINI_BARREL);
        this.sparrowReversibleBlockThemeSwap("netherite_mini_barrel", ModBlocks.NETHERITE_MINI_BARREL);
    }

    protected abstract void registerEntityRecipes();

    protected void registerEntityRecipes(RecipeCondition isWoodenMinecart) {
        IsInTagCondition isWoodTier = new IsInTagCondition(ModTags.Entities.ES_WOODEN_CHEST_MINECARTS);
        IsRegistryObject isIronTier = new IsRegistryObject((class_2378<?>)class_7923.field_41177, ModEntityTypes.IRON_CHEST_MINECART.method_40124().method_40237().method_29177());
        IsRegistryObject isGoldTier = new IsRegistryObject((class_2378<?>)class_7923.field_41177, ModEntityTypes.GOLD_CHEST_MINECART.method_40124().method_40237().method_29177());
        IsRegistryObject isDiamondTier = new IsRegistryObject((class_2378<?>)class_7923.field_41177, ModEntityTypes.DIAMOND_CHEST_MINECART.method_40124().method_40237().method_29177());
        IsRegistryObject isObsidianTier = new IsRegistryObject((class_2378<?>)class_7923.field_41177, ModEntityTypes.OBSIDIAN_CHEST_MINECART.method_40124().method_40237().method_29177());
        this.registerEntityRecipe(Utils.id("wood_to_iron_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(WOOD_TO_IRON_CONVERSION_KIT, ModEntityTypes.IRON_CHEST_MINECART, isWoodTier));
        this.registerEntityRecipe(Utils.id("wood_to_gold_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(WOOD_TO_GOLD_CONVERSION_KIT, ModEntityTypes.GOLD_CHEST_MINECART, isWoodTier));
        this.registerEntityRecipe(Utils.id("wood_to_diamond_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(WOOD_TO_DIAMOND_CONVERSION_KIT, ModEntityTypes.DIAMOND_CHEST_MINECART, isWoodTier));
        this.registerEntityRecipe(Utils.id("wood_to_obsidian_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(WOOD_TO_OBSIDIAN_CONVERSION_KIT, ModEntityTypes.OBSIDIAN_CHEST_MINECART, isWoodTier));
        this.registerEntityRecipe(Utils.id("wood_to_netherite_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(WOOD_TO_NETHERITE_CONVERSION_KIT, ModEntityTypes.NETHERITE_CHEST_MINECART, isWoodTier));
        this.registerEntityRecipe(Utils.id("iron_to_gold_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(IRON_TO_GOLD_CONVERSION_KIT, ModEntityTypes.GOLD_CHEST_MINECART, isIronTier));
        this.registerEntityRecipe(Utils.id("iron_to_diamond_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(IRON_TO_DIAMOND_CONVERSION_KIT, ModEntityTypes.DIAMOND_CHEST_MINECART, isIronTier));
        this.registerEntityRecipe(Utils.id("iron_to_obsidian_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(IRON_TO_OBSIDIAN_CONVERSION_KIT, ModEntityTypes.OBSIDIAN_CHEST_MINECART, isIronTier));
        this.registerEntityRecipe(Utils.id("iron_to_netherite_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(IRON_TO_NETHERITE_CONVERSION_KIT, ModEntityTypes.NETHERITE_CHEST_MINECART, isIronTier));
        this.registerEntityRecipe(Utils.id("gold_to_diamond_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(GOLD_TO_DIAMOND_CONVERSION_KIT, ModEntityTypes.DIAMOND_CHEST_MINECART, isGoldTier));
        this.registerEntityRecipe(Utils.id("gold_to_obsidian_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(GOLD_TO_OBSIDIAN_CONVERSION_KIT, ModEntityTypes.OBSIDIAN_CHEST_MINECART, isGoldTier));
        this.registerEntityRecipe(Utils.id("gold_to_netherite_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(GOLD_TO_NETHERITE_CONVERSION_KIT, ModEntityTypes.NETHERITE_CHEST_MINECART, isGoldTier));
        this.registerEntityRecipe(Utils.id("diamond_to_obsidian_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(DIAMOND_TO_OBSIDIAN_CONVERSION_KIT, ModEntityTypes.OBSIDIAN_CHEST_MINECART, isDiamondTier));
        this.registerEntityRecipe(Utils.id("diamond_to_netherite_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(DIAMOND_TO_NETHERITE_CONVERSION_KIT, ModEntityTypes.NETHERITE_CHEST_MINECART, isDiamondTier));
        this.registerEntityRecipe(Utils.id("obsidian_to_netherite_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(OBSIDIAN_TO_NETHERITE_CONVERSION_KIT, ModEntityTypes.NETHERITE_CHEST_MINECART, isObsidianTier));
        this.registerEntityRecipe(Utils.id("vanilla_to_wood_chest_minecart"), new EntityConversionRecipe<ChestMinecart>(UNNAMED_MUTATOR, ModEntityTypes.WOOD_CHEST_MINECART, isWoodenMinecart));
        this.simpleEntityThemeSwap(Utils.id("wood_to_pumpkin_chest_minecart"), ModEntityTypes.WOOD_CHEST_MINECART, ModEntityTypes.PUMPKIN_CHEST_MINECART);
        this.simpleEntityThemeSwap(Utils.id("pumpkin_to_present_chest_minecart"), ModEntityTypes.PUMPKIN_CHEST_MINECART, ModEntityTypes.PRESENT_MINECART);
        this.simpleEntityThemeSwap(Utils.id("present_to_bamboo_chest_minecart"), ModEntityTypes.PRESENT_MINECART, ModEntityTypes.BAMBOO_CHEST_MINECART);
        this.simpleEntityThemeSwap(Utils.id("bamboo_to_moss_chest_minecart"), ModEntityTypes.BAMBOO_CHEST_MINECART, ModEntityTypes.MOSS_CHEST_MINECART);
        this.simpleEntityThemeSwap(Utils.id("moss_to_wood_chest_minecart"), ModEntityTypes.MOSS_CHEST_MINECART, ModEntityTypes.WOOD_CHEST_MINECART);
    }

    @NotNull
    public String method_10321() {
        return "Expanded Storage - Conversion Recipes";
    }
}

