/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.common.inventory.handler;

import compasses.expandedstorage.common.CommonMain;
import compasses.expandedstorage.common.inventory.handler.ToggleableSlot;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public final class AbstractHandler
extends class_1703 {
    private final class_1263 inventory;
    private final class_2960 forcedScreenType;

    public AbstractHandler(int syncId, class_1263 inventory, class_1661 playerInventory, class_2960 forcedScreenType) {
        super(CommonMain.platformHelper().getScreenHandlerType(), syncId);
        this.inventory = inventory;
        this.forcedScreenType = forcedScreenType;
        inventory.method_5435(playerInventory.field_7546);
        if (playerInventory.field_7546 instanceof class_3222) {
            int i;
            for (i = 0; i < inventory.method_5439(); ++i) {
                this.method_7621(new class_1735(inventory, i, i * 18, 0));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.method_7621(new class_1735((class_1263)playerInventory, y * 9 + x + 9, 18 * x, y * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                this.method_7621(new class_1735((class_1263)playerInventory, i, i * 18, 36));
            }
        }
    }

    public static AbstractHandler createClientMenu(int syncId, class_1661 playerInventory, class_2540 buffer) {
        int inventorySize = buffer.readInt();
        class_2960 forcedScreenType = null;
        if (buffer.readableBytes() > 0) {
            forcedScreenType = buffer.method_10810();
        }
        return new AbstractHandler(syncId, (class_1263)new class_1277(inventorySize), playerInventory, forcedScreenType);
    }

    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.inventory.method_5432(player);
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    @NotNull
    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 originalStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 newStack = slot.method_7677();
            originalStack = newStack.method_7972();
            if (index < this.inventory.method_5439() ? !this.method_7616(newStack, this.inventory.method_5439(), this.inventory.method_5439() + 36, true) : !this.method_7616(newStack, 0, this.inventory.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (newStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return originalStack;
    }

    public void resetSlotPositions(boolean createSlots, int menuWidth, int menuHeight) {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            int realYPos;
            int slotXPos = i % menuWidth;
            int slotYPos = class_3532.method_15384((double)((double)(i - slotXPos) / (double)menuWidth));
            int n = realYPos = slotYPos >= menuHeight ? 18 * (slotYPos % menuHeight) - 2000 : slotYPos * 18;
            if (createSlots) {
                this.method_7621(new ToggleableSlot(this.inventory, i, slotXPos * 18 + 8, realYPos + 18, slotYPos < menuHeight));
                continue;
            }
            ((class_1735)this.field_7761.get((int)i)).field_7872 = realYPos + 18;
        }
    }

    public void moveSlotRange(int minSlotIndex, int maxSlotIndex, int yDifference) {
        for (int i = minSlotIndex; i < maxSlotIndex; ++i) {
            ToggleableSlot slot = (ToggleableSlot)((Object)this.field_7761.get(i));
            slot.field_7872 += yDifference;
            if (yDifference != -2000 && yDifference != 2000) continue;
            slot.toggleActive();
        }
    }

    public void setSlotRange(int minSlotIndex, int maxSlotIndex, IntUnaryOperator yMutator) {
        for (int i = minSlotIndex; i < maxSlotIndex; ++i) {
            ToggleableSlot slot = (ToggleableSlot)((Object)this.field_7761.get(i));
            int newY = yMutator.applyAsInt(i);
            if (newY - slot.field_7872 > 1000 || slot.field_7872 - newY > 1000) {
                ((ToggleableSlot)((Object)this.field_7761.get(i))).toggleActive();
            }
            slot.field_7872 = newY;
        }
    }

    public void clearSlots() {
        this.field_7761.clear();
        this.field_29206.clear();
        this.field_7764.clear();
    }

    public void addClientSlot(class_1735 slot) {
        this.method_7621(slot);
    }

    public class_2960 getForcedScreenType() {
        return this.forcedScreenType;
    }
}

