/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.common.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import compasses.expandedstorage.common.recipe.BlockConversionRecipe;
import compasses.expandedstorage.common.recipe.ConversionRecipeManager;
import compasses.expandedstorage.common.recipe.EntityConversionRecipe;
import compasses.expandedstorage.common.recipe.conditions.RecipeCondition;
import compasses.expandedstorage.common.recipe.misc.JsonHelper;
import compasses.expandedstorage.common.recipe.misc.PartialBlockState;
import compasses.expandedstorage.common.recipe.misc.RecipeTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionRecipeReloadListener
extends class_4309 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"expanded-storage");
    private final List<BlockConversionRecipe<?>> blockRecipes = new ArrayList();
    private final List<EntityConversionRecipe<?>> entityRecipes = new ArrayList();
    private static final Gson GSON = new GsonBuilder().create();

    public ConversionRecipeReloadListener() {
        super(GSON, "conversion_recipes");
    }

    protected void apply(Map<class_2960, JsonElement> recipes, class_3300 resourceManager, class_3695 profilerFiller) {
        recipes.forEach((name, json) -> {
            try {
                this.parseRecipe((JsonElement)json);
            }
            catch (Exception e) {
                LOGGER.error("Invalid conversion recipe " + name, (Throwable)e);
            }
        });
        ConversionRecipeManager.INSTANCE.replaceAllRecipes(this.blockRecipes, this.entityRecipes);
        this.blockRecipes.clear();
        this.entityRecipes.clear();
    }

    private void parseRecipe(JsonElement json) throws JsonSyntaxException {
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("root must be a json object");
        }
        JsonObject root = json.getAsJsonObject();
        class_2960 type = JsonHelper.getJsonResourceLocation(root, "type");
        RecipeTool recipeTool = RecipeTool.fromJsonObject(JsonHelper.getJsonObject(root, "tool"));
        if (type.toString().equals("expandedstorage:block_conversion")) {
            this.parseBlockRecipe(root, recipeTool);
        } else if (type.toString().equals("expandedstorage:entity_conversion")) {
            this.parseEntityRecipe(root, recipeTool);
        } else {
            throw new JsonSyntaxException("type must be either: \"expandedstorage:block_conversion\" or \"expandedstorage:entity_conversion\"");
        }
    }

    private void parseBlockRecipe(JsonObject root, RecipeTool recipeTool) {
        PartialBlockState<?> output = PartialBlockState.readFromJson(JsonHelper.getJsonObject(root, "result"));
        if (output == null) {
            return;
        }
        JsonHelper.checkHasEntry(root, "inputs");
        this.blockRecipes.add(new BlockConversionRecipe(recipeTool, output, RecipeCondition.readBlockCondition(root.get("inputs"))));
    }

    private void parseEntityRecipe(JsonObject root, RecipeTool recipeTool) {
        class_2960 resultId = JsonHelper.getJsonResourceLocation(root, "result");
        if (resultId.toString().equals("minecraft:air")) {
            return;
        }
        class_1299 output = (class_1299)class_7923.field_41177.method_17966(resultId).orElseThrow();
        JsonHelper.checkHasEntry(root, "inputs");
        this.entityRecipes.add(new EntityConversionRecipe(recipeTool, output, RecipeCondition.readEntityCondition(root.get("inputs"))));
    }
}

