/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import compasses.expandedstorage.common.entity.ChestMinecart;
import compasses.expandedstorage.common.recipe.ConversionRecipe;
import compasses.expandedstorage.common.recipe.conditions.RecipeCondition;
import compasses.expandedstorage.common.recipe.misc.RecipeTool;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1693;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3829;
import net.minecraft.class_7923;

public class EntityConversionRecipe<O extends class_1297>
extends ConversionRecipe<class_1297> {
    private final class_1299<O> output;

    public EntityConversionRecipe(RecipeTool recipeTool, class_1299<O> output, RecipeCondition input) {
        super(recipeTool, input);
        this.output = output;
    }

    public class_1269 process(class_1937 level, class_1657 player, class_1799 tool, class_1297 input) {
        if (tool.method_7960()) {
            return class_1269.field_5814;
        }
        if (input.method_5864() == this.output) {
            return class_1269.field_5814;
        }
        if (!EntityConversionRecipe.simulateSpawnUpgradedMinecartChest(input)) {
            return class_1269.field_5814;
        }
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_3218 serverLevel = (class_3218)level;
        ChestMinecart newCart = (ChestMinecart)this.output.method_5888(serverLevel, null, cart -> {
            boolean isMinecraftCart = input instanceof class_1693;
            class_2371<class_1799> items = isMinecraftCart ? ((class_1693)input).method_42278() : ((ChestMinecart)input).getItems();
            int inserted = cart.replaceInventoryWith(items);
            if (inserted < items.size()) {
                class_243 pos = input.method_19538();
                for (int i = inserted; i < items.size(); ++i) {
                    class_1264.method_5449((class_1937)level, (double)pos.method_10216(), (double)pos.method_10214(), (double)pos.method_10215(), (class_1799)((class_1799)items.get(i)));
                }
            }
            cart.method_33574(input.method_19538());
            cart.method_36457(input.method_36455());
            cart.method_36456(input.method_36454());
            cart.method_18799(input.method_18798());
            if (input.method_16914()) {
                cart.method_5665(input.method_5797());
            }
        }, input.method_23312(), class_3730.field_16462, true, false);
        if (newCart == null) {
            return class_1269.field_5814;
        }
        serverLevel.method_30771((class_1297)newCart);
        ((class_3829)input).method_5448();
        input.method_5650(class_1297.class_5529.field_26999);
        if (this.recipeTool instanceof RecipeTool.UpgradeTool && !player.method_7337()) {
            tool.method_7939(tool.method_7947() - 1);
        }
        return class_1269.field_21466;
    }

    private static boolean simulateSpawnUpgradedMinecartChest(class_1297 original) {
        boolean isMinecraftCart = original instanceof class_1693;
        boolean isOurCart = original instanceof ChestMinecart;
        return isOurCart || isMinecraftCart;
    }

    public void writeToBuffer(class_2540 buffer) {
        this.recipeTool.writeToBuffer(buffer);
        buffer.method_10812(class_7923.field_41177.method_10221(this.output));
        buffer.method_10812(this.input.getNetworkId());
        this.input.writeToBuffer(buffer);
    }

    public static EntityConversionRecipe<?> readFromBuffer(class_2540 buffer) {
        RecipeTool recipeTool = RecipeTool.fromNetworkBuffer(buffer);
        class_1299 output = (class_1299)class_7923.field_41177.method_10223(buffer.method_10810());
        RecipeCondition input = RecipeCondition.readFromNetworkBuffer(buffer);
        return new EntityConversionRecipe(recipeTool, output, input);
    }

    @Override
    public JsonElement toJson() {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "expandedstorage:entity_conversion");
        recipe.add("tool", (JsonElement)this.recipeTool.toJson());
        recipe.addProperty("result", this.output.method_40124().method_40237().method_29177().toString());
        recipe.add("inputs", this.input.toJson(null));
        return recipe;
    }
}

