/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.common.recipe.conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import compasses.expandedstorage.common.misc.Utils;
import compasses.expandedstorage.common.recipe.conditions.AndCondition;
import compasses.expandedstorage.common.recipe.conditions.HasPropertyCondition;
import compasses.expandedstorage.common.recipe.conditions.IsInTagCondition;
import compasses.expandedstorage.common.recipe.conditions.IsInstanceOfCondition;
import compasses.expandedstorage.common.recipe.conditions.IsRegistryObject;
import compasses.expandedstorage.common.recipe.conditions.OrCondition;
import compasses.expandedstorage.common.recipe.misc.JsonHelper;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3708;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public interface RecipeCondition {
    public static final Map<class_2960, Function<class_2540, RecipeCondition>> RECIPE_DESERIALIZERS = Map.of(AndCondition.NETWORK_ID, AndCondition::readFromBuffer, HasPropertyCondition.NETWORK_ID, HasPropertyCondition::readFromBuffer, IsInstanceOfCondition.NETWORK_ID, IsInstanceOfCondition::readFromBuffer, IsInTagCondition.NETWORK_ID, IsInTagCondition::readFromBuffer, IsRegistryObject.NETWORK_ID, IsRegistryObject::readFromBuffer, OrCondition.NETWORK_ID, OrCondition::readFromBuffer);
    public static final class_2960 IS_WOODEN_CHEST_ID = Utils.id("is_wooden_chest");
    public static final class_2960 IS_WOODEN_BARREL_ID = Utils.id("is_wooden_barrel");
    public static final IsInstanceOfCondition IS_WOODEN_CHEST = new IsInstanceOfCondition(class_2281.class);
    public static final IsInstanceOfCondition IS_WOODEN_BARREL = new IsInstanceOfCondition(class_3708.class);

    private static <T> RecipeCondition tryReadGenericCondition(JsonElement condition, class_2378<T> registry) {
        if (condition.isJsonObject()) {
            JsonObject object = condition.getAsJsonObject();
            if (object.has("tag")) {
                class_6862 tag = class_6862.method_40092((class_5321)registry.method_30517(), (class_2960)JsonHelper.getJsonResourceLocation(object, "tag"));
                return new IsInTagCondition(tag);
            }
            if (object.has("id")) {
                return new IsRegistryObject(registry, JsonHelper.getJsonResourceLocation(object, "id"));
            }
            return null;
        }
        if (condition.isJsonArray()) {
            JsonArray conditions = condition.getAsJsonArray();
            RecipeCondition[] recipeConditions = new RecipeCondition[conditions.size()];
            Function<JsonElement, RecipeCondition> function = registry == class_7923.field_41175 ? RecipeCondition::readBlockCondition : RecipeCondition::readEntityCondition;
            for (int i = 0; i < conditions.size(); ++i) {
                recipeConditions[i] = function.apply(conditions.get(i));
            }
            return new OrCondition(recipeConditions);
        }
        throw new JsonSyntaxException("condition must be an Object or an Array.");
    }

    public static RecipeCondition readBlockCondition(JsonElement condition) {
        JsonObject recipeCondition;
        RecipeCondition generic = RecipeCondition.tryReadGenericCondition(condition, class_7923.field_41175);
        if (generic != null) {
            if (generic instanceof IsInTagCondition) {
                JsonObject objCondition = (JsonObject)condition;
                if (objCondition.has("state")) {
                    throw new IllegalStateException("Cannot combine in tag and has property checks.");
                }
            } else if (generic instanceof IsRegistryObject) {
                IsRegistryObject isRegistryObject = (IsRegistryObject)generic;
                JsonObject objCondition = (JsonObject)condition;
                if (objCondition.has("state")) {
                    class_2248 block = (class_2248)isRegistryObject.getValue();
                    Map<String, class_2769> propertyLookup = block.method_9564().method_28501().stream().map(it -> Map.entry(it.method_11899(), it)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    boolean optional = objCondition.has("optional") && JsonHelper.getJsonBoolean(objCondition, "optional");
                    JsonObject properties = JsonHelper.getJsonObject(objCondition, "state");
                    Map.Entry[] stateProperties = new Map.Entry[properties.size()];
                    int index = 0;
                    for (Map.Entry propertyEntry : properties.entrySet()) {
                        String propertyValue;
                        if (!propertyLookup.containsKey(propertyEntry.getKey())) {
                            throw new IllegalArgumentException("Block does not contain property with name: " + (String)propertyEntry.getKey());
                        }
                        class_2769 property = propertyLookup.get(propertyEntry.getKey());
                        Optional value = property.method_11900(propertyValue = JsonHelper.toString(property.method_11899(), (JsonElement)propertyEntry.getValue()));
                        if (value.isEmpty()) {
                            throw new IllegalStateException("Property " + property.method_11899() + " doesn't contain value " + propertyValue);
                        }
                        stateProperties[index] = Map.entry(property, value.get());
                        ++index;
                    }
                    return new AndCondition(generic, new HasPropertyCondition(block.method_40142().method_40237().method_29177(), Map.ofEntries(stateProperties), optional));
                }
            }
            return generic;
        }
        if (condition.isJsonObject() && (recipeCondition = condition.getAsJsonObject()).has("condition")) {
            class_2960 conditionId = JsonHelper.getJsonResourceLocation(recipeCondition, "condition");
            if (IS_WOODEN_CHEST_ID.equals((Object)conditionId)) {
                return IS_WOODEN_CHEST;
            }
            if (IS_WOODEN_BARREL_ID.equals((Object)conditionId)) {
                return IS_WOODEN_BARREL;
            }
            throw new IllegalArgumentException("condition with id " + conditionId + " doesn't exist.");
        }
        throw new JsonSyntaxException("Unknown recipe condition");
    }

    public static RecipeCondition readEntityCondition(JsonElement condition) {
        RecipeCondition generic = RecipeCondition.tryReadGenericCondition(condition, class_7923.field_41177);
        if (generic != null) {
            return generic;
        }
        throw new JsonSyntaxException("Unknown recipe condition");
    }

    public static Object unwrap(Object subject) {
        if (subject instanceof class_2680) {
            class_2680 state = (class_2680)subject;
            return state.method_26204();
        }
        if (subject instanceof class_1297) {
            class_1297 entity = (class_1297)subject;
            return entity.method_5864();
        }
        return subject;
    }

    public boolean isExactMatch();

    public boolean test(Object var1);

    public class_2960 getNetworkId();

    public void writeToBuffer(class_2540 var1);

    public static RecipeCondition readFromNetworkBuffer(class_2540 buffer) {
        class_2960 id = buffer.method_10810();
        if (RECIPE_DESERIALIZERS.containsKey(id)) {
            return RECIPE_DESERIALIZERS.get(id).apply(buffer);
        }
        throw new IllegalStateException("Cannot find recipe condition with id: \"" + id + "\"");
    }

    @Nullable
    public JsonElement toJson(@Nullable JsonObject var1);
}

