/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.common.recipe.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_2960;

public class JsonHelper {
    private JsonHelper() {
        throw new IllegalStateException("Tried to instantiate a helper class");
    }

    public static void checkHasEntry(JsonObject object, String name) {
        if (!object.has(name)) {
            throw new JsonSyntaxException("Missing " + name + " entry");
        }
    }

    public static JsonObject getJsonObject(JsonObject object, String name) {
        JsonHelper.checkHasEntry(object, name);
        if (!object.get(name).isJsonObject()) {
            throw new JsonSyntaxException(name + " entry must be an Object");
        }
        return object.getAsJsonObject(name);
    }

    public static class_2960 getJsonResourceLocation(JsonObject object, String name) {
        JsonHelper.checkHasEntry(object, name);
        class_2960 resourceLocation = class_2960.method_12829((String)JsonHelper.getJsonString(object, name));
        if (resourceLocation == null) {
            throw new JsonSyntaxException(name + " entry must be a valid ResourceLocation");
        }
        return resourceLocation;
    }

    public static String getJsonString(JsonObject object, String name) {
        JsonHelper.checkHasEntry(object, name);
        if (!object.get(name).isJsonPrimitive() || !object.get(name).getAsJsonPrimitive().isString()) {
            throw new JsonSyntaxException(name + " entry must be a String");
        }
        return object.getAsJsonPrimitive(name).getAsString();
    }

    public static JsonArray getJsonArray(JsonObject object, String name) {
        JsonHelper.checkHasEntry(object, name);
        if (!object.get(name).isJsonArray()) {
            throw new JsonSyntaxException(name + " entry must be an Array");
        }
        return object.getAsJsonArray(name);
    }

    public static String toString(String key, JsonElement value) {
        if (value.isJsonPrimitive()) {
            return value.getAsJsonPrimitive().getAsString();
        }
        throw new IllegalArgumentException("Cannot convert" + key + "'s value to a string");
    }

    public static boolean getJsonBoolean(JsonObject object, String name) {
        JsonHelper.checkHasEntry(object, name);
        if (!object.get(name).isJsonPrimitive() || !object.get(name).getAsJsonPrimitive().isBoolean()) {
            throw new JsonSyntaxException(name + " entry must be a Boolean");
        }
        return object.getAsJsonPrimitive(name).getAsBoolean();
    }
}

