/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.common.recipe.misc;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import compasses.expandedstorage.common.recipe.misc.JsonHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class PartialBlockState<T extends class_2248> {
    private final T block;
    private final Map<class_2769<?>, ?> properties;

    public PartialBlockState(T block) {
        this(block, Map.of());
    }

    public PartialBlockState(T block, Map<class_2769<?>, ?> properties) {
        this.block = block;
        this.properties = properties;
    }

    public static PartialBlockState<?> readFromJson(JsonObject object) {
        class_2960 blockId = JsonHelper.getJsonResourceLocation(object, "id");
        if (blockId.toString().equals("minecraft:air")) {
            return null;
        }
        Optional block = class_7923.field_41175.method_17966(blockId);
        if (block.isEmpty()) {
            throw new IllegalArgumentException("Block id refers to unregistered block");
        }
        if (object.has("state")) {
            JsonObject properties = object.getAsJsonObject("state");
            if (properties.size() == 0) {
                throw new IllegalStateException("state must contain at least one property.");
            }
            Map<String, class_2769> propertyLookup = ((class_2248)block.get()).method_9564().method_28501().stream().map(it -> Map.entry(it.method_11899(), it)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map.Entry[] stateProperties = new Map.Entry[properties.size()];
            int index = 0;
            for (Map.Entry propertyEntry : properties.entrySet()) {
                String propertyValue;
                if (!propertyLookup.containsKey(propertyEntry.getKey())) {
                    throw new IllegalArgumentException("Block does not contain property with name: " + (String)propertyEntry.getKey());
                }
                class_2769 property = propertyLookup.get(propertyEntry.getKey());
                Optional value = property.method_11900(propertyValue = JsonHelper.toString(property.method_11899(), (JsonElement)propertyEntry.getValue()));
                if (value.isEmpty()) {
                    throw new IllegalStateException("Property " + property.method_11899() + " doesn't contain value " + propertyValue);
                }
                stateProperties[index] = Map.entry(property, value.get());
                ++index;
            }
            return new PartialBlockState<class_2248>((class_2248)block.get(), Map.ofEntries(stateProperties));
        }
        return new PartialBlockState<class_2248>((class_2248)block.get(), Map.of());
    }

    public T getBlock() {
        return this.block;
    }

    public boolean matches(class_2680 state) {
        if (state.method_26204() != this.block) {
            return false;
        }
        for (Map.Entry<class_2769<?>, ?> property : this.properties.entrySet()) {
            if (!state.method_28498(property.getKey())) {
                return false;
            }
            if (state.method_11654(property.getKey()).equals(property.getValue())) continue;
            return false;
        }
        return true;
    }

    public <K extends Comparable<K>, V extends K> class_2680 transform(class_2680 state) {
        for (Map.Entry<class_2769<?>, ?> entry : this.properties.entrySet()) {
            state = (class_2680)state.method_11657(entry.getKey(), (Comparable)entry.getValue());
        }
        return state;
    }

    public static <T extends class_2248> PartialBlockState<T> of(T block) {
        return new PartialBlockState<T>(block, Map.of());
    }

    public static <T extends class_2248> PartialBlockState<T> of(T block, Map<class_2769<?>, ?> properties) {
        return new PartialBlockState<T>(block, properties);
    }

    public void writeToBuffer(class_2540 buffer) {
        buffer.method_10812(class_7923.field_41175.method_10221(this.block));
        buffer.writeInt(this.properties.size());
        for (Map.Entry<class_2769<?>, ?> property : this.properties.entrySet()) {
            buffer.method_10814(property.getKey().method_11899());
            buffer.method_10814(property.getValue().toString());
        }
    }

    public static PartialBlockState<?> readFromBuffer(class_2540 buffer) {
        class_2960 id = buffer.method_10810();
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(id);
        int mapSize = buffer.readInt();
        if (mapSize == 0) {
            return PartialBlockState.of(block);
        }
        HashMap properties = Maps.newHashMapWithExpectedSize((int)mapSize);
        for (int i = 0; i < mapSize; ++i) {
            class_2769 key = block.method_9595().method_11663(buffer.method_19772());
            Object value = key.method_11900(buffer.method_19772()).orElseThrow();
            properties.put(key, value);
        }
        return PartialBlockState.of(block, properties);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.block.method_40142().method_40237().method_29177().toString());
        if (!this.properties.isEmpty()) {
            JsonObject jsonProperties = new JsonObject();
            for (Map.Entry<class_2769<?>, ?> property : this.properties.entrySet()) {
                jsonProperties.addProperty(property.getKey().method_11899(), property.getValue().toString());
            }
            json.add("state", (JsonElement)jsonProperties);
        }
        return json;
    }
}

