/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.fabric;

import compasses.expandedstorage.common.CommonMain;
import compasses.expandedstorage.common.block.misc.CopperBlockHelper;
import compasses.expandedstorage.common.registration.Content;
import compasses.expandedstorage.common.registration.ContentConsumer;
import compasses.expandedstorage.fabric.FabricCommonHelper;
import compasses.expandedstorage.thread.ThreadCommonHelper;
import compasses.expandedstorage.thread.ThreadMain;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.VersionParsingException;
import org.slf4j.LoggerFactory;

public final class FabricMain
implements ModInitializer {
    public void onInitialize() {
        boolean isCarrierCompatEnabled;
        FabricLoader fabricLoader = FabricLoader.getInstance();
        if (fabricLoader.isModLoaded("quilt_loader")) {
            LoggerFactory.getLogger((String)"expandedstorage").warn("Please use Expanded Storage for Quilt instead.");
            System.exit(0);
            return;
        }
        try {
            SemanticVersion version = SemanticVersion.parse((String)"1.8.0");
            isCarrierCompatEnabled = fabricLoader.getModContainer("carrier").map(it -> it.getMetadata().getVersion().compareTo((Object)version) > 0).orElse(false);
        }
        catch (VersionParsingException e) {
            throw new IllegalStateException("Author made a typo: ", e);
        }
        boolean isClient = fabricLoader.getEnvironmentType() == EnvType.CLIENT;
        ThreadMain.constructContent(new FabricCommonHelper(), fabricLoader.isModLoaded("htm"), isClient, ((ContentConsumer)ThreadMain::registerContent).andThenIf(isCarrierCompatEnabled, ThreadMain::registerCarrierCompat).andThen(this::registerOxidisableAndWaxableBlocks));
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> ((ThreadCommonHelper)CommonMain.platformHelper()).setServerInstance(null));
    }

    private void registerOxidisableAndWaxableBlocks(Content content) {
        CopperBlockHelper.oxidisation().forEach(OxidizableBlocksRegistry::registerOxidizableBlockPair);
        CopperBlockHelper.dewaxing().inverse().forEach(OxidizableBlocksRegistry::registerWaxableBlockPair);
    }
}

