/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.setup.fabric;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.mehvahdjukaar.moonlight.api.platform.setup.IDeferredCommonSetup;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1761;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_79;
import net.minecraft.class_83;
import org.jetbrains.annotations.ApiStatus;

public class SetupHelperImpl {
    private static boolean isValid = true;
    private static final List<Supplier<class_3288>> EXTRA_DATA_PACKS = new ArrayList<Supplier<class_3288>>();
    private static final Map<String, Queue<Runnable>> SETUP_STEPS = new LinkedHashMap<String, Queue<Runnable>>();

    @ApiStatus.Internal
    public static void run() {
        isValid = false;
        SETUP_STEPS.values().forEach(q -> q.forEach(Runnable::run));
        SETUP_STEPS.clear();
    }

    public static void deferSetup(IDeferredCommonSetup mod) {
        if (!isValid) {
            throw new IllegalStateException("Defer setup must be called in mod init");
        }
        mod.registerServerReloadListener((listener, name) -> ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(new IdentifiableResourceReloadListener(){
            final class_3302 instance;
            {
                this.instance = (class_3302)listener.get();
            }

            public class_2960 getFabricId() {
                return name;
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return this.instance.method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }
        }));
        SETUP_STEPS.computeIfAbsent("attributes", a -> new ArrayDeque()).add(() -> mod.registerAttributes(FabricDefaultAttributeRegistry::register));
        SETUP_STEPS.computeIfAbsent("spawns", a -> new ArrayDeque()).add(() -> mod.registerSpawnPlacements(new SpawnPlacementsImpl()));
        CommandRegistrationCallback.EVENT.register(mod::registerCommands);
        mod.registerBuiltinDataPack(EXTRA_DATA_PACKS::add);
        if (SetupHelperImpl.hasImpl(mod, "addLootTableInjects")) {
            LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> mod.addLootTableInjects(new IDeferredCommonSetup.LootInjectEvent(){

                @Override
                public class_2960 getTable() {
                    return id;
                }

                @Override
                public void addTableReference(class_2960 injected) {
                    class_55 pool = class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)injected)).method_355();
                    tableBuilder.pool(pool);
                }
            }));
        }
        SETUP_STEPS.computeIfAbsent("item_to_tabs", a -> new ArrayDeque()).add(() -> {
            IDeferredCommonSetup.ItemToTabEvent event = new IDeferredCommonSetup.ItemToTabEvent((tab, target, after, items) -> ItemGroupEvents.modifyEntriesEvent((class_5321)tab).register(entries -> {
                if (target == null) {
                    entries.method_45423(items);
                } else if (after.booleanValue()) {
                    entries.addAfter(target, items, class_1761.class_7705.field_40191);
                } else {
                    entries.addBefore(target, items, class_1761.class_7705.field_40191);
                }
            }));
            mod.addItemsToTabs(event);
        });
        Queue s = SETUP_STEPS.computeIfAbsent("setup", a -> new ArrayDeque());
        s.add(mod::setup);
        s.add(mod::asyncSetup);
    }

    public static boolean hasImpl(IDeferredCommonSetup mod, String name) {
        return Utils.isMethodImplemented(IDeferredCommonSetup.class, mod.getClass(), name);
    }

    static class SpawnPlacementsImpl
    implements IDeferredCommonSetup.SpawnPlacementEvent {
        SpawnPlacementsImpl() {
        }

        @Override
        public <T extends class_1297> void register(class_1299<T> entityType, class_1317.class_1319 decoratorType, class_2902.class_2903 heightMapType, class_1317.class_4306<T> decoratorPredicate) {
            try {
                class_1317.method_20637(entityType, (class_1317.class_1319)decoratorType, (class_2902.class_2903)heightMapType, decoratorPredicate);
            }
            catch (Exception e) {
                Moonlight.LOGGER.warn("Skipping placement registration for {} as its not of Mob type", entityType);
            }
        }
    }
}

