/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core;

import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.events.IDropItemOnDeathEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.integration.CompatWoodTypes;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.misc.RegistryAccessJsonReloadListener;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.VillagerAIInternal;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.mehvahdjukaar.moonlight.core.set.BlocksColorInternal;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1928;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Moonlight {
    public static final String MOD_ID = "moonlight";
    public static final Logger LOGGER = LogManager.getLogger((String)"Moonlight");
    public static final boolean HAS_BEEN_INIT = true;

    public static class_2960 res(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void commonInit() {
        BlockSetInternal.registerBlockSetDefinition(WoodTypeRegistry.INSTANCE);
        BlockSetInternal.registerBlockSetDefinition(LeavesTypeRegistry.INSTANCE);
        CompatWoodTypes.init();
        MoonlightRegistry.init();
        ModMessages.init();
        VillagerAIInternal.init();
        MapDataInternal.init();
        SoftFluidRegistry.init();
        PlatHelper.addCommonSetup(Moonlight::commonSetup);
        BlockSetAPI.addDynamicRegistration((reg, wood) -> AdditionalItemPlacementsAPI.afterItemReg(), WoodType.class, class_7923.field_41181);
    }

    private static void commonSetup() {
        BlocksColorInternal.setup();
    }

    public static void onPlayerCloned(class_1657 oldPlayer, class_1657 newPlayer, boolean wasDeath) {
        if (wasDeath && !oldPlayer.method_37908().method_8450().method_8355(class_1928.field_19389)) {
            class_1661 inv = oldPlayer.method_31548();
            int i = 0;
            for (class_1799 v : inv.field_7547) {
                if (v != class_1799.field_8037) {
                    IDropItemOnDeathEvent e = IDropItemOnDeathEvent.create(v, oldPlayer, false);
                    MoonlightEventsHelper.postEvent(e, IDropItemOnDeathEvent.class);
                    if (e.isCanceled()) {
                        newPlayer.method_31548().method_5447(i, e.getReturnItemStack());
                    }
                }
                ++i;
            }
        }
    }

    public static void afterDataReload(class_5455 registryAccess) {
        RegistryAccessJsonReloadListener.runReloads(registryAccess);
        DynamicResourcePack.clearAfterReload(false);
    }

    public static void assertInitPhase() {
        if (!PlatHelper.isInitializing() && PlatHelper.isDev()) {
            throw new AssertionError((Object)"Method has to be called during mod initialization phase");
        }
    }

    public static class_22 getMapDataFromKnownKeys(class_3218 level, int mapId) {
        class_22 d = level.method_17891(class_1806.method_17440((int)mapId));
        if (d == null && (d = level.method_17891("magicmap_" + mapId)) == null) {
            d = level.method_17891("mazemap_" + mapId);
        }
        return d;
    }
}

