/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core;

import java.util.Set;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationClientManager;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.client.SoftFluidParticleColors;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MoonlightClient {
    private static final ThreadLocal<Boolean> MAP_MIPMAP = ThreadLocal.withInitial(() -> false);
    private static MergedDynamicTexturePack mergedDynamicPack;

    public static void initClient() {
        ClientHelper.addClientReloadListener(SoftFluidParticleColors::new, Moonlight.res("soft_fluids"));
        ClientHelper.addClientReloadListener(MapDecorationClientManager::new, Moonlight.res("map_markers"));
        ClientConfigs.init();
    }

    public static DynamicTexturePack maybeMergePack(DynamicTexturePack pack) {
        if (mergedDynamicPack == null) {
            mergedDynamicPack = new MergedDynamicTexturePack(){};
        }
        Set<String> nameSpaces = pack.method_14406(pack.getPackType());
        for (String n : nameSpaces) {
            mergedDynamicPack.addNamespaces(n);
        }
        ++MoonlightClient.mergedDynamicPack.mods;
        return mergedDynamicPack;
    }

    public static void afterTextureReload() {
        DynamicResourcePack.clearAfterReload(true);
    }

    public static void setMipMap(boolean b) {
        if (ClientConfigs.MAPS_MIPMAP.get() == 0) {
            b = false;
        }
        MAP_MIPMAP.set(b);
    }

    public static boolean isMapMipMap() {
        return MAP_MIPMAP.get();
    }

    private static class MergedDynamicTexturePack
    extends DynamicTexturePack {
        int mods = 0;

        public MergedDynamicTexturePack() {
            super(Moonlight.res("mods_dynamic_assets"));
        }

        @Override
        public class_2561 makeDescription() {
            return class_2561.method_43470((String)("Dynamic resources for " + this.mods + (this.mods == 1 ? " mod" : " mods")));
        }
    }
}

