/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.FullscreenMap;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.FrontierListElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.RadioListElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.client.gui.screen.FrontierInfo;
import games.alejandrocoria.mapfrontiers.client.gui.screen.NewFrontier;
import games.alejandrocoria.mapfrontiers.client.util.ScreenHelper;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.IClientAPI;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@ParametersAreNonnullByDefault
public class FrontierList
extends class_437 {
    private final IClientAPI jmAPI;
    private final FullscreenMap fullscreenMap;
    private float scaleFactor;
    private int actualWidth;
    private int actualHeight;
    private ScrollBox frontiers;
    private ScrollBox filterType;
    private ScrollBox filterOwner;
    private ScrollBox filterDimension;
    private SimpleButton buttonResetFilters;
    private SimpleButton buttonCreate;
    private SimpleButton buttonInfo;
    private SimpleButton buttonDelete;
    private SimpleButton buttonVisible;
    private SimpleButton buttonDone;
    private final List<SimpleLabel> labels;

    public FrontierList(IClientAPI jmAPI, FullscreenMap fullscreenMap) {
        super((class_2561)class_2561.method_43471((String)"mapfrontiers.title_frontiers"));
        this.jmAPI = jmAPI;
        this.fullscreenMap = fullscreenMap;
        this.labels = new ArrayList<SimpleLabel>();
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            this.updateFrontiers();
            this.updateButtons();
        });
        ClientEventHandler.subscribeNewFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            this.updateFrontiers();
            this.updateButtons();
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            this.updateFrontiers();
            this.updateButtons();
        });
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> this.updateButtons());
    }

    public void method_25426() {
        this.scaleFactor = ScreenHelper.getScaleFactorThatFit(this.field_22787, this, 772, 332);
        this.actualWidth = (int)((float)this.field_22789 * this.scaleFactor);
        this.actualHeight = (int)((float)this.field_22790 * this.scaleFactor);
        this.labels.clear();
        this.frontiers = new ScrollBox(this.actualWidth / 2 - 300, 50, 450, this.actualHeight - 100, 24);
        this.frontiers.setElementDeletedCallback(element -> this.updateButtons());
        this.frontiers.setElementClickedCallback(element -> {
            FrontierOverlay frontier = ((FrontierListElement)element).getFrontier();
            this.fullscreenMap.selectFrontier(frontier);
            this.updateButtons();
        });
        this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2 + 170, 74, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.filter_type"), -2236963));
        this.filterType = new ScrollBox(this.actualWidth / 2 + 170, 86, 200, 48, 16);
        this.filterType.addElement(new RadioListElement(this.field_22793, Config.getTranslatedEnum(Config.FilterFrontierType.All), Config.FilterFrontierType.All.ordinal()));
        this.filterType.addElement(new RadioListElement(this.field_22793, Config.getTranslatedEnum(Config.FilterFrontierType.Global), Config.FilterFrontierType.Global.ordinal()));
        this.filterType.addElement(new RadioListElement(this.field_22793, Config.getTranslatedEnum(Config.FilterFrontierType.Personal), Config.FilterFrontierType.Personal.ordinal()));
        this.filterType.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierType.ordinal());
        this.filterType.setElementDeletedCallback(element -> this.updateButtons());
        this.filterType.setElementClickedCallback(element -> {
            int selected = ((RadioListElement)element).getId();
            Config.filterFrontierType = Config.FilterFrontierType.values()[selected];
            this.updateFrontiers();
            ClientEventHandler.postUpdatedConfigEvent();
            this.updateButtons();
        });
        this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2 + 170, 144, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.filter_owner"), -2236963));
        this.filterOwner = new ScrollBox(this.actualWidth / 2 + 170, 156, 200, 48, 16);
        this.filterOwner.addElement(new RadioListElement(this.field_22793, Config.getTranslatedEnum(Config.FilterFrontierOwner.All), Config.FilterFrontierOwner.All.ordinal()));
        this.filterOwner.addElement(new RadioListElement(this.field_22793, Config.getTranslatedEnum(Config.FilterFrontierOwner.You), Config.FilterFrontierOwner.You.ordinal()));
        this.filterOwner.addElement(new RadioListElement(this.field_22793, Config.getTranslatedEnum(Config.FilterFrontierOwner.Others), Config.FilterFrontierOwner.Others.ordinal()));
        this.filterOwner.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierOwner.ordinal());
        this.filterOwner.setElementDeletedCallback(element -> this.updateButtons());
        this.filterOwner.setElementClickedCallback(element -> {
            int selected = ((RadioListElement)element).getId();
            Config.filterFrontierOwner = Config.FilterFrontierOwner.values()[selected];
            this.updateFrontiers();
            ClientEventHandler.postUpdatedConfigEvent();
            this.updateButtons();
        });
        this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2 + 170, 214, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.filter_dimension"), -2236963));
        this.filterDimension = new ScrollBox(this.actualWidth / 2 + 170, 226, 200, this.actualHeight - 296, 16);
        this.filterDimension.addElement(new RadioListElement(this.field_22793, (class_2561)class_2561.method_43471((String)"mapfrontiers.config.All"), "all".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.field_22793, (class_2561)class_2561.method_43471((String)"mapfrontiers.config.Current"), "current".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.field_22793, (class_2561)class_2561.method_43470((String)"minecraft:overworld"), "minecraft:overworld".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.field_22793, (class_2561)class_2561.method_43470((String)"minecraft:the_nether"), "minecraft:the_nether".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.field_22793, (class_2561)class_2561.method_43470((String)"minecraft:the_end"), "minecraft:the_end".hashCode()));
        this.addDimensionsToFilter();
        this.filterDimension.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierDimension.hashCode());
        this.filterDimension.setElementDeletedCallback(element -> this.updateButtons());
        this.filterDimension.setElementClickedCallback(element -> {
            int selected = ((RadioListElement)element).getId();
            Config.filterFrontierDimension = selected == "all".hashCode() ? "all" : (selected == "current".hashCode() ? "current" : this.getDimensionFromHash(selected));
            this.updateFrontiers();
            ClientEventHandler.postUpdatedConfigEvent();
            this.updateButtons();
        });
        if (this.filterDimension.getSelectedElement() == null) {
            Config.filterFrontierDimension = "all";
            this.filterDimension.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierDimension.hashCode());
        }
        this.buttonResetFilters = new SimpleButton(this.field_22793, this.actualWidth / 2 + 170, 50, 110, (class_2561)class_2561.method_43471((String)"mapfrontiers.reset_filters"), this::buttonPressed);
        this.buttonCreate = new SimpleButton(this.field_22793, this.actualWidth / 2 - 295, this.actualHeight - 28, 110, (class_2561)class_2561.method_43471((String)"mapfrontiers.create"), this::buttonPressed);
        this.buttonInfo = new SimpleButton(this.field_22793, this.actualWidth / 2 - 175, this.actualHeight - 28, 110, (class_2561)class_2561.method_43471((String)"mapfrontiers.info"), this::buttonPressed);
        this.buttonDelete = new SimpleButton(this.field_22793, this.actualWidth / 2 - 55, this.actualHeight - 28, 110, (class_2561)class_2561.method_43471((String)"mapfrontiers.delete"), this::buttonPressed);
        this.buttonDelete.setTextColors(-34953, -65536);
        this.buttonVisible = new SimpleButton(this.field_22793, this.actualWidth / 2 + 65, this.actualHeight - 28, 110, (class_2561)class_2561.method_43471((String)"mapfrontiers.hide"), this::buttonPressed);
        this.buttonDone = new SimpleButton(this.field_22793, this.actualWidth / 2 + 185, this.actualHeight - 28, 110, (class_2561)class_2561.method_43471((String)"gui.done"), this::buttonPressed);
        this.method_37063((class_364)this.frontiers);
        this.method_37063((class_364)this.filterType);
        this.method_37063((class_364)this.filterOwner);
        this.method_37063((class_364)this.filterDimension);
        this.method_37063((class_364)this.buttonResetFilters);
        this.method_37063((class_364)this.buttonCreate);
        this.method_37063((class_364)this.buttonInfo);
        this.method_37063((class_364)this.buttonDelete);
        this.method_37063((class_364)this.buttonVisible);
        this.method_37063((class_364)this.buttonDone);
        this.updateFrontiers();
        if (this.fullscreenMap.getSelected() != null) {
            this.frontiers.selectElementIf(element -> ((FrontierListElement)element).getFrontier().getId().equals(this.fullscreenMap.getSelected().getId()));
        }
        this.updateButtons();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        mouseX = (int)((float)mouseX * this.scaleFactor);
        mouseY = (int)((float)mouseY * this.scaleFactor);
        if (this.scaleFactor != 1.0f) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22905(1.0f / this.scaleFactor, 1.0f / this.scaleFactor, 1.0f);
        }
        graphics.method_27534(this.field_22793, this.field_22785, this.actualWidth / 2, 8, -1);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        for (SimpleLabel label : this.labels) {
            if (!label.field_22764) continue;
            label.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.scaleFactor != 1.0f) {
            graphics.method_51448().method_22909();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        return super.method_25402(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, mouseButton);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        mouseX *= (double)this.scaleFactor;
        mouseY *= (double)this.scaleFactor;
        for (class_364 w : this.method_25396()) {
            if (!(w instanceof ScrollBox)) continue;
            ((ScrollBox)w).mouseReleased();
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        return super.method_25401(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, delta);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.method_25403(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button, dragX * (double)this.scaleFactor, dragY * (double)this.scaleFactor);
    }

    protected void buttonPressed(class_4185 button) {
        if (button == this.buttonResetFilters) {
            Config.filterFrontierType = Config.FilterFrontierType.All;
            this.filterType.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierType.ordinal());
            Config.filterFrontierOwner = Config.FilterFrontierOwner.All;
            this.filterOwner.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierOwner.ordinal());
            Config.filterFrontierDimension = "all";
            this.filterDimension.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierDimension.hashCode());
            this.updateFrontiers();
            this.updateButtons();
        } else if (button == this.buttonCreate) {
            Services.PLATFORM.popGuiLayer();
            Services.PLATFORM.pushGuiLayer(new NewFrontier(this.jmAPI));
        } else if (button == this.buttonInfo) {
            Services.PLATFORM.popGuiLayer();
            FrontierOverlay frontier = ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
            Services.PLATFORM.pushGuiLayer(new FrontierInfo(this.jmAPI, frontier, () -> Services.PLATFORM.pushGuiLayer(new FrontierList(this.jmAPI, this.fullscreenMap))));
        } else if (button == this.buttonDelete) {
            FrontierOverlay frontier = ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
            FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(frontier.getPersonal());
            frontierManager.clientDeleteFrontier(frontier);
            this.frontiers.removeElement(this.frontiers.getSelectedElement());
            this.updateButtons();
        } else if (button == this.buttonVisible) {
            FrontierOverlay frontier;
            frontier.setVisible(!(frontier = ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier()).getVisible());
            this.updateButtons();
        } else if (button == this.buttonDone) {
            Services.PLATFORM.popGuiLayer();
        }
    }

    public void method_25432() {
        ClientEventHandler.unsuscribeAllEvents((Object)this);
    }

    private void addDimensionsToFilter() {
        List<String> dimensions = Services.JOURNEYMAP.getDimensionList();
        for (String dimension : dimensions) {
            if (dimension.equals("minecraft:overworld") || dimension.equals("minecraft:the_nether") || dimension.equals("minecraft:the_end")) continue;
            this.filterDimension.addElement(new RadioListElement(this.field_22793, (class_2561)class_2561.method_43470((String)dimension), dimension.hashCode()));
        }
    }

    private String getDimensionFromHash(int hash) {
        List<String> dimensions = Services.JOURNEYMAP.getDimensionList();
        for (String dimension : dimensions) {
            if (dimension.hashCode() != hash) continue;
            return dimension;
        }
        return "";
    }

    private void updateFrontiers() {
        FrontierOverlay selectedFrontier = this.frontiers.getSelectedElement() == null ? null : ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
        UUID frontierID = selectedFrontier == null ? null : selectedFrontier.getId();
        this.frontiers.removeAll();
        if (Config.filterFrontierType == Config.FilterFrontierType.All || Config.filterFrontierType == Config.FilterFrontierType.Personal) {
            for (ArrayList<FrontierOverlay> dimension : MapFrontiersClient.getFrontiersOverlayManager(true).getAllFrontiers().values()) {
                for (FrontierOverlay frontier : dimension) {
                    if (!this.checkFilterOwner(frontier) || !this.checkFilterDimension(frontier)) continue;
                    this.frontiers.addElement(new FrontierListElement(this.field_22793, frontier));
                }
            }
        }
        if (Config.filterFrontierType == Config.FilterFrontierType.All || Config.filterFrontierType == Config.FilterFrontierType.Global) {
            for (ArrayList<FrontierOverlay> dimension : MapFrontiersClient.getFrontiersOverlayManager(false).getAllFrontiers().values()) {
                for (FrontierOverlay frontier : dimension) {
                    if (!this.checkFilterOwner(frontier) || !this.checkFilterDimension(frontier)) continue;
                    this.frontiers.addElement(new FrontierListElement(this.field_22793, frontier));
                }
            }
        }
        if (frontierID != null) {
            this.frontiers.selectElementIf(element -> ((FrontierListElement)element).getFrontier().getId().equals(frontierID));
        }
    }

    private boolean checkFilterOwner(FrontierOverlay frontier) {
        boolean ownerIsPlayer;
        if (Config.filterFrontierOwner == Config.FilterFrontierOwner.All) {
            return true;
        }
        boolean bl = ownerIsPlayer = this.field_22787.field_1724 != null && frontier.getOwner().equals(new SettingsUser((class_1657)this.field_22787.field_1724));
        if (Config.filterFrontierOwner == Config.FilterFrontierOwner.You) {
            return ownerIsPlayer;
        }
        return !ownerIsPlayer;
    }

    private boolean checkFilterDimension(FrontierOverlay frontier) {
        if (Config.filterFrontierDimension.equals("all")) {
            return true;
        }
        String dimension = Config.filterFrontierDimension;
        if (dimension.equals("current") && this.field_22787.field_1687 != null) {
            dimension = this.field_22787.field_1687.method_27983().method_29177().toString();
        }
        return frontier.getDimension().method_29177().toString().equals(dimension);
    }

    private void updateButtons() {
        if (this.field_22787.field_1724 == null) {
            return;
        }
        SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
        SettingsUser playerUser = new SettingsUser((class_1657)this.field_22787.field_1724);
        FrontierOverlay frontier = this.frontiers.getSelectedElement() == null ? null : ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
        SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, frontier, playerUser);
        this.buttonInfo.field_22764 = this.frontiers.getSelectedElement() != null;
        this.buttonDelete.field_22764 = actions.canDelete;
        this.buttonVisible.field_22764 = actions.canUpdate;
        if (frontier != null && frontier.getVisible()) {
            this.buttonVisible.method_25355((class_2561)class_2561.method_43471((String)"mapfrontiers.hide"));
        } else {
            this.buttonVisible.method_25355((class_2561)class_2561.method_43471((String)"mapfrontiers.show"));
        }
    }
}

