/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class PacketPersonalFrontierShared {
    public static final class_2960 CHANNEL = new class_2960("mapfrontiers", "packet_personal_frontier_shared");
    private int shareMessageID;
    private final SettingsUser playerSharing;
    private final SettingsUser owner;
    private String name1;
    private String name2;

    public PacketPersonalFrontierShared() {
        this.shareMessageID = -1;
        this.playerSharing = new SettingsUser();
        this.owner = new SettingsUser();
        this.name1 = "";
        this.name2 = "";
    }

    public PacketPersonalFrontierShared(int shareMessageID, SettingsUser playerSharing, SettingsUser owner, String name1, String name2) {
        this.shareMessageID = shareMessageID;
        this.playerSharing = playerSharing;
        this.owner = owner;
        this.name1 = name1;
        this.name2 = name2;
    }

    public static PacketPersonalFrontierShared decode(class_2540 buf) {
        PacketPersonalFrontierShared packet = new PacketPersonalFrontierShared();
        packet.shareMessageID = buf.readInt();
        packet.playerSharing.fromBytes(buf);
        packet.owner.fromBytes(buf);
        packet.name1 = buf.method_10800(17);
        packet.name2 = buf.method_10800(17);
        return packet;
    }

    public void encode(class_2540 buf) {
        buf.writeInt(this.shareMessageID);
        this.playerSharing.toBytes(buf);
        this.owner.toBytes(buf);
        buf.method_10814(this.name1);
        buf.method_10814(this.name2);
    }

    public static void handle(PacketContext<PacketPersonalFrontierShared> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            PacketPersonalFrontierShared message = (PacketPersonalFrontierShared)ctx.message();
            Object frontierName = message.name1.isEmpty() && message.name2.isEmpty() ? "Unnamed Frontier" : (message.name1.isEmpty() ? message.name2 : (message.name2.isEmpty() ? message.name1 : message.name1 + " " + message.name2));
            class_5250 button = class_2561.method_43470((String)frontierName);
            button.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Click to accept or use command /mfaccept " + message.shareMessageID)))));
            button.method_27694(style -> style.method_10982(Boolean.valueOf(true)));
            button.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/mapfrontiersaccept " + message.shareMessageID)));
            class_5250 text = class_2561.method_43470((String)(PacketPersonalFrontierShared.userToString(message.playerSharing) + " "));
            if (message.playerSharing.equals(message.owner)) {
                text.method_27693("want to share a frontier with you: ");
            } else {
                text.method_27693("want to share a frontier from " + PacketPersonalFrontierShared.userToString(message.owner) + " with you: ");
            }
            text.method_10852((class_2561)button);
            player.method_43496((class_2561)text);
        }
    }

    private static String userToString(SettingsUser user) {
        String string = !StringUtils.isBlank((CharSequence)user.username) ? user.username : (user.uuid != null ? user.uuid.toString() : "User not found");
        return string;
    }
}

