/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierUpdated;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

@ParametersAreNonnullByDefault
public class PacketUpdateSharedUserPersonalFrontier {
    public static final class_2960 CHANNEL = new class_2960("mapfrontiers", "packet_update_shared_user_personal_frontier");
    private UUID frontierID;
    private final SettingsUserShared userShared;

    public PacketUpdateSharedUserPersonalFrontier() {
        this.userShared = new SettingsUserShared();
    }

    public PacketUpdateSharedUserPersonalFrontier(UUID frontierID, SettingsUserShared user) {
        this.frontierID = frontierID;
        this.userShared = user;
    }

    public static PacketUpdateSharedUserPersonalFrontier decode(class_2540 buf) {
        PacketUpdateSharedUserPersonalFrontier packet = new PacketUpdateSharedUserPersonalFrontier();
        packet.frontierID = UUIDHelper.fromBytes((ByteBuf)buf);
        packet.userShared.fromBytes(buf);
        return packet;
    }

    public void encode(class_2540 buf) {
        UUIDHelper.toBytes((ByteBuf)buf, this.frontierID);
        this.userShared.toBytes(buf);
    }

    public static void handle(PacketContext<PacketUpdateSharedUserPersonalFrontier> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            PacketUpdateSharedUserPersonalFrontier message = (PacketUpdateSharedUserPersonalFrontier)ctx.message();
            class_3222 player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.field_13995;
            SettingsUser playerUser = new SettingsUser((class_1657)player);
            FrontierData currentFrontier = FrontiersManager.instance.getFrontierFromID(message.frontierID);
            if (currentFrontier != null && currentFrontier.getPersonal()) {
                if (FrontiersManager.instance.getSettings().checkAction(FrontierSettings.Action.SharePersonalFrontier, playerUser, MapFrontiers.isOPorHost(player), currentFrontier.getOwner())) {
                    SettingsUserShared currentUserShared = currentFrontier.getUserShared(message.userShared.getUser());
                    if (currentUserShared == null) {
                        return;
                    }
                    currentUserShared.setActions(message.userShared.getActions());
                    currentFrontier.addChange(FrontierData.Change.Shared);
                    PacketHandler.sendToUsersWithAccess(new PacketFrontierUpdated(currentFrontier, player.method_5628()), currentFrontier, server);
                } else {
                    PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
                }
            }
        }
    }
}

