/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes;

import com.mojang.authlib.GameProfile;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.AdventureUtil;
import java.util.Objects;
import javax.annotation.Nullable;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorNetworkHandler;
import me.duquee.createutilities.voidlink.VoidLinkSlot;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import org.apache.commons.lang3.tuple.Triple;

public class VoidLinkBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<VoidLinkBehaviour> TYPE = new BehaviourType();
    RedstoneLinkNetworkHandler.Frequency frequencyFirst = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    RedstoneLinkNetworkHandler.Frequency frequencyLast = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    @Nullable
    GameProfile owner;
    VoidLinkSlot firstSlot;
    VoidLinkSlot secondSlot;
    VoidLinkSlot playerSlot;

    public VoidLinkBehaviour(SmartBlockEntity te, Triple<VoidLinkSlot, VoidLinkSlot, VoidLinkSlot> slots) {
        super(te);
        this.firstSlot = (VoidLinkSlot)((Object)slots.getLeft());
        this.secondSlot = (VoidLinkSlot)((Object)slots.getMiddle());
        this.playerSlot = (VoidLinkSlot)((Object)slots.getRight());
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.method_10566("FrequencyFirst", (class_2520)this.frequencyFirst.getStack().method_7953(new class_2487()));
        nbt.method_10566("FrequencyLast", (class_2520)this.frequencyLast.getStack().method_7953(new class_2487()));
        if (this.owner != null) {
            class_2487 compoundTag = new class_2487();
            class_2512.method_10684((class_2487)compoundTag, (GameProfile)this.owner);
            nbt.method_10566("Owner", (class_2520)compoundTag);
        }
    }

    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of((class_1799)class_1799.method_7915((class_2487)nbt.method_10562("FrequencyFirst")));
        this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of((class_1799)class_1799.method_7915((class_2487)nbt.method_10562("FrequencyLast")));
        this.owner = nbt.method_10573("Owner", 10) ? class_2512.method_10683((class_2487)nbt.method_10562("Owner")) : null;
    }

    public VoidMotorNetworkHandler.NetworkKey getNetworkKey() {
        return new VoidMotorNetworkHandler.NetworkKey(this.owner, this.frequencyFirst, this.frequencyLast);
    }

    public void setFrequency(boolean first, class_1799 stack) {
        boolean changed;
        stack = stack.method_7972();
        stack.method_7939(1);
        class_1799 toCompare = this.getFrequencyStack(first);
        boolean bl = changed = !class_1799.method_31577((class_1799)stack, (class_1799)toCompare);
        if (changed) {
            this.onLeaveNetwork();
        }
        if (first) {
            this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of((class_1799)stack);
        } else {
            this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of((class_1799)stack);
        }
        if (!changed) {
            return;
        }
        this.blockEntity.sendData();
        this.onJoinNetwork();
    }

    public boolean testHit(int index, class_243 hit) {
        class_2680 state = this.blockEntity.method_11010();
        class_243 localHit = hit.method_1020(class_243.method_24954((class_2382)this.blockEntity.method_11016()));
        return this.getSlot(index).testHit(state, localHit);
    }

    public ValueBoxTransform getSlot(int index) {
        return index < 2 ? this.getFrequencySlot(index == 0) : this.playerSlot;
    }

    public ValueBoxTransform getFrequencySlot(boolean first) {
        return first ? this.firstSlot : this.secondSlot;
    }

    public class_1799 getFrequencyStack(boolean first) {
        return first ? this.frequencyFirst.getStack() : this.frequencyLast.getStack();
    }

    public boolean canInteract(class_1657 player) {
        return !AdventureUtil.isAdventure((class_1657)player) && this.isOwner(player);
    }

    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable GameProfile owner) {
        if (!Objects.equals(this.owner, owner)) {
            this.onLeaveNetwork();
            this.owner = owner;
            this.blockEntity.sendData();
            this.onJoinNetwork();
        }
    }

    protected void onLeaveNetwork() {
    }

    protected void onJoinNetwork() {
    }

    public boolean isOwner(class_1657 player) {
        return this.owner == null || player.method_7334().equals((Object)this.owner);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }
}

