/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.model.SplashInfo;
import journeymap.client.model.SplashPerson;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.dialog.FullscreenActions;
import journeymap.client.ui.dialog.OptionsManager;
import journeymap.common.Journeymap;
import journeymap.common.properties.catagory.Category;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class AboutDialog
extends JmUI {
    protected Texture discordLogo = TextureCache.getTexture(TextureCache.Discord);
    Button buttonClose;
    Button buttonOptions;
    Button buttonDiscord;
    Button buttonWebsite;
    Button buttonDownload;
    ButtonList peopleButtons;
    ButtonList devButtons;
    ButtonList logoButtons;
    ButtonList linkButtons;
    ButtonList bottomButtons;
    ButtonList infoButtons;
    private long lastPeopleMove;
    private List<SplashPerson> people = Arrays.asList(new SplashPerson[0]);
    private List<SplashPerson> devs = Arrays.asList(new SplashPerson("79f597fe-2877-4ecb-acdf-8c58cc1854ca", "mysticdrew", "jm.common.splash_developer"), new SplashPerson("a2039b6c-5a3d-407d-b49c-091405062b85", "techbrew", "jm.common.splash_developer"), new SplashPerson("ca5c3fc3-4d99-4f2e-a0d0-9565fe783e1f", "gdude2002", "jm.common.splash_developer"), new SplashPerson("16fd5b0e-a7a7-42a6-b203-52de6493c2b4", "Sandriell", "jm.common.splash_artist"));
    private SplashInfo info;

    public AboutDialog(JmUI returnDisplay) {
        super(Constants.getString("jm.common.splash_title", Journeymap.JM_VERSION), returnDisplay);
        this.scaleFactor = (int)class_310.method_1551().method_22683().method_4495();
    }

    @Override
    public void method_25426() {
        Button button2;
        JourneymapClient.getInstance().getCoreProperties().splashViewed.set(Journeymap.JM_VERSION.toString()).save();
        super.setRenderBottomBar(true);
        if (this.info == null) {
            String bday;
            this.info = FileHandler.getMessageModel(SplashInfo.class, "splash");
            if (this.info == null) {
                this.info = new SplashInfo();
            }
            if ((bday = Constants.birthdayMessage()) != null) {
                this.info.lines.add(0, new SplashInfo.Line(bday, "dialog.FullscreenActions#tweet#" + bday));
                this.devs = new ArrayList<SplashPerson>(this.devs);
                this.devs.add(new SplashPerson.Fake("", "", TextureCache.getTexture(TextureCache.ColorPicker2)));
            }
            return;
        }
        this.getRenderables().clear();
        class_327 fr = this.getFontRenderer();
        this.devButtons = new ButtonList();
        for (SplashPerson dev : this.devs) {
            button2 = new Button(dev.name);
            this.devButtons.add(button2);
            dev.setButton(button2);
        }
        this.devButtons.setWidths(20);
        this.devButtons.setHeights(20);
        this.devButtons.layoutDistributedHorizontal(0, 35, this.field_22789, true);
        this.peopleButtons = new ButtonList();
        for (SplashPerson peep : this.people) {
            button2 = new Button(peep.name);
            this.peopleButtons.add(button2);
            peep.setButton(button2);
        }
        this.peopleButtons.setWidths(20);
        this.peopleButtons.setHeights(20);
        this.peopleButtons.layoutDistributedHorizontal(0, this.field_22790 - 65, this.field_22789, true);
        this.infoButtons = new ButtonList();
        for (SplashInfo.Line line : this.info.lines) {
            button2 = new SplashInfoButton(line, b -> line.invokeAction(this));
            button2.setDrawBackground(false);
            button2.setDefaultStyle(false);
            button2.setDrawFrame(false);
            Objects.requireNonNull(fr);
            button2.setHeight(9 + 5);
            if (line.hasAction()) {
                button2.setTooltip(Constants.getString("jm.common.splash_action"));
            }
            this.infoButtons.add(button2);
        }
        this.infoButtons.equalizeWidths(fr);
        this.getRenderables().addAll(this.infoButtons);
        this.buttonClose = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
        this.buttonOptions = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.common.options_button"), button -> {
            if (returnDisplayStack != null && returnDisplayStack.peek() != null && returnDisplayStack.peek() instanceof OptionsManager) {
                this.closeAndReturn();
            } else {
                UIManager.INSTANCE.openOptionsManager(this, new Category[0]);
            }
        }));
        this.buttonOptions.setDefaultStyle(false);
        this.buttonClose.setDefaultStyle(false);
        this.bottomButtons = new ButtonList(this.buttonOptions);
        if (this.field_22787.field_1687 != null) {
            this.bottomButtons.add(this.buttonClose);
        }
        this.bottomButtons.equalizeWidths(fr);
        this.bottomButtons.setWidths(Math.max(100, this.buttonOptions.method_25368()));
        this.getRenderables().addAll(this.bottomButtons);
        this.buttonWebsite = (Button)this.method_37063((class_364)new Button("http://journeymap.info", button -> FullscreenActions.launchWebsite("")));
        this.buttonWebsite.setTooltip(Constants.getString("jm.common.website"));
        this.buttonDownload = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.common.download"), button -> FullscreenActions.launchDownloadWebsite()));
        this.buttonDownload.setTooltip(Constants.getString("jm.common.download.tooltip"));
        this.buttonWebsite.setDefaultStyle(false);
        this.buttonDownload.setDefaultStyle(false);
        this.linkButtons = new ButtonList(this.buttonWebsite, this.buttonDownload);
        this.linkButtons.equalizeWidths(fr);
        this.getRenderables().addAll(this.linkButtons);
        int commonWidth = Math.max(this.bottomButtons.getWidth(0) / this.bottomButtons.size(), this.linkButtons.getWidth(0) / this.linkButtons.size());
        this.bottomButtons.setWidths(commonWidth);
        this.linkButtons.setWidths(commonWidth);
        this.buttonDiscord = (Button)this.method_37063((class_364)new Button("", button -> FullscreenActions.discord()));
        this.buttonDiscord.setDefaultStyle(false);
        this.buttonDiscord.setDrawBackground(false);
        this.buttonDiscord.setDrawFrame(false);
        this.buttonDiscord.setTooltip(Constants.getString("jm.common.discord"), Constants.getString("jm.common.discord.tooltip"));
        this.buttonDiscord.method_25358(this.discordLogo.getWidth() / this.scaleFactor);
        this.buttonDiscord.setHeight(this.discordLogo.getHeight() / this.scaleFactor);
        this.logoButtons = new ButtonList(this.buttonDiscord);
        this.logoButtons.setLayout(ButtonList.Layout.Horizontal, ButtonList.Direction.LeftToRight);
        this.logoButtons.setHeights(this.discordLogo.getHeight() / this.scaleFactor);
        this.logoButtons.setWidths(this.discordLogo.getWidth() / this.scaleFactor);
        this.getRenderables().addAll(this.logoButtons);
        this.infoButtons.forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.method_37063((class_364)x$0);
        });
    }

    @Override
    protected void layoutButtons(class_332 graphics) {
        boolean movePeople;
        if (this.getRenderables().isEmpty()) {
            this.method_25426();
        }
        double mx = this.field_22787.field_1729.method_1603() * (double)this.field_22789 / (double)this.field_22787.method_22683().method_4480();
        double my = (double)this.field_22790 - this.field_22787.field_1729.method_1604() * (double)this.field_22790 / (double)this.field_22787.method_22683().method_4507() - 1.0;
        int hgap = 4;
        int vgap = 4;
        class_327 fr = this.getFontRenderer();
        int estimatedInfoHeight = this.infoButtons.getHeight(4);
        int estimatedButtonsHeight = (this.buttonClose.method_25364() + 4) * 3 + 4;
        Objects.requireNonNull(this);
        int centerHeight = this.field_22790 - 35 - estimatedButtonsHeight;
        Objects.requireNonNull(fr);
        int lineHeight = (int)(9.0 * 1.4);
        int bx = this.field_22789 / 2;
        int by = 0;
        boolean bl = movePeople = System.currentTimeMillis() - this.lastPeopleMove > 20L;
        if (movePeople) {
            this.lastPeopleMove = System.currentTimeMillis();
        }
        Rectangle2D.Double screenBounds = new Rectangle2D.Double(0.0, 0.0, this.field_22789, this.field_22790);
        if (!this.devButtons.isEmpty()) {
            for (SplashPerson dev : this.devs) {
                if (dev.getButton().mouseOver(mx, my)) {
                    dev.randomizeVector();
                }
                this.drawPerson(graphics, by, lineHeight, dev);
                if (!movePeople) continue;
                dev.avoid(this.devs);
                dev.adjustVector(screenBounds);
            }
        }
        if (!this.peopleButtons.isEmpty()) {
            for (SplashPerson peep : this.people) {
                if (peep.getButton().mouseOver(mx, my)) {
                    peep.randomizeVector();
                }
                this.drawPerson(graphics, by, lineHeight, peep);
                if (!movePeople) continue;
                peep.avoid(this.devs);
                peep.adjustVector(screenBounds);
            }
        }
        if (!this.infoButtons.isEmpty()) {
            Objects.requireNonNull(this);
            int topY = by = 35 + (centerHeight - estimatedInfoHeight) / 2;
            by = (int)((double)by + (double)lineHeight * 1.5);
            this.infoButtons.layoutCenteredVertical(bx - ((Button)((Object)this.infoButtons.get(0))).method_25368() / 2, by + this.infoButtons.getHeight(0) / 2, true, 0);
            int listX = this.infoButtons.getLeftX() - 10;
            int listY = topY - 5;
            int listWidth = this.infoButtons.getRightX() + 10 - listX;
            int listHeight = this.infoButtons.getBottomY() + 5 - listY;
            DrawUtil.drawGradientRect(graphics.method_51448(), listX - 1, listY - 1, listWidth + 2, listHeight + 2, 0xC0C0C0, 0.8f, 0xC0C0C0, 0.8f);
            DrawUtil.drawGradientRect(graphics.method_51448(), listX, listY, listWidth, listHeight, 0x404040, 1.0f, 0, 1.0f);
            DrawUtil.drawLabel(graphics, Constants.getString("jm.common.splash_whatisnew"), bx, topY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 65535, 1.0f, 1.0, true);
        }
        int rowHeight = this.buttonOptions.method_25364() + 4;
        by = this.field_22790 - rowHeight - 4;
        this.bottomButtons.layoutCenteredHorizontal(bx, by, true, 4);
        this.linkButtons.layoutCenteredHorizontal(bx, by -= rowHeight, true, 4);
        this.logoButtons.layoutCenteredHorizontal(bx, by -= 4 + this.logoButtons.getHeight(), true, 6);
        DrawUtil.drawImage(graphics.method_51448(), this.discordLogo, this.buttonDiscord.method_46426(), this.buttonDiscord.method_46427(), false, 1.0f / (float)this.scaleFactor, 0.0);
    }

    protected int drawPerson(class_332 graphics, int by, int lineHeight, SplashPerson person) {
        float scale = 1.0f;
        Button button = person.getButton();
        int imgSize = (int)((float)person.getSkin().getWidth() * scale);
        int imgY = button.method_46427() - 2;
        int imgX = button.getCenterX() - imgSize / 2;
        if (!(person instanceof SplashPerson.Fake)) {
            DrawUtil.drawGradientRect(graphics.method_51448(), imgX - 1, imgY - 1, imgSize + 2, imgSize + 2, 0, 0.4f, 0, 0.8f);
            DrawUtil.drawImage(graphics.method_51448(), person.getSkin(), 1.0f, imgX, imgY, false, scale, 0.0);
        } else {
            float size = Math.min((float)person.getSkin().getWidth() * scale, 24.0f * scale);
            DrawUtil.drawQuad(graphics.method_51448(), person.getSkin(), 0xFFFFFF, 1.0f, imgX, imgY, size, size, false, 0.0);
        }
        by = imgY + imgSize + 4;
        String name = person.name.trim();
        String name2 = null;
        boolean twoLineName = name.contains(" ");
        if (twoLineName) {
            String[] parts = person.name.split(" ");
            name = parts[0];
            name2 = parts[1];
        }
        DrawUtil.drawLabel(graphics, name, button.getCenterX(), by, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 0xFFFFFF, 1.0f, scale, true);
        by += lineHeight;
        if (name2 != null) {
            DrawUtil.drawLabel(graphics, name2, button.getCenterX(), by, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 0xFFFFFF, 1.0f, scale, true);
            by += lineHeight;
        }
        DrawUtil.drawLabel(graphics, person.title, button.getCenterX(), by, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 65280, 1.0f, scale, true);
        return by += lineHeight;
    }

    @Override
    public boolean method_25400(char typedChar, int keyCode) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
            }
        }
        return true;
    }

    class SplashInfoButton
    extends Button {
        final SplashInfo.Line infoLine;

        public SplashInfoButton(SplashInfo.Line infoLine, class_4185.class_4241 pressable) {
            super(infoLine.label, pressable);
            this.infoLine = infoLine;
        }
    }
}

