/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class PersistentPlayerWaystoneData
implements IPlayerWaystoneData {
    private static final String TAG_NAME = "WaystonesData";
    private static final String ACTIVATED_WAYSTONES = "Waystones";
    private static final String INVENTORY_BUTTON_COOLDOWN_UNTIL = "InventoryButtonCooldownUntilNew";
    private static final String WARP_STONE_COOLDOWN_UNTIL = "WarpStoneCooldownUntilNew";

    @Override
    public void activateWaystone(class_1657 player, IWaystone waystone) {
        class_2499 activatedWaystonesData = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        activatedWaystonesData.method_10531(0, (class_2520)class_2519.method_23256((String)waystone.getWaystoneUid().toString()));
    }

    @Override
    public boolean isWaystoneActivated(class_1657 player, IWaystone waystone) {
        class_2499 activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        String waystoneUid = waystone.getWaystoneUid().toString();
        for (class_2520 activatedWaystone : activatedWaystones) {
            if (!waystoneUid.equals(activatedWaystone.method_10714())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IWaystone> getWaystones(class_1657 player) {
        class_2499 activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        ArrayList<IWaystone> waystones = new ArrayList<IWaystone>();
        Iterator iterator = activatedWaystones.iterator();
        while (iterator.hasNext()) {
            class_2520 activatedWaystone = (class_2520)iterator.next();
            WaystoneProxy proxy = new WaystoneProxy(player.method_5682(), UUID.fromString(activatedWaystone.method_10714()));
            if (proxy.isValid()) {
                waystones.add(proxy);
                continue;
            }
            iterator.remove();
        }
        return waystones;
    }

    @Override
    public void swapWaystoneSorting(class_1657 player, int index, int otherIndex) {
        class_2499 activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        if (otherIndex == -1) {
            class_2520 waystone = activatedWaystones.method_10536(index);
            activatedWaystones.method_10531(0, waystone);
        } else if (otherIndex == activatedWaystones.size()) {
            class_2520 waystone = activatedWaystones.method_10536(index);
            activatedWaystones.add((Object)waystone);
        } else {
            Collections.swap(activatedWaystones, index, otherIndex);
        }
    }

    @Override
    public void deactivateWaystone(class_1657 player, IWaystone waystone) {
        class_2487 data = PersistentPlayerWaystoneData.getWaystonesData(player);
        class_2499 activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(data);
        String waystoneUid = waystone.getWaystoneUid().toString();
        for (int i = activatedWaystones.size() - 1; i >= 0; --i) {
            class_2520 activatedWaystone = activatedWaystones.method_10534(i);
            if (!waystoneUid.equals(activatedWaystone.method_10714())) continue;
            activatedWaystones.method_10536(i);
            break;
        }
    }

    @Override
    public long getWarpStoneCooldownUntil(class_1657 player) {
        return PersistentPlayerWaystoneData.getWaystonesData(player).method_10537(WARP_STONE_COOLDOWN_UNTIL);
    }

    @Override
    public void setWarpStoneCooldownUntil(class_1657 player, long timeStamp) {
        PersistentPlayerWaystoneData.getWaystonesData(player).method_10544(WARP_STONE_COOLDOWN_UNTIL, timeStamp);
    }

    @Override
    public long getInventoryButtonCooldownUntil(class_1657 player) {
        return PersistentPlayerWaystoneData.getWaystonesData(player).method_10537(INVENTORY_BUTTON_COOLDOWN_UNTIL);
    }

    @Override
    public void setInventoryButtonCooldownUntil(class_1657 player, long timeStamp) {
        PersistentPlayerWaystoneData.getWaystonesData(player).method_10544(INVENTORY_BUTTON_COOLDOWN_UNTIL, timeStamp);
    }

    private static class_2499 getActivatedWaystonesData(class_2487 data) {
        class_2499 list = data.method_10554(ACTIVATED_WAYSTONES, 8);
        data.method_10566(ACTIVATED_WAYSTONES, (class_2520)list);
        return list;
    }

    private static class_2487 getWaystonesData(class_1657 player) {
        class_2487 persistedData = Balm.getHooks().getPersistentData(player);
        class_2487 compound = persistedData.method_10562(TAG_NAME);
        persistedData.method_10566(TAG_NAME, (class_2520)compound);
        return compound;
    }
}

