/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.flipkart.zjsonpatch.InvalidJsonPatchException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

enum Operation {
    ADD("add"),
    REMOVE("remove"),
    REPLACE("replace"),
    MOVE("move"),
    COPY("copy"),
    TEST("test");

    private static final Map<String, Operation> OPS;
    private String rfcName;

    private static Map<String, Operation> createImmutableMap() {
        HashMap<String, Operation> map2 = new HashMap<String, Operation>();
        map2.put(Operation.ADD.rfcName, ADD);
        map2.put(Operation.REMOVE.rfcName, REMOVE);
        map2.put(Operation.REPLACE.rfcName, REPLACE);
        map2.put(Operation.MOVE.rfcName, MOVE);
        map2.put(Operation.COPY.rfcName, COPY);
        map2.put(Operation.TEST.rfcName, TEST);
        return Collections.unmodifiableMap(map2);
    }

    private Operation(String rfcName) {
        this.rfcName = rfcName;
    }

    public static Operation fromRfcName(String rfcName) throws InvalidJsonPatchException {
        if (rfcName == null) {
            throw new InvalidJsonPatchException("rfcName cannot be null");
        }
        Operation op = OPS.get(rfcName.toLowerCase());
        if (op == null) {
            throw new InvalidJsonPatchException("unknown / unsupported operation " + rfcName);
        }
        return op;
    }

    public String rfcName() {
        return this.rfcName;
    }

    static {
        OPS = Operation.createImmutableMap();
    }
}

