/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.jackson;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CustomEnumDefinitionProvider
implements CustomDefinitionProviderV2 {
    private final boolean checkForJsonValueAnnotatedMethod;
    private final boolean checkForJsonPropertyAnnotations;

    public CustomEnumDefinitionProvider(boolean checkForJsonValueAnnotatedMethod, boolean checkForJsonPropertyAnnotations) {
        this.checkForJsonValueAnnotatedMethod = checkForJsonValueAnnotatedMethod;
        this.checkForJsonPropertyAnnotations = checkForJsonPropertyAnnotations;
    }

    @Override
    public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
        Object[] enumConstants = javaType.getErasedType().getEnumConstants();
        if (enumConstants == null || enumConstants.length == 0) {
            return null;
        }
        List<Object> serializedJsonValues = null;
        if (this.checkForJsonValueAnnotatedMethod) {
            serializedJsonValues = this.getSerializedValuesFromJsonValue(javaType, enumConstants, context);
        }
        if (serializedJsonValues == null && this.checkForJsonPropertyAnnotations) {
            serializedJsonValues = this.getSerializedValuesFromJsonProperty(javaType, enumConstants);
        }
        if (serializedJsonValues == null) {
            return null;
        }
        ObjectNode customNode = context.getGeneratorConfig().createObjectNode().put(context.getKeyword(SchemaKeyword.TAG_TYPE), context.getKeyword(SchemaKeyword.TAG_TYPE_STRING));
        AttributeCollector standardAttributeCollector = new AttributeCollector(context.getGeneratorConfig().getObjectMapper());
        standardAttributeCollector.setEnum(customNode, serializedJsonValues, context);
        return new CustomDefinition(customNode);
    }

    protected List<Object> getSerializedValuesFromJsonValue(ResolvedType javaType, Object[] enumConstants, SchemaGenerationContext context) {
        ResolvedMethod jsonValueAnnotatedEnumMethod = this.getJsonValueAnnotatedMethod(javaType, context);
        if (jsonValueAnnotatedEnumMethod == null) {
            return null;
        }
        try {
            ArrayList<Object> serializedJsonValues = new ArrayList<Object>(enumConstants.length);
            for (Object enumConstant : enumConstants) {
                serializedJsonValues.add(((Method)jsonValueAnnotatedEnumMethod.getRawMember()).invoke(enumConstant, new Object[0]));
            }
            return serializedJsonValues;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            return null;
        }
    }

    protected ResolvedMethod getJsonValueAnnotatedMethod(ResolvedType javaType, SchemaGenerationContext context) {
        ResolvedMethod[] memberMethods = context.getTypeContext().resolveWithMembers(javaType).getMemberMethods();
        Set jsonValueAnnotatedMethods = Stream.of(memberMethods).filter(method -> method.getArgumentCount() == 0).filter(method -> Optional.ofNullable(method.getAnnotations().get(JsonValue.class)).map(JsonValue::value).orElse(false)).collect(Collectors.toSet());
        if (jsonValueAnnotatedMethods.size() == 1) {
            return (ResolvedMethod)jsonValueAnnotatedMethods.iterator().next();
        }
        return null;
    }

    protected List<String> getSerializedValuesFromJsonProperty(ResolvedType javaType, Object[] enumConstants) {
        try {
            ArrayList<String> serializedJsonValues = new ArrayList<String>(enumConstants.length);
            for (Object enumConstant : enumConstants) {
                String enumValueName = ((Enum)enumConstant).name();
                JsonProperty annotation = javaType.getErasedType().getDeclaredField(enumValueName).getAnnotation(JsonProperty.class);
                if (annotation == null) {
                    return null;
                }
                serializedJsonValues.add("".equals(annotation.value()) ? enumValueName : annotation.value());
            }
            return serializedJsonValues;
        }
        catch (NoSuchFieldException | SecurityException ex) {
            return null;
        }
    }
}

