/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.Lazy;
import dagger.internal.Preconditions;
import javax.inject.Provider;

public final class DoubleCheck<T>
implements Provider<T>,
Lazy<T> {
    private static final Object UNINITIALIZED = new Object();
    private volatile Provider<T> provider;
    private volatile Object instance = UNINITIALIZED;

    private DoubleCheck(Provider<T> provider) {
        assert (provider != null);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object result2 = this.instance;
        if (result2 == UNINITIALIZED) {
            DoubleCheck doubleCheck = this;
            synchronized (doubleCheck) {
                result2 = this.instance;
                if (result2 == UNINITIALIZED) {
                    result2 = this.provider.get();
                    this.instance = DoubleCheck.reentrantCheck(this.instance, result2);
                    this.provider = null;
                }
            }
        }
        return (T)result2;
    }

    private static Object reentrantCheck(Object currentInstance, Object newInstance) {
        boolean isReentrant;
        boolean bl = isReentrant = currentInstance != UNINITIALIZED;
        if (isReentrant && currentInstance != newInstance) {
            throw new IllegalStateException("Scoped provider was invoked recursively returning different results: " + currentInstance + " & " + newInstance + ". This is likely due to a circular dependency.");
        }
        return newInstance;
    }

    public static <P extends Provider<T>, T> Provider<T> provider(P delegate) {
        Preconditions.checkNotNull(delegate);
        if (delegate instanceof DoubleCheck) {
            return delegate;
        }
        return new DoubleCheck<T>(delegate);
    }

    public static <P extends Provider<T>, T> Lazy<T> lazy(P provider) {
        if (provider instanceof Lazy) {
            Lazy lazy = (Lazy)((Object)provider);
            return lazy;
        }
        return new DoubleCheck<T>(Preconditions.checkNotNull(provider));
    }
}

