/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0016\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lkotlinx/coroutines/internal/ArrayQueue;", "", "T", "element", "", "addLast", "(Ljava/lang/Object;)V", "clear", "()V", "ensureCapacity", "removeFirstOrNull", "()Ljava/lang/Object;", "", "elements", "[Ljava/lang/Object;", "", "head", "I", "", "isEmpty", "()Z", "tail", "<init>", "kotlinx-coroutines-core"})
public class ArrayQueue<T> {
    @NotNull
    private Object[] elements = new Object[16];
    private int head;
    private int tail;

    public final boolean isEmpty() {
        return this.head == this.tail;
    }

    public final void addLast(@NotNull T element) {
        this.elements[this.tail] = element;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.ensureCapacity();
        }
    }

    @Nullable
    public final T removeFirstOrNull() {
        if (this.head == this.tail) {
            return null;
        }
        Object element = this.elements[this.head];
        this.elements[this.head] = null;
        this.head = this.head + 1 & this.elements.length - 1;
        Object object = element;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type T of kotlinx.coroutines.internal.ArrayQueue");
        }
        return (T)object;
    }

    public final void clear() {
        this.head = 0;
        this.tail = 0;
        this.elements = new Object[this.elements.length];
    }

    private final void ensureCapacity() {
        int currentSize = this.elements.length;
        int newCapacity = currentSize << 1;
        Object[] newElements = new Object[newCapacity];
        ArraysKt.copyInto$default((Object[])this.elements, (Object[])newElements, (int)0, (int)this.head, (int)0, (int)10, null);
        ArraysKt.copyInto$default((Object[])this.elements, (Object[])newElements, (int)(this.elements.length - this.head), (int)0, (int)this.head, (int)4, null);
        this.elements = newElements;
        this.head = 0;
        this.tail = currentSize;
    }
}

