/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.CoroutineStackFrame;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CopyableThrowable;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.internal.ExceptionsConstructorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000d\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0010\u001a\u001b\u0010\u0004\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a;\u0010\f\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00028\u00002\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\nH\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a%\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\n2\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a3\u0010\u0016\u001a\u00020\u00152\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u00132\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u001b\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0006H\u0080H\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a-\u0010\u001c\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u00002\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u000fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a!\u0010\u001e\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a.\u0010\u001e\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u00002\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030 H\u0080\b\u00a2\u0006\u0004\b\u001e\u0010!\u001a#\u0010\"\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\"\u0010\u001f\u001a\"\u0010#\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u0000H\u0080\b\u00a2\u0006\u0004\b#\u0010\u001f\u001a!\u0010$\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b$\u0010\u001f\u001a3\u0010&\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u00130%\"\b\b\u0000\u0010\u0007*\u00020\u0006*\u00028\u0000H\u0002\u00a2\u0006\u0004\b&\u0010'\u001a#\u0010*\u001a\u00020)*\u00060\u0002j\u0002`\u00032\n\u0010(\u001a\u00060\u0002j\u0002`\u0003H\u0002\u00a2\u0006\u0004\b*\u0010+\u001a%\u0010.\u001a\u00020-*\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u00132\u0006\u0010,\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b.\u0010/\u001a\u001b\u00100\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b0\u00101\u001a\u0017\u00102\u001a\u00020)*\u00060\u0002j\u0002`\u0003H\u0000\u00a2\u0006\u0004\b2\u00103\u001a\u001d\u00104\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u0006*\u00028\u0000H\u0002\u00a2\u0006\u0004\b4\u0010\u001f\"\u0014\u00105\u001a\u00020\u00008\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b5\u00106\"\u001c\u00108\u001a\n 7*\u0004\u0018\u00010\u00000\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00106\"\u0014\u00109\u001a\u00020\u00008\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b9\u00106\"\u001c\u0010:\u001a\n 7*\u0004\u0018\u00010\u00000\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u00106*\f\b\u0000\u0010;\"\u00020\u000e2\u00020\u000e*\f\b\u0000\u0010<\"\u00020\u00022\u00020\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006="}, d2={"", "message", "Ljava/lang/StackTraceElement;", "Lkotlinx/coroutines/internal/StackTraceElement;", "artificialFrame", "(Ljava/lang/String;)Ljava/lang/StackTraceElement;", "", "E", "cause", "result", "Ljava/util/ArrayDeque;", "resultStackTrace", "createFinalException", "(Ljava/lang/Throwable;Ljava/lang/Throwable;Ljava/util/ArrayDeque;)Ljava/lang/Throwable;", "Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "Lkotlinx/coroutines/internal/CoroutineStackFrame;", "continuation", "createStackTrace", "(Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;)Ljava/util/ArrayDeque;", "", "recoveredStacktrace", "", "mergeRecoveredTraces", "([Ljava/lang/StackTraceElement;Ljava/util/ArrayDeque;)V", "exception", "", "recoverAndThrow", "(Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "recoverFromStackFrame", "(Ljava/lang/Throwable;Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;)Ljava/lang/Throwable;", "recoverStackTrace", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Throwable;", "tryCopyAndVerify", "unwrap", "unwrapImpl", "Lkotlin/Pair;", "causeAndStacktrace", "(Ljava/lang/Throwable;)Lkotlin/Pair;", "e", "", "elementWiseEquals", "(Ljava/lang/StackTraceElement;Ljava/lang/StackTraceElement;)Z", "methodName", "", "frameIndex", "([Ljava/lang/StackTraceElement;Ljava/lang/String;)I", "initCause", "(Ljava/lang/Throwable;Ljava/lang/Throwable;)V", "isArtificial", "(Ljava/lang/StackTraceElement;)Z", "sanitizeStackTrace", "baseContinuationImplClass", "Ljava/lang/String;", "kotlin.jvm.PlatformType", "baseContinuationImplClassName", "stackTraceRecoveryClass", "stackTraceRecoveryClassName", "CoroutineStackFrame", "StackTraceElement", "kotlinx-coroutines-core"})
public final class StackTraceRecoveryKt {
    @NotNull
    private static final String baseContinuationImplClass = "kotlin.coroutines.jvm.internal.BaseContinuationImpl";
    @NotNull
    private static final String stackTraceRecoveryClass = "kotlinx.coroutines.internal.StackTraceRecoveryKt";
    private static final String baseContinuationImplClassName;
    private static final String stackTraceRecoveryClassName;

    @NotNull
    public static final <E extends Throwable> E recoverStackTrace(@NotNull E exception) {
        if (!DebugKt.getRECOVER_STACK_TRACES()) {
            return exception;
        }
        E e = StackTraceRecoveryKt.tryCopyAndVerify(exception);
        if (e == null) {
            return exception;
        }
        E copy = e;
        return StackTraceRecoveryKt.sanitizeStackTrace(copy);
    }

    private static final <E extends Throwable> E sanitizeStackTrace(E $this$sanitizeStackTrace) {
        StackTraceElement[] stackTrace = $this$sanitizeStackTrace.getStackTrace();
        int size = stackTrace.length;
        int lastIntrinsic = StackTraceRecoveryKt.frameIndex(stackTrace, stackTraceRecoveryClassName);
        int startIndex = lastIntrinsic + 1;
        int endIndex = StackTraceRecoveryKt.frameIndex(stackTrace, baseContinuationImplClassName);
        int adjustment = endIndex == -1 ? 0 : size - endIndex;
        int n = size - lastIntrinsic - adjustment;
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            stackTraceElementArray[n2] = n2 == 0 ? StackTraceRecoveryKt.artificialFrame("Coroutine boundary") : stackTrace[startIndex + n2 - 1];
        }
        StackTraceElement[] trace = stackTraceElementArray;
        $this$sanitizeStackTrace.setStackTrace(trace);
        return $this$sanitizeStackTrace;
    }

    @NotNull
    public static final <E extends Throwable> E recoverStackTrace(@NotNull E exception, @NotNull Continuation<?> continuation) {
        boolean $i$f$recoverStackTrace = false;
        if (!DebugKt.getRECOVER_STACK_TRACES() || !(continuation instanceof CoroutineStackFrame)) {
            return exception;
        }
        return (E)StackTraceRecoveryKt.recoverFromStackFrame(exception, (CoroutineStackFrame)continuation);
    }

    private static final <E extends Throwable> E recoverFromStackFrame(E exception, CoroutineStackFrame continuation) {
        Pair<E, StackTraceElement[]> pair = StackTraceRecoveryKt.causeAndStacktrace(exception);
        Throwable cause = (Throwable)pair.component1();
        StackTraceElement[] recoveredStacktrace = (StackTraceElement[])pair.component2();
        Throwable throwable = StackTraceRecoveryKt.tryCopyAndVerify(cause);
        if (throwable == null) {
            return exception;
        }
        Throwable newException = throwable;
        ArrayDeque<StackTraceElement> stacktrace = StackTraceRecoveryKt.createStackTrace(continuation);
        if (stacktrace.isEmpty()) {
            return exception;
        }
        if (cause != exception) {
            StackTraceRecoveryKt.mergeRecoveredTraces(recoveredStacktrace, stacktrace);
        }
        return (E)StackTraceRecoveryKt.createFinalException(cause, newException, stacktrace);
    }

    private static final <E extends Throwable> E tryCopyAndVerify(E exception) {
        E e = ExceptionsConstructorKt.tryCopyException(exception);
        if (e == null) {
            return null;
        }
        E newException = e;
        if (!(exception instanceof CopyableThrowable) && !Intrinsics.areEqual((Object)newException.getMessage(), (Object)exception.getMessage())) {
            return null;
        }
        return newException;
    }

    private static final <E extends Throwable> E createFinalException(E cause, E result2, ArrayDeque<StackTraceElement> resultStackTrace) {
        resultStackTrace.addFirst(StackTraceRecoveryKt.artificialFrame("Coroutine boundary"));
        StackTraceElement[] causeTrace = cause.getStackTrace();
        int size = StackTraceRecoveryKt.frameIndex(causeTrace, baseContinuationImplClassName);
        if (size == -1) {
            Collection $this$toTypedArray$iv = resultStackTrace;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            StackTraceElement[] stackTraceElementArray = thisCollection$iv.toArray(new StackTraceElement[0]);
            if (stackTraceElementArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            result2.setStackTrace(stackTraceElementArray);
            return result2;
        }
        StackTraceElement[] mergedStackTrace = new StackTraceElement[resultStackTrace.size() + size];
        for (int i = 0; i < size; ++i) {
            mergedStackTrace[i] = causeTrace[i];
        }
        Iterator<StackTraceElement> iterator2 = resultStackTrace.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            StackTraceElement element;
            int index = n++;
            mergedStackTrace[size + index] = element = iterator2.next();
        }
        result2.setStackTrace(mergedStackTrace);
        return result2;
    }

    private static final <E extends Throwable> Pair<E, StackTraceElement[]> causeAndStacktrace(E $this$causeAndStacktrace) {
        Pair pair;
        Throwable cause = $this$causeAndStacktrace.getCause();
        if (cause != null && Intrinsics.areEqual(cause.getClass(), $this$causeAndStacktrace.getClass())) {
            boolean bl;
            StackTraceElement[] currentTrace;
            block5: {
                StackTraceElement[] $this$any$iv = currentTrace = $this$causeAndStacktrace.getStackTrace();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement element$iv;
                    StackTraceElement it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!StackTraceRecoveryKt.isArtificial(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                pair = TuplesKt.to((Object)cause, (Object)currentTrace);
            } else {
                boolean $i$f$emptyArray = false;
                pair = TuplesKt.to($this$causeAndStacktrace, (Object)new StackTraceElement[0]);
            }
        } else {
            boolean $i$f$emptyArray = false;
            pair = TuplesKt.to($this$causeAndStacktrace, (Object)new StackTraceElement[0]);
        }
        return pair;
    }

    private static final void mergeRecoveredTraces(StackTraceElement[] recoveredStacktrace, ArrayDeque<StackTraceElement> result2) {
        int lastFrameIndex;
        int n;
        block4: {
            StackTraceElement[] $this$indexOfFirst$iv = recoveredStacktrace;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                StackTraceElement it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!StackTraceRecoveryKt.isArtificial(it)) continue;
                n = index$iv;
                break block4;
            }
            n = -1;
        }
        int startIndex = n + 1;
        int i = lastFrameIndex = recoveredStacktrace.length - 1;
        if (startIndex <= i) {
            while (true) {
                StackTraceElement element;
                if (StackTraceRecoveryKt.elementWiseEquals(element = recoveredStacktrace[i], result2.getLast())) {
                    result2.removeLast();
                }
                result2.addFirst(recoveredStacktrace[i]);
                if (i == startIndex) break;
                --i;
            }
        }
    }

    @Nullable
    public static final Object recoverAndThrow(@NotNull Throwable exception, @NotNull Continuation<?> $completion) {
        boolean $i$f$recoverAndThrow = false;
        if (!DebugKt.getRECOVER_STACK_TRACES()) {
            throw exception;
        }
        Continuation<?> it = $completion;
        boolean bl = false;
        if (!(it instanceof CoroutineStackFrame)) {
            throw exception;
        }
        throw StackTraceRecoveryKt.recoverFromStackFrame(exception, (CoroutineStackFrame)it);
    }

    private static final Object recoverAndThrow$$forInline(Throwable exception, Continuation<?> $completion) {
        boolean $i$f$recoverAndThrow = false;
        if (!DebugKt.getRECOVER_STACK_TRACES()) {
            throw exception;
        }
        InlineMarker.mark((int)0);
        Continuation<?> it = $completion;
        boolean bl = false;
        if (!(it instanceof CoroutineStackFrame)) {
            throw exception;
        }
        throw StackTraceRecoveryKt.recoverFromStackFrame(exception, (CoroutineStackFrame)it);
    }

    @NotNull
    public static final <E extends Throwable> E unwrap(@NotNull E exception) {
        boolean $i$f$unwrap = false;
        return !DebugKt.getRECOVER_STACK_TRACES() ? exception : StackTraceRecoveryKt.unwrapImpl(exception);
    }

    @NotNull
    public static final <E extends Throwable> E unwrapImpl(@NotNull E exception) {
        boolean bl;
        Throwable cause;
        block3: {
            cause = exception.getCause();
            if (cause == null || !Intrinsics.areEqual(cause.getClass(), exception.getClass())) {
                return exception;
            }
            StackTraceElement[] $this$any$iv = exception.getStackTrace();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement element$iv;
                StackTraceElement it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StackTraceRecoveryKt.isArtificial(it)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            return (E)cause;
        }
        return exception;
    }

    private static final ArrayDeque<StackTraceElement> createStackTrace(CoroutineStackFrame continuation) {
        CoroutineStackFrame coroutineStackFrame;
        CoroutineStackFrame coroutineStackFrame2;
        ArrayDeque<StackTraceElement> stack = new ArrayDeque<StackTraceElement>();
        StackTraceElement stackTraceElement = continuation.getStackTraceElement();
        if (stackTraceElement != null) {
            StackTraceElement it = stackTraceElement;
            boolean bl = false;
            stack.add(it);
        }
        CoroutineStackFrame last2 = continuation;
        while ((coroutineStackFrame2 = (coroutineStackFrame = last2) instanceof CoroutineStackFrame ? coroutineStackFrame : null) != null && (coroutineStackFrame2 = coroutineStackFrame2.getCallerFrame()) != null) {
            StackTraceElement it;
            last2 = coroutineStackFrame2;
            if (last2.getStackTraceElement() == null) continue;
            boolean bl = false;
            stack.add(it);
        }
        return stack;
    }

    @InternalCoroutinesApi
    @NotNull
    public static final StackTraceElement artificialFrame(@NotNull String message) {
        return new StackTraceElement("\b\b\b(" + message, "\b", "\b", -1);
    }

    public static final boolean isArtificial(@NotNull StackTraceElement $this$isArtificial) {
        return StringsKt.startsWith$default((String)$this$isArtificial.getClassName(), (String)"\b\b\b", (boolean)false, (int)2, null);
    }

    private static final int frameIndex(StackTraceElement[] $this$frameIndex, String methodName) {
        int n;
        block1: {
            StackTraceElement[] $this$indexOfFirst$iv = $this$frameIndex;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                StackTraceElement it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)methodName, (Object)it.getClassName())) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        return n;
    }

    private static final boolean elementWiseEquals(StackTraceElement $this$elementWiseEquals, StackTraceElement e) {
        return $this$elementWiseEquals.getLineNumber() == e.getLineNumber() && Intrinsics.areEqual((Object)$this$elementWiseEquals.getMethodName(), (Object)e.getMethodName()) && Intrinsics.areEqual((Object)$this$elementWiseEquals.getFileName(), (Object)e.getFileName()) && Intrinsics.areEqual((Object)$this$elementWiseEquals.getClassName(), (Object)e.getClassName());
    }

    public static final void initCause(@NotNull Throwable $this$initCause, @NotNull Throwable cause) {
        $this$initCause.initCause(cause);
    }

    public static /* synthetic */ void CoroutineStackFrame$annotations() {
    }

    public static /* synthetic */ void StackTraceElement$annotations() {
    }

    static {
        Object object;
        Object object2;
        Object object3;
        Object $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$22;
        try {
            boolean $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$22 = false;
            $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$22 = Result.constructor-impl((Object)Class.forName(baseContinuationImplClass).getCanonicalName());
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)$i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$22);
        if (throwable == null) {
            object3 = $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$22;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object3 = baseContinuationImplClass;
        }
        baseContinuationImplClassName = (String)object3;
        try {
            boolean bl = false;
            object2 = Result.constructor-impl((Object)Class.forName(stackTraceRecoveryClass).getCanonicalName());
        }
        catch (Throwable it) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it));
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 == null) {
            object = object2;
        } else {
            it = throwable2;
            boolean bl = false;
            object = stackTraceRecoveryClass;
        }
        stackTraceRecoveryClassName = (String)object;
    }
}

